
<?php $__env->startSection('title','Dashboard'); ?>
<?php $__env->startPush('styles'); ?>
    <link href="plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css"/>
    <link href="css/daterangepicker.min.css" rel="stylesheet" type="text/css"/>
    <style>
        .today-btn {
            border-radius: 5px 0 0 5px !important;
        }

        .week-btn, .month-btn {
            border-radius: 0 !important;
        }

        .year-btn {
            border-radius: 0 5px 5px 0 !important;
        }

        .icon {
            width: 40px;
            height: 40px;
        }

        .business-analytics {
            max-width: 24%;
            background-color: #fff;
            margin-bottom: 10px;
            border-radius: 10px;
            padding: 40px 30px 20px;
            position: relative;
            border: 1px solid rgba(180, 208, 224, 0.5);
            box-shadow: 0px 5px 10px rgba(0, 0, 0, 0.05);
            height: 100%;
            transition: all 0.3s ease;
        }

        .business-analytics__subtitle {
            font-size: 17px;
            margin-bottom: 10px;
            font-weight: 600;
        }

        .business-analytics__title {
            font-weight: 500;
            font-size: 24px;
        }

        .business-analytics__img {
            position: absolute;
            inset-block-start: 16px;
            inset-inline-end: 16px;
        }

        .order-stats {
            font-family: 'Font Awesome 5 Free';
            background-color: #dfdfe6;
            border-radius: 10px;
            padding: 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            /*gap: 10px;*/
            /*height: 100%;*/
            transition: all 0.3s ease;
        }

        .order-stats2 {
            max-width: 23%;
            background-color: #efedeb;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 15px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            transition: all 0.3s ease;
        }

        .order-stats__content {
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .order-stats__title {
            /*color: #0661cb;*/
            font-size: 18px;
            font-weight: 700;
        }

        .order-stats__subtitle {
            font-weight: 600;
            font-size: 15px;
            color: #334257;
            margin-bottom: 0;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
<?php
    $date = date('Y-m-d');
?>
    <?php if(\Illuminate\Support\Facades\Auth::user()->role_id == 1): ?>

        
        <div class="d-flex flex-column-fluid">
            <div class="container-fluid">
                <h2 class="text-left display-4 text-primary"><strong>Cash</strong></h2>
                <div class="row order-stats">
                    <?php
                        $cash_in_hands = \Modules\CashInHand\Entities\CashInHand::where('status',1)->get();

                    ?>
                    <?php $__currentLoopData = $cash_in_hands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cash_in_hand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $coa = \Modules\Account\Entities\ChartOfAccount::where('cash_id', $cash_in_hand->id)->where('status', 1)->first();

                            if ($coa){
                                $balance = \Modules\Account\Entities\Transaction::where('chart_of_account_id', $coa->id)->where('voucher_date',$date)->groupBy('chart_of_account_id')->sum('debit');
                            } else {
                                $balance = 0;
                            }
                        ?>
                        <div class="col-md-4 business-analytics">
                            <div class="text-primary">
                                <h3 class="business-analytics__subtitle"><?php echo e($cash_in_hand->bank_name); ?></h3>
                                <h3 class="business-analytics__title" id=""><?php echo e($balance); ?> ৳</h3>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>
            </div>
        </div>

        
        <div class="d-flex flex-column-fluid">
            <div class="container-fluid">
                <h2 class="text-left mt-12 display-4 text-primary"><strong>Banks</strong></h2>
                <div class="row order-stats">
                    <?php
                        $banks = \Modules\Bank\Entities\Bank::where('status',1)->get();
                    ?>
                    <?php $__currentLoopData = $banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $coa = \Modules\Account\Entities\ChartOfAccount::where('bank_id', $bank->id)->where('status', 1)->first();
                            if ($coa) {
                                $balance = \Modules\Account\Entities\Transaction::where('chart_of_account_id', $coa->id)->where('voucher_date',$date)->groupBy('chart_of_account_id')->sum('debit');
                            } else {
                                $balance = 0;
                            }
                        ?>
                        <div class="col-md-4 business-analytics">
                            <div class="bg-white text-center py-3 text-primary bold">
                                <h3 class="business-analytics__subtitle"><?php echo e($bank->bank_name); ?></h3>
                                <h3 class="business-analytics__title" id=""><?php echo e($balance); ?> ৳</h3>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>

        
        <div class="d-flex flex-column-fluid">
            <div class="container-fluid">
                <h2 class="text-left mt-12 display-4 text-primary"><strong>Mobile Banks</strong></h2>
                <div class="row order-stats">
                    <?php
                        $mobile_banks = \Modules\MobileBank\Entities\MobileBank::where('status',1)->get();
                    ?>
                    <?php $__currentLoopData = $mobile_banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mobile_bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $coa_id = \Modules\Account\Entities\ChartOfAccount::where('mobile_bank_id', $mobile_bank->id)->select('id')->first();
                            if ($coa_id) {
                                $balance = \Modules\Account\Entities\Transaction::where('chart_of_account_id', $coa_id->id)->where('voucher_date',$date)->groupBy('chart_of_account_id')->sum('debit');
                            } else {
                                $balance = 0;
                            }
                        ?>
                        <div class="col-md-4 business-analytics">
                            <div class="text-primary">
                                <h3 class="business-analytics__subtitle"><?php echo e($mobile_bank->bank_name); ?></h3>
                                <h3 class="business-analytics__title" id=""><?php echo e($balance); ?> ৳</h3>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    <?php endif; ?>

<?php if(\Illuminate\Support\Facades\Auth::user()->role_id != 1): ?>

    
    <div class="d-flex flex-column-fluid">
        <div class="container-fluid">
            <h2 class="text-left display-4 text-primary"><strong>Cash</strong></h2>
            <div class="row order-stats">
                <?php
                    $cash_in_hands = \Modules\CashInHand\Entities\CashInHand::where('status',1)->where('employee_id', \Illuminate\Support\Facades\Auth::user()->id)->get();

                ?>
                <?php $__currentLoopData = $cash_in_hands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cash_in_hand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $coa = \Modules\Account\Entities\ChartOfAccount::where('cash_id', $cash_in_hand->id)->where('status', 1)->first();

                        if ($coa) {

                            $balance = \Modules\Account\Entities\Transaction::where('chart_of_account_id', $coa->id)->where('voucher_date',$date)->groupBy('chart_of_account_id')->sum('debit');
                        } else {
                            $balance = 0;
                        }
                    ?>
                    <div class="col-md-4 business-analytics">
                        <div class="text-primary">
                            <h3 class="business-analytics__subtitle"><?php echo e($cash_in_hand->bank_name); ?></h3>
                            <h3 class="business-analytics__title" id=""><?php echo e($balance); ?> ৳</h3>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </div>
        </div>
    </div>

    
    <div class="d-flex flex-column-fluid">
        <div class="container-fluid">
            <h2 class="text-left mt-12 display-4 text-primary"><strong>Banks</strong></h2>
            <div class="row order-stats">
                <?php
                    $banks = \Modules\Bank\Entities\Bank::where('status',1)->where('employee_id', \Illuminate\Support\Facades\Auth::user()->id)->get();
                ?>
                <?php $__currentLoopData = $banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $coa = \Modules\Account\Entities\ChartOfAccount::where('bank_id', $bank->id)->where('status', 1)->first();
                        if ($coa) {
                            $balance = \Modules\Account\Entities\Transaction::where('chart_of_account_id', $coa->id)->where('voucher_date',$date)->groupBy('chart_of_account_id')->sum('debit');
                        } else {
                            $balance = 0;
                        }
                    ?>
                    <div class="col-md-4 business-analytics">
                        <div class="bg-white text-center py-3 text-primary bold">
                            <h3 class="business-analytics__subtitle"><?php echo e($bank->bank_name); ?></h3>
                            <h3 class="business-analytics__title" id=""><?php echo e($balance); ?> ৳</h3>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>

    
    <div class="d-flex flex-column-fluid">
        <div class="container-fluid">
            <h2 class="text-left mt-12 display-4 text-primary"><strong>Mobile Banks</strong></h2>
            <div class="row order-stats">
                <?php
                    $mobile_banks = \Modules\MobileBank\Entities\MobileBank::where('status',1)->where('employee_id', \Illuminate\Support\Facades\Auth::user()->id)->get();
                ?>
                <?php $__currentLoopData = $mobile_banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mobile_bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $coa_id = \Modules\Account\Entities\ChartOfAccount::where('mobile_bank_id', $mobile_bank->id)->select('id')->first();
                        if ($coa_id) {
                            $balance = \Modules\Account\Entities\Transaction::where('chart_of_account_id', $coa_id->id)->where('voucher_date',$date)->groupBy('chart_of_account_id')->sum('debit');
                        } else {
                            $balance = 0;
                        }
                    ?>
                    <div class="col-md-4 business-analytics">
                        <div class="text-primary">
                            <h3 class="business-analytics__subtitle"><?php echo e($mobile_bank->bank_name); ?></h3>
                            <h3 class="business-analytics__title" id=""><?php echo e($balance); ?> ৳</h3>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
<?php endif; ?>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script src="plugins/custom/datatables/datatables.bundle.js" type="text/javascript"></script>
    <script src="js/moment.js"></script>
    <script src="js/knockout-3.4.2.js"></script>
    <script src="js/daterangepicker.min.js"></script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iconshoppercom/iconshopper/Modules/Report/Resources/views/today-pos-amount.blade.php ENDPATH**/ ?>