

<?php $__env->startSection('title', $page_title); ?>

<?php $__env->startPush('styles'); ?>
    <link href="plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css"/>
    <link href="css/daterangepicker.min.css" rel="stylesheet" type="text/css"/>
    <style>
        .table thead,
        .table th,
        .table td {
            text-align: center;
            font-family: 'Font Awesome 5 Free';
        }

        table.table-bordered.dataTable th,
        table.table-bordered.dataTable td {
            font-family: 'Font Awesome 5 Free' !important;
            font-size: 16px !important;
        }

        #dataTable tbody td {
            /*border: 1px solid #dddddd; !* Add a 1px solid border with a light gray color *!*/
            padding: 8px;
            text-align: center;
            /* Adjust text alignment as needed */
        }

        .table-striped > tbody > tr:nth-child(odd) > td {
            background-color: rgba(248, 234, 234, 0.93);
        }

        .test-width {
            display: grid;
            grid-template-columns: repeat(1, minmax(0, 1fr));
            gap: 5px;
        }

        .tag-width {
            display: grid;
            grid-template-columns: repeat(4, minmax(0, 1fr));
            gap: 5px;
        }

        .img-size {
            /* 	padding: 0;
             margin: 0; */
            height: 450px;
            width: 700px;
            background-size: cover;
            overflow: hidden;
        }

        .modal-content {
            width: 700px;
            border: none;
        }

        .modal-body {
            padding: 0;
        }

        .carousel-control-prev-icon {
            background-image: url("data:image/svg+xml;charset=utf8,%3Csvg xmlns='http://www.w3.org/2000/svg' fill='%23009be1' viewBox='0 0 8 8'%3E%3Cpath d='M5.25 0l-4 4 4 4 1.5-1.5-2.5-2.5 2.5-2.5-1.5-1.5z'/%3E%3C/svg%3E");
            width: 30px;
            height: 48px;
        }

        .carousel-control-next-icon {
            background-image: url("data:image/svg+xml;charset=utf8,%3Csvg xmlns='http://www.w3.org/2000/svg' fill='%23009be1' viewBox='0 0 8 8'%3E%3Cpath d='M2.75 0l-1.5 1.5 2.5 2.5-2.5 2.5 1.5 1.5 4-4-4-4z'/%3E%3C/svg%3E");
            width: 30px;
            height: 48px;
        }

        /* Order Stats */
        .order-stats {
            font-family: 'Font Awesome 5 Free';
            background-color: #dfdfe6;
            border-radius: 10px;
            padding: 10px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            transition: all 0.3s ease;
        }

        .order-stats2 {
            max-width: 23%;
            background-color: #efedeb;
            border-radius: 10px;
            padding: 5px;
            margin-bottom: 15px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            transition: all 0.3s ease;
        }

        .order-stats__content {
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .order-stats__title {
            /*color: #0661cb;*/
            font-size: 20px;
            font-weight: 700;
        }

        .order-stats__subtitle {
            font-weight: 600;
            font-size: 15px;
            color: #334257;
            margin-bottom: 0;
        }
        .disabled-link {
            pointer-events: none;
            cursor: not-allowed;
            color: black;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="d-flex flex-column-fluid zoom-container">
        <div class="container-fluid">
            <!--begin::Notice-->

            <!--end::Notice-->
            <!--begin::Card-->
            <div class="card card-custom">
                <?php echo $__env->make('sale::ecommerce_order.include.dash-header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <div class="card-header flex-wrap py-5">
                    <?php echo $__env->make('sale::ecommerce_order.include.tab-action', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>


                <div class="card-body">
                    <!--begin: Datatable-->
                    <div id="kt_datatable_wrapper" class="dataTables_wrapper dt-bootstrap4 no-footer">
                        <div class="row">
                            <div class="col-sm-12">
                                <table id="dataTable" class="table table-bordered table-hover">
                                    <thead class="bg-primary">
                                    <tr>
                                        <th width="1%">Invoice No.</th>
                                        <th width="12%">Products</th>
                                        <th width="1%">Status</th>
                                    </tr>
                                    </thead>
                                    <tbody></tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <!--end: Datatable-->
                </div>
            </div>
            <!--end::Card-->
        </div>
    </div>

    <?php echo $__env->make('sale::ecommerce_order.modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('sale::ecommerce_order.courierModal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('sale::ecommerce_order.note', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <section style="opacity: 0;">

    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="plugins/custom/datatables/datatables.bundle.js" type="text/javascript"></script>
    <script src="js/moment.js"></script>
    <script src="js/knockout-3.4.2.js"></script>
    <script src="js/daterangepicker.min.js"></script>
    <script>
        $('.daterangepicker-filed').daterangepicker({
            callback: function (startDate, endDate, period) {
                var start_date = startDate.format('YYYY-MM-DD');
                var end_date = endDate.format('YYYY-MM-DD');
                var title = start_date + ' To ' + end_date;
                $(this).val(title);
                $('input[name="start_date"]').val(start_date);
                $('input[name="end_date"]').val(end_date);
            }
        });

        var table;
        $(document).ready(function () {
            $('.data-btn').removeClass('active');
            loadData("<?php echo e(date('2000-01-01')); ?>", "<?php echo e(date('Y-m-d')); ?>");
            table = $('#dataTable').DataTable({
                "processing": true, //Feature control the processing indicator
                "serverSide": true, //Feature control DataTable server side processing mode
                "order": [], //Initial no order
                'ordering': false,
                "responsive": false, //Make table responsive in mobile device
                "bInfo": true, //TO show the total number of data
                "bFilter": false, //For datatable default search box show/hide
                "lengthMenu": [
                    [5, 10, 15, 25, 50, 100, 1000, 10000, -1],
                    [5, 10, 15, 25, 50, 100, 1000, 10000, "All"]
                ],
                "pageLength": 25, //number of data show per page
                "language": {
                    processing: `<i class="fas fa-spinner fa-spin fa-3x fa-fw text-primary"></i> `,
                    emptyTable: '<strong class="text-danger">No Data Found</strong>',
                    infoEmpty: '',
                    zeroRecords: '<strong class="text-danger">No Data Found</strong>'
                },
                "ajax": {
                    "url": "<?php echo e(route('ecommerce_sale.datatable.data')); ?>",
                    "type": "POST",
                    "data": function (data) {
                        // data.phone = $("#form-filter #phone").val();
                        // data.invoice_no = $("#form-filter #invoice_no").val();
                        // data.customer_id = $("#form-filter #customer_id").val();
                        data.search_field = $("#form-filter #search_field").val();
                        data.warehouse_id = $("#form-filter #warehouse_id").val();
                        data.start_date = $("#form-filter #start_date").val();
                        data.end_date = $("#form-filter #end_date").val();
                        data.order_source_id = 1;
                        data.delivery_status = $("#form-filter #delivery_status").val();

                        data.delivery_status_tab = $("#form-filter #delivery_status_tab").val();


                        data.no_of_print = $("#form-filter #print_status").val();
                        data.payment_status = $("#form-filter #payment_status").val();
                        data.courier_status = $("#form-filter #courier_status").val();
                        data.created_by = $("#form-filter #created_by").val();
                        data._token = _token;
                    }
                },
                "columnDefs": [{
                    "targets": [1, 2],
                    "orderable": false,
                    "className": "text-center"
                },],
                "dom": "<'row'<'col-sm-12 col-md-6'l><'col-sm-12 col-md-6' <'float-right'B>>>" +
                    "<'row'<'col-sm-12'tr>>" +
                    "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'<'float-right'p>>>",

                "buttons": [{
                    'extend': 'colvis',
                    'className': 'btn btn-secondary btn-sm text-white',
                    'text': 'Column',
                    'columns': ':gt(0)'
                },
                    {
                        "extend": 'print',
                        'text': 'Print',
                        'className': 'btn btn-secondary btn-sm text-white',
                        "title": "<?php echo e($page_title); ?> List",
                        "orientation": "landscape", //portrait
                        "pageSize": "legal", //A3,A5,A6,legal,letter
                        "exportOptions": {
                            columns: ':visible:not(:eq(3))'

                        },
                        customize: function (win) {
                            $(win.document.body).addClass('bg-white');
                            $(win.document.body).find('table thead').css({
                                'background': '#034d97'
                            });
                            $(win.document.body).find('table tfoot tr').css({
                                'background-color': '#034d97'
                            });
                            $(win.document.body).find('h1').css('text-align', 'center');
                            $(win.document.body).find('h1').css('font-size', '15px');
                            $(win.document.body).find('table').css('font-size', 'inherit');
                        },
                    },
                    {
                        "extend": 'csv',
                        'text': 'CSV',
                        'className': 'btn btn-secondary btn-sm text-white',
                        "title": "<?php echo e($page_title); ?> List",
                        "filename": "<?php echo e(strtolower(str_replace(' ', '-', $page_title))); ?>-list",
                        "exportOptions": {
                            columns: ':visible:not(:eq(3))'
                        }
                    },
                    {
                        "extend": 'excel',
                        'text': 'Excel',
                        'className': 'btn btn-secondary btn-sm text-white',
                        "title": "<?php echo e($page_title); ?> List",
                        "filename": "<?php echo e(strtolower(str_replace(' ', '-', $page_title))); ?>-list",
                        "exportOptions": {
                            columns: ':visible:not(eq(3))'
                        }
                    },
                    {
                        "extend": 'pdf',
                        'text': 'PDF',
                        'className': 'btn btn-secondary btn-sm text-white',
                        "title": "<?php echo e($page_title); ?> List",
                        "filename": "<?php echo e(strtolower(str_replace(' ', '-', $page_title))); ?>-list",
                        "orientation": "landscape", //portrait
                        "pageSize": "legal", //A3,A5,A6,legal,letter
                        "exportOptions": {
                            columns: ':visible:not(:eq(3))'
                        },
                        customize: function (doc) {
                            doc.defaultStyle.fontSize = 16; //<-- set fontsize to 16 instead of 10
                            doc.styles.tableHeader.fontSize = 16;
                            doc.pageMargins = [5, 5, 5, 5];
                        }
                    },
                ],
            });

            $('.data-btn').on('click', function () {
                $('.data-btn').removeClass('active');
                $(this).addClass('active');
                var start_date = $(this).data('start_date');
                var end_date = $(this).data('end_date');
                $("#form-filter #start_date").val(start_date);
                $("#form-filter #end_date").val(end_date);
                loadData(start_date, end_date);
                table.ajax.reload();
            });

            $('#btn-filter').click(function () {
                var start_date = $("#form-filter #start_date").val();
                var end_date = $("#form-filter #end_date").val();
                if (!start_date || !end_date) {
                    loadData("<?php echo e(date('Y-m-d')); ?>", "<?php echo e(date('Y-m-d')); ?>");
                } else {
                    loadData(start_date, end_date);
                }
                reset_tab();
                table.ajax.reload();
            });

            $('#btn-reset').click(function () {
                $('#form-filter')[0].reset();
                $('#form-filter .selectpicker').selectpicker('refresh');
                $('.data-btn').removeClass('active');
                loadData("<?php echo e(date('2000-01-01')); ?>", "<?php echo e(date('Y-m-d')); ?>");
                $("#form-filter #start_date").val('');
                $("#form-filter #end_date").val('');
                reset_tab();
                table.ajax.reload();
            });

            $(document).on('click', '.delete_data', function () {
                let id = $(this).data('id');
                let name = $(this).data('name');
                let row = table.row($(this).parent('tr'));
                let url = "<?php echo e(route('sale.delete')); ?>";
                delete_data(id, url, table, row, name);
            });

            //Show Status Change Modal
            $(document).on('click', '.change_status', function () {
                $('#approve_status_form #status_id').val($(this).data('id'));
                $('#approve_status_form #delivery_status').val($(this).data('delivery_status'));
                // $('#approve_status_form #note').val($(this).data('note'));
                // $('#approve_status_form #phone').val($(this).data('phone'));
                // $('#approve_status_form #email').val($(this).data('email'));
                $('#approve_status_form #status.selectpicker').selectpicker('refresh');
                $('#approve_status_modal').modal({
                    keyboard: false,
                    backdrop: 'static',
                });
                $('#approve_status_modal .modal-title').html('<span><?php echo e(__('Change Status')); ?></span>');
                $('#approve_status_modal #status-btn').text('<?php echo e(__('Change Status')); ?>');

            });

            $(document).on('click', '#status-button', function () {
                var status_id = $('#approve_status_form #status_id').val();
                var delivery_status = $('#approve_status_form #delivery_status').val();
                var note = $('#approve_status_form #note').val();

                if (delivery_status != '') {
                    $.ajax({
                        url: "<?php echo e(route('ecommerceOrder.change.status')); ?>",
                        type: "POST",
                        data: {
                            status_id: status_id,
                            delivery_status: delivery_status,
                            note: note,
                            _token: _token
                        },
                        dataType: "JSON",
                        beforeSend: function () {
                            $('#status-button').prop('disabled', true).addClass('spinner spinner-white spinner-right');
                        },
                        complete: function () {
                            $('#status-button').prop('disabled', false).removeClass('spinner spinner-white spinner-right');
                        },
                        success: function (data) {
                            notification(data.status, data.message);
                            if (data.status == 'success') {
                                $('#approve_status_modal').modal('hide');
                                table.ajax.reload(null, false);
                            }
                        },
                        error: function (xhr, ajaxOption, thrownError) {
                            console.log(thrownError + '\r\n' + xhr.statusText + '\r\n' + xhr
                                .responseText);
                        }
                    });
                } else {
                    notification('error', 'Please Select Status');
                }
            });


            //Show Status Courier Modal
            $(document).on('click', '.courier_status', function () {
                $('#courier_status_form #status_id').val($(this).data('id'));
                $('#courier_status_form #courier_status').val($(this).data('courier_status'));
                $('#courier_status_form #courier_status.selectpicker').selectpicker('refresh');
                $('#courier_status_modal').modal({
                    keyboard: false,
                    backdrop: 'static',
                });
                $('#courier_status_modal .modal-title').html('<span><?php echo e(__('Change Status')); ?></span>');
                $('#courier_status_modal #status-btn').text('<?php echo e(__('Change Status')); ?>');

            });

            $(document).on('click', '#status-btn', function () {
                var status_id = $('#courier_status_form #status_id').val();
                var courier_status = $('#courier_status_form #courier_status').val();
                $.ajax({
                    url: "<?php echo e(route('ecommerceOrder.change.courier.status')); ?>",
                    type: "POST",
                    data: {
                        status_id: status_id,
                        courier_status: courier_status,
                        _token: _token
                    },
                    dataType: "JSON",
                    beforeSend: function () {
                        $('#status-btn').prop('disabled', true).addClass('spinner spinner-white spinner-right');
                    },
                    complete: function () {
                        $('#status-btn').prop('disabled', false).removeClass('spinner spinner-white spinner-right');
                    },
                    success: function (data) {
                        notification(data.status, data.message);
                        if (data.status == 'success') {
                            $('#courier_status_modal').modal('hide');
                            table.ajax.reload(null, false);
                        }
                    },
                    error: function (xhr, ajaxOption, thrownError) {
                        console.log(thrownError + '\r\n' + xhr.statusText + '\r\n' + xhr
                            .responseText);
                    }
                });
            });

            //steadfast  Courier
            $(document).on('click', '.parcel_steadfast', function () {
                let id = $(this).data('id');
                let name = $(this).data('name');
                let status = $(this).data('status');
                let row = table.row($(this).parent('tr'));
                let url = "<?php echo e(route('parcel.steadfast.order')); ?>";
                change_status(id, url, table, row, name, status);
            });

            //Order Note Modal
            $(document).on('click', '.view_data', function () {
                let id = $(this).data('id');
                if (id) {
                    $.ajax({
                        url: "<?php echo e(route('ecommerceOrder.note.view')); ?>",
                        type: "POST",
                        data: {
                            id: id,
                            _token: _token
                        },
                        success: function (data) {
                            $('#view_modal #view-data').html('');
                            $('#view_modal #view-data').html(data);
                            $('#view_modal').modal({
                                keyboard: false,
                                backdrop: 'static',
                            });
                        },
                        error: function (xhr, ajaxOption, thrownError) {
                            console.log(thrownError + '\r\n' + xhr.statusText + '\r\n' + xhr
                                .responseText);
                        }
                    });
                }
            });
        });

        function onLoadPrint(button) {
            showLoader(button);
            var href = $(button).data('href');
            var id = $(button).data('id');

            var iframe = $("<iframe class='print_page'>").hide().attr("src", href).appendTo("section").show();

            $.ajax({
                url: "<?php echo e(route('update-print-status')); ?>",
                type: "POST",
                data: {
                    id: id,
                    _token: _token
                },
                dataType: "JSON",
                success: function (data) {
                    notification(data.status, data.message);
                    if (data.status == 'success') {
                        table.ajax.reload(null, false);
                    }
                },
                error: function (xhr, ajaxOption, thrownError) {
                    console.log(thrownError + '\r\n' + xhr.statusText + '\r\n' + xhr.responseText);
                }
            });

            // setTimeout(function() {
            //     $(".print_page").append(iframe);
            //
            //     // Show the iframe immediately after appending
            //     iframe.show();
            // }, 1000);

            iframe.on('load', function () {
                hideLoader(button);
            });
            // iframe.display('none');

            iframe.on('error', function () {
                notification('Error loading content');
                hideLoader(button);
            });
        }

        function showLoader(button) {
            $(button).addClass('spinner spinner-white spinner-right');
        }

        function hideLoader(button) {
            $(button).removeClass('spinner spinner-white spinner-right');
        }

        function loadData(start_date, end_date) {
            $.get("<?php echo e(url('ecom-dashboard')); ?>/" + start_date + '/' + end_date, {order_source: 1}, function (data) {
                $('#total_order').text(data.total_order);
                $('#total_sale').text((data.total_sale) + ' ৳');
                $('#total_income').text((data.total_income) + ' ৳');
                $('#total_due').text((data.total_due) + ' ৳');
                $('#new_order').text((data.new_order));
                $('#new_order_value').text((data.new_order_value) + ' ৳');
                $('#tab_new_order').text((data.new_order));


                $('#pending_order').text((data.pending_order));
                $('#pending_order_value').text((data.pending_order_value) + ' ৳');
                $('#tab_pending').text((data.pending_order));


                $('#pending_payment').text((data.pending_payment));
                $('#pending_payment_value').text((data.pending_payment_value) + ' ৳');
                $('#tab_pending_payment').text((data.pending_payment));


                $('#confirm_order').text((data.confirm_order));
                $('#confirm_order_value').text((data.confirm_order_value) + ' ৳');
                $('#tab_confirm').text((data.confirm_order));


                $('#hold_order').text(data.hold_order);
                $('#hold_order_value').text((data.hold_order_value) + ' ৳');
                $('#tab_hold').text((data.hold_order));


                $('#processing_order').text(data.processing_order);
                $('#processing_order_value').text((data.processing_order_value) + ' ৳');
                $('#tab_processing').text((data.processing_order));


                $('#send_to_courier').text(data.send_to_courier);
                $('#send_to_courier_value').text((data.send_to_courier_value) + ' ৳');
                $('#tab_send_to_courier').text((data.send_to_courier));


                $('#assign_to_rider').text(data.assign_to_rider);
                $('#assign_to_rider_value').text((data.assign_to_rider_value) + ' ৳');
                $('#tab_courier_processing').text((data.assign_to_rider));

                $('#delivered_order').text(data.delivered_order);
                $('#delivered_order_value').text((data.delivered_order_value) + ' ৳');
                $('#tab_deliverd').text((data.delivered_order));


                $('#returned_order').text(data.returned_order);
                $('#returned_order_value').text((data.returned_order_value) + ' ৳');
                $('#tab_full_returned').text((data.returned_order));
                $('#tab_partial_returned').text((data.partial_returned_order));


                $('#exchange_order').text(data.exchange_order);
                $('#exchange_order_value').text((data.exchange_order_value) + ' ৳');
                $('#tab_exchange').text((data.exchange_order));


                $('#cancel_order').text(data.cancel_order);
                $('#cancel_order_value').text((data.cancel_order_value) + ' ৳');
                $('#tab_cancel').text((data.cancel_order));


                $('#no_of_print').text(data.no_of_print);
                $('#courier_due_amount').text((data.courier_due_amount) + ' ৳');
            });
        }

        $(document).ready(function () {
            $(document).on('click', '.show-image', function () {
                let id = $(this).data('id');
                let imagePath = $(this).data('image_path');
                if (id) {
                    $.ajax({
                        url: "<?php echo e(route('ecommerceOrder.image.show')); ?>",
                        type: "get",
                        async: false,
                        data: {
                            id: id
                        },
                        dataType: "JSON",
                        success: function (data) {
                            if (data !== null) {
                                let html = '';
                                $('#imageList').empty();

                                $.each(data.image, function (key, filename) {
                                    let new_list = imagePath + '/' + filename;
                                    html += '<div class="carousel-item ' + (key === 0 ?
                                            'active' : '') +
                                        '"><img class="img-size" src="' + new_list +
                                        '" alt="' + filename + '" /></div>';
                                });
                                $('#imageList').append(html);
                            }
                        },
                        error: function (xhr, ajaxOption, thrownError) {
                            console.log(thrownError + '\r\n' + xhr.statusText + '\r\n' + xhr
                                .responseText);
                        }
                    });
                }
            });
        });


        var inputTimeout;
        $(document).on('input', '#search_field', function () {
            reset_tab();
            clearTimeout(inputTimeout);
            inputTimeout = setTimeout(function () {

                table.ajax.reload();

            }, 1000);
        });

        function reset_tab(){
            $('.nav-link').removeClass('active');
            $("#delivery_status_tab").val('');

        }


    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iconshoppercom/iconshopper/Modules/Sale/Resources/views/ecommerce-pos/fb_index.blade.php ENDPATH**/ ?>