
<?php $__env->startSection('title',' POS Report - Dashboard'); ?>
<?php $__env->startPush('styles'); ?>
    <link href="plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css"/>
    <link href="css/daterangepicker.min.css" rel="stylesheet" type="text/css"/>
    <style>
        .today-btn {
            border-radius: 5px 0 0 5px !important;
        }

        .week-btn, .month-btn {
            border-radius: 0 !important;
        }

        .year-btn {
            border-radius: 0 5px 5px 0 !important;
        }

        .icon {
            width: 40px;
            height: 40px;
        }

        .business-analytics {
            max-width: 24%;
            background-color: #fff;
            margin-bottom: 20px;
            border-radius: 10px;
            padding: 40px 30px 20px;
            position: relative;
            border: 1px solid rgba(180, 208, 224, 0.5);
            box-shadow: 0px 5px 10px rgba(0, 0, 0, 0.05);
            height: 100%;
            transition: all 0.3s ease;
        }

        .business-analytics__subtitle {
            font-size: 17px;
            margin-bottom: 10px;
            font-weight: 600;
        }

        .business-analytics__title {
            font-weight: 500;
            font-size: 24px;
        }

        /* Order Stats */
        .order-stats {
            font-family: 'Font Awesome 5 Free';
            background-color: #dfdfe6;
            border-radius: 10px;
            padding: 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            transition: all 0.3s ease;
        }

        .order-stats2 {
            max-width: 23%;
            background-color: #efedeb;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 15px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            transition: all 0.3s ease;
        }

        .order-stats__content {
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .order-stats__title {
            /*color: #0661cb;*/
            font-size: 18px;
            font-weight: 700;
        }

        .order-stats__subtitle {
            font-weight: 600;
            font-size: 15px;
            color: #334257;
            margin-bottom: 0;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <div class="d-flex flex-column-fluid">
        <div class="container-fluid">
            <div class="mx-auto" style="width: 40%;">
                <form method="POST" id="form-filter">
                    <div class="row">
                        <div class="form-group col-md-6">
                            <label for="name">Choose Your Date</label>
                            <div class="input-group">
                                <input type="text" class="form-control daterangepicker-filed">
                                <input type="hidden" id="start_date" name="start_date">
                                <input type="hidden" id="end_date" name="end_date">
                            </div>
                        </div>
                        <div style="margin-top:28px;">
                            <button id="btn-reset" class="btn btn-danger btn-sm btn-elevate btn-icon float-right" type="button"
                                    data-toggle="tooltip" data-theme="dark" title="Reset"><i class="fas fa-undo-alt"></i></button>

                            <button id="btn-filter" class="btn btn-primary btn-sm btn-elevate btn-icon mr-2 float-right" type="button"
                                    data-toggle="tooltip" data-theme="dark" title="Search"><i class="fas fa-search"></i></button>
                        </div>
                    </div>
                </form>
            </div>
            <div class="row order-stats">
                <div class="col-3 business-analytics">
                    <div class="text-primary">
                        <h3 class="business-analytics__subtitle">Total Order</h3>
                        <h3 class="business-analytics__title" id="total_order"><?php echo e(0); ?></h3>
                    </div>
                </div>
                <div class="col-3 business-analytics">
                    <div class="text-primary">
                        <h3 class="business-analytics__subtitle">Total Sale</h3>
                        <h3 class="business-analytics__title" id="total_sale"><?php echo e(0); ?> ৳</h3>
                    </div>
                </div>
                <div class="col-3 business-analytics">
                    <div class="text-primary">
                        <h3 class="business-analytics__subtitle">Total Collection</h3>
                        <h3 class="business-analytics__title" id="total_income"><?php echo e(0); ?> ৳</h3>
                    </div>
                </div>
                <div class="col-3 business-analytics">
                    <div class="text-primary">
                        <h3 class="business-analytics__subtitle">Total Due</h3>
                        <h3 class="business-analytics__title" id="total_due"><?php echo e(0); ?> ৳</h3>
                    </div>
                </div>
                <div class="col-3 business-analytics">
                    <div class="text-primary">
                        <h3 class="business-analytics__subtitle">Total Expense</h3>
                        <h3 class="business-analytics__title" id="total_expense"><?php echo e(0); ?> ৳</h3>
                    </div>
                </div>
                <div class="col-3 business-analytics">
                    <div class="text-primary">
                        <h3 class="business-analytics__subtitle">Stock Purchase Value</h3>
                        <h3 class="business-analytics__title" id="stock_purchase_value"><?php echo e(0); ?> ৳</h3>
                    </div>
                </div>
                <div class="col-3 business-analytics">
                    <div class="text-primary">
                        <h3 class="business-analytics__subtitle">Stock Sale Value</h3>
                        <h3 class="business-analytics__title" id="stock_sale_value"><?php echo e(0); ?> ৳</h3>
                    </div>
                </div>
                <div class="col-md-3 business-analytics">
                    <div class="text-primary">
                        <h3 class="business-analytics__subtitle">Total Product Stock</h3>
                        <?php
                            if (isset($_GET['showroom_id'])) {
                                $products = \Modules\ShowroomProduct\Entities\ShowroomProduct::where('showroom_id', $_GET['showroom_id'])
                                    ->groupBy('product_code')
                                    ->select('product_code', \Illuminate\Support\Facades\DB::raw('SUM(qty) as total_qty'))->get();
                            } else {
                                $products = \Modules\ShowroomProduct\Entities\ShowroomProduct::where('showroom_id', auth()->user()->showroom_id)
                                    ->groupBy('product_code')
                                    ->select('product_code', \Illuminate\Support\Facades\DB::raw('SUM(qty) as total_qty'))->get();
                            }

                            $totalQty = $products->sum('total_qty');
                        ?>
                        <h3 class="business-analytics__title" id="product"><?php echo e($totalQty); ?></h3>
                    </div>
                </div>
                <?php if(permission('net-profit-access')): ?>
                    <div class="col-3 business-analytics">
                        <div class="text-primary">
                            <h3 class="business-analytics__subtitle">Sale Profit</h3>
                            <h3 class="business-analytics__title" id="sale_profit"><?php echo e(0); ?> ৳</h3>
                        </div>
                    </div>
                <?php endif; ?>
                <?php if(permission('net-profit-access')): ?>
                    <div class="col-3 business-analytics">
                        <div class="text-primary">
                            <h3 class="business-analytics__subtitle">Net Profit</h3>
                            <h3 class="business-analytics__title" id="net_profit"><?php echo e(0); ?> ৳</h3>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
            <div class="row order-stats">
                <div class="col-md-3 order-stats2">
                    <a class="disabled-link" href="#">
                        <div class="order-stats__content">
                            <h6 class="order-stats__subtitle">Exchange</h6>
                        </div>
                        <h6 class="order-stats__subtitle" id="exchange_order">0</h6>
                    </a>
                    <span class="order-stats__title text-info" id="exchange_order_value">0 ৳</span>
                </div>
            </div>

            
            <div class="d-flex flex-column-fluid">
                <div class="container-fluid">
                    <h2 class="text-left mt-12 display-4 text-primary"><strong>Top Data</strong></h2>
                    <div class="row order-stats">
                        <div class="col-md-6 business-analytics">
                            <div class="text-primary">
                                <h3 class="business-analytics__subtitle">Top Customers</h3>
                                <table class="table table-bordered">
                                    <thead class="bg-primary">
                                    <tr>
                                        <th></th>
                                        <th>Name</th>
                                        <th>Total Value</th>
                                    </tr>
                                    </thead>
                                    <tbody id="top_customer_list"></tbody>
                                </table>
                            </div>
                        </div>

                        <div class="col-md-6 business-analytics">
                            <div class="text-primary">
                                <h3 class="business-analytics__subtitle">Top Salesmen</h3>
                                <table class="table table-bordered">
                                    <thead class="bg-primary">
                                    <tr>
                                        <th></th>
                                        <th>Name</th>
                                        <th>Total Value</th>
                                    </tr>
                                    </thead>
                                    <tbody id="top_user_list"></tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script src="plugins/custom/datatables/datatables.bundle.js" type="text/javascript"></script>
    <script src="js/moment.js"></script>
    <script src="js/knockout-3.4.2.js"></script>
    <script src="js/daterangepicker.min.js"></script>
    <script>
        $('.daterangepicker-filed').daterangepicker({
            callback: function (startDate, endDate) {
                var start_date = startDate.format('YYYY-MM-DD');
                var end_date = endDate.format('YYYY-MM-DD');
                var title = start_date + ' To ' + end_date;
                $(this).val(title);
                $('input[name="start_date"]').val(start_date);
                $('input[name="end_date"]').val(end_date);
            }
        });
        $(document).ready(function () {
            loadData("<?php echo e(date('Y-m-d')); ?>", "<?php echo e(date('Y-m-d')); ?>");

            $('.data-btn').on('click', function () {
                $('.data-btn').removeClass('active');
                $(this).addClass('active');
                var start_date = $(this).data('start_date');
                var end_date = $(this).data('end_date');
                loadData(start_date, end_date);
            });

            function loadData(start_date, end_date) {
                load_filter_showroom(start_date, end_date);
            }

            $('#btn-filter').click(function () {
                var start_date = $('input[name="start_date"]').val();
                var end_date = $('input[name="end_date"]').val();
                loadData(start_date, end_date);
            });

            $('#btn-reset').click(function () {
                $('#form-filter')[0].reset();
                $('#form-filter #start_date').val("");
                $('#form-filter #end_date').val("");
                loadData("<?php echo e(date('Y-m-d')); ?>", "<?php echo e(date('Y-m-d')); ?>");
                $('.data-btn').removeClass('active');
                $('.today-btn').addClass('active');
            });
        });

        function load_filter_showroom(start_date, end_date) {
            var showroomId = new URLSearchParams(window.location.search).get('showroom_id');
            // console.log(showroomId);

            $.get("<?php echo e(url('pos-dashboard')); ?>/" + start_date + '/' + end_date, {showroom_id: showroomId}, function (data) {
                $('#total_order').text(data.total_order);
                $('#total_sale').text((data.total_sale) + ' ৳');
                $('#total_income').text((data.total_income) + ' ৳');
                $('#total_due').text((data.total_due) + ' ৳');
                $('#total_expense').text((data.total_expense) + ' ৳');
                $('#stock_purchase_value').text((data.stock_purchase_value) + ' ৳');
                $('#stock_sale_value').text((data.stock_sale_value) + ' ৳');
                $('#sale_profit').text((data.sale_profit) + ' ৳');
                $('#net_profit').text((data.net_profit) + ' ৳');
                $('#exchange_order').text(data.exchange_order);
                $('#exchange_order_value').text(data.exchange_order_value + ' ৳');

                let topCustomerHtml = '';
                let topUserHtml = '';

                data.top_customer.forEach(function (top_customer, index) {
                    topCustomerHtml += '<tr>';
                    topCustomerHtml += '<td>' + (index + 1) + '</td>';
                    topCustomerHtml += '<td>' + top_customer.name + ' (' + (top_customer.phone ?? top_customer.mobile) + ')</td>';
                    topCustomerHtml += '<td>' + top_customer.total_value + ' ৳ (' + top_customer.total_order + ')</td>';
                    topCustomerHtml += '</tr>';
                });
                data.top_user.forEach(function (top_user, index) {
                    topUserHtml += '<tr>';
                    topUserHtml += '<td>' + (index + 1) + '</td>';
                    topUserHtml += '<td>' + top_user.name + ' (' + top_user.phone + ')</td>';
                    topUserHtml += '<td>' + top_user.total_value + ' ৳ (' + top_user.total_order + ')</td>';
                    topUserHtml += '</tr>';
                });

                $('#top_user_list').html(topUserHtml);
                $('#top_customer_list').html(topCustomerHtml);
            });
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iconshoppercom/iconshopper/resources/views/pos-report.blade.php ENDPATH**/ ?>