

<?php $__env->startSection('title', $page_title); ?>

<?php $__env->startSection('content'); ?>
    <div class="d-flex flex-column-fluid">
        <div class="container-fluid">
            <!--begin::Notice-->
            <div class="card card-custom gutter-b">
                <div class="card-header flex-wrap py-5">
                    <div class="card-title">
                        <h3 class="card-label"><i class="<?php echo e($page_icon); ?> text-primary"></i> <?php echo e($sub_title); ?></h3>
                    </div>
                    <div class="card-toolbar">
                        <!--begin::Button-->
                        <a href="<?php echo e(route('carton')); ?>" class="btn btn-warning btn-sm font-weight-bolder">
                            <i class="fas fa-arrow-left"></i> Back</a>
                        <!--end::Button-->
                    </div>
                </div>
            </div>
            <!--end::Notice-->
            <!--begin::Card-->
            <div class="card card-custom" style="padding-bottom: 100px !important;">
                <div class="card-body">
                    <form id="store_or_update_form" method="post" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="form-group col-md-4">
                                        <label for="boxed_date">Date</label>
                                        <input type="date" class="form-control" name="boxed_date" id="boxed_date"
                                               placeholder="" value="<?php echo e(date('Y-m-d')); ?>">
                                    </div>
                                    <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.form.textbox','data' => ['labelName' => 'Carton Name','name' => 'name','required' => 'required','col' => 'col-md-4','placeholder' => 'Enter Carton Name']]); ?>
<?php $component->withName('form.textbox'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes(['labelName' => 'Carton Name','name' => 'name','required' => 'required','col' => 'col-md-4','placeholder' => 'Enter Carton Name']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>

                                    <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.form.textbox','data' => ['labelName' => 'Quantity','name' => 'qty','required' => 'required','col' => 'col-md-4','placeholder' => 'Enter Quantity','onkeyup' => 'calculateRatio()']]); ?>
<?php $component->withName('form.textbox'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes(['labelName' => 'Quantity','name' => 'qty','required' => 'required','col' => 'col-md-4','placeholder' => 'Enter Quantity','onkeyup' => 'calculateRatio()']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>

                                    <div class="col-md-4 form-group sku required">
                                        <label for="sku">SKU</label>
                                        <div class="input-group" id="sku_section">
                                            <input type="text" class="form-control" name="sku" id="sku">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text bg-primary" id="generate-sku"
                                                      data-toggle="tooltip" data-theme="dark" title="Generate SKU"
                                                      style="border-top-right-radius: 0.42rem;border-bottom-right-radius: 0.42rem;border:0;cursor: pointer;">
                                                    <i class="fas fa-retweet text-white"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4 form-group code required">
                                        <label for="code">Barcode</label>
                                        <div class="input-group" id="code_section">
                                            <input type="text" class="form-control" name="barcode" id="barcode">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text bg-primary" id="generate-code"
                                                      data-toggle="tooltip" data-theme="dark" title="Generate Code"
                                                      style="border-top-right-radius: 0.42rem;border-bottom-right-radius: 0.42rem;border:0;cursor: pointer;">
                                                    <i class="fas fa-retweet text-white"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>

                                    <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.form.selectbox','data' => ['labelName' => 'Barcode Symbol','name' => 'barcode_symbology','col' => 'col-md-4','class' => 'selectpicker']]); ?>
<?php $component->withName('form.selectbox'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes(['labelName' => 'Barcode Symbol','name' => 'barcode_symbology','col' => 'col-md-4','class' => 'selectpicker']); ?>
                                        <?php $__currentLoopData = BARCODE_SYMBOL; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($key); ?>" <?php echo e($key == 1 ? 'selected' : ''); ?>>
                                                <?php echo e($value); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>

                                    <div class="form-group col-md-4 required">
                                        <label for="unit_id">Unit</label>
                                        <select name="unit_id" id="unit_id" onchange="populate_unit(this.value,1)"
                                                class="form-control selectpicker" data-live-search="true"
                                                data-live-search-placeholder="Search">
                                            <option value="">Select Please</option>
                                            <?php if(!$units->isEmpty()): ?>
                                                <?php $__currentLoopData = $units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if($unit->base_unit == null): ?>
                                                        <option value="<?php echo e($unit->id); ?>">
                                                            <?php echo e($unit->unit_name . ' (' . $unit->unit_code . ')'); ?></option>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                        </select>
                                    </div>

                                    <div class="col-md-4 form-group">
                                        <label for="tax_id">Tax</label>
                                        <select name="tax_id" id="tax_id" required="required"
                                                class="form-control selectpicker">
                                            <option value="0" selected>No Tax</option>
                                            <?php if(!$taxes->isEmpty()): ?>
                                                <?php $__currentLoopData = $taxes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($tax->id); ?>"
                                                        <?php echo e(isset($product) ? ($product->tax_id == $tax->id ? 'selected' : '') : ''); ?>>
                                                        <?php echo e($tax->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                        </select>
                                    </div>

                                    <div class="col-md-4 form-group">
                                        <label for="type"><?php echo e('Store'); ?></label>
                                        <select name="type" id="type" class="form-control"
                                                onchange="selectedStore();">
                                            <option value="1">Warehouse</option>
                                            <option value="2">Showroom</option>
                                        </select>
                                    </div>
                                    <div class="col-md-4 form-group" id="showStore">

                                    </div>
                                    <div class="col-md-8 form-group">

                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="sku_name">Select Product Code</label>
                                        <div class="input-group mb-3">
                                            <div class="input-group-prepend">
                                            <span class="input-group-text" id="basic-addon1"><i
                                                    class="fas fa-barcode"></i></span>
                                            </div>
                                            <input type="text" class="form-control" name="product_code_name"
                                                   id="product_code_name" placeholder="Scan/Search by product code">
                                        </div>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="product_sku">Select Product SKU</label>
                                        <div class="input-group mb-3">
                                            <div class="input-group-prepend">
                                            <span class="input-group-text" id="basic-addon1"><i
                                                    class="fas fa-barcode"></i></span>
                                            </div>
                                            <input type="text" class="form-control" name="product_sku"
                                                   id="product_sku" placeholder="Scan/Search by product Sku">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-12 mt-5">
                                <label for="description">Description</label>
                                <textarea class="form-control" name="description" id="description"></textarea>
                            </div>

                            <div class="col-md-12 pt-5" id="material-section">
                                <div class="row"
                                     style="position: relative;border: 1px solid #E4E6EF;padding: 10px 0 0 0; margin: 0;border-radius:5px;">
                                    <div
                                        style="width: 100px;background: #fa8c15;text-align: center;margin: 0 auto;color: white;padding: 5px 0;
                                    position: absolute;top:-16px;left:10px;">
                                        Products
                                    </div>
                                    <div class="col-md-12 pt-5 material_section">
                                        <div class="row">
                                            <table class="table table-striped table-bordered mx-3 text-center"
                                                   id="product_table">
                                                <thead class="bg-primary">
                                                <tr>
                                                    <th>Name</th>
                                                    <th>Code</th>
                                                    <th>Available Quantity</th>
                                                    <th>Ratio</th>
                                                    <th>Quantity</th>
                                                    <th>Regular Price</th>
                                                    <th>Sale Price</th>
                                                    <th>Whole Sale Price</th>
                                                    <th>Action</th>
                                                </tr>
                                                </thead>
                                                <tbody>

                                                </tbody>
                                                <tfoot>
                                                <tr>
                                                    <td colspan="4">Total(*Quantity)</td>
                                                    <td><span id="total_quantity"></span></td>
                                                    <td><span id="total_regular_price"></span></td>
                                                    <td><span id="total_sale_price"></span></td>
                                                    <td><span id="total_whole_sale_price"></span></td>
                                                    <td></td>
                                                </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group col-md-4 mt-5">
                                <label for="">Regular Price</label>
                                <input type="text" class="form-control" name="regular_price" id="regular_price"
                                       value="">
                            </div>
                            <div class="form-group col-md-4 mt-5">
                                <label for="">Sale Price</label>
                                <input type="text" class="form-control" name="sale_price" id="sale_price"
                                       value="">
                            </div>
                            <div class="form-group col-md-4 mt-5">
                                <label for="">Whole Sale Price</label>
                                <input type="text" class="form-control" name="whole_sale_price" id="whole_sale_price"
                                       value="">
                                <input type="hidden" class="form-control" name="discount" id="discount"
                                       value="">
                                <input type="hidden" class="form-control" name="purchase_price" id="purchase_price"
                                       value="">
                            </div>
                            <div class="form-group col-md-12 pt-5">
                                <button type="button" class="btn btn-primary btn-sm" id="save-btn"
                                        onclick="storeData()">Save
                                </button>
                            </div>

                        </div>
                    </form>
                </div>
            </div>
            <!--end::Card-->
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('js/jquery-ui.js')); ?>"></script>
    <script src="<?php echo e(asset('js/moment.js')); ?>"></script>
    <script src="<?php echo e(asset('js/knockout-3.4.2.js')); ?>"></script>
    <script src="<?php echo e(asset('js/daterangepicker.min.js')); ?>"></script>
    <script>
        $(document).ready(function () {

            var material_count = 1;
            var warehouse_id = '';
            var showroom_id = '';

            selectedStore();

            function add_more_material_field(row) {
                html = ``;
                $('.material_section').append(html);
                $('.selectpicker').selectpicker('refresh');
            }

            /** End :: Add More Material Field **/

            $('#product_code_name').on('input', function () {
                let type = $('#type').val();
                if (type == 1) {
                    warehouse_id = $('#warehouse_id').val();
                    showroom_id = '';
                } else {
                    showroom_id = $('#showroom_id').val();
                    warehouse_id = '';
                }
                var temp_data = $('#product_code_name').val();
            });


            
            
            
            
            

            $('#product_code_name').autocomplete({
                source: function (request, response) {
                    $.ajax({
                        url: "<?php echo e(url('get-showroom-warehouse-products')); ?>",
                        type: 'post',
                        dataType: "json",
                        data: {
                            _token: _token,
                            search: request.term,
                            warehouse_id: warehouse_id,
                            showroom_id: showroom_id
                        },
                        success: function (data) {
                            response(data);
                        }
                    });
                },
                response: function (event, ui) {
                    if (ui.content.length == 1) {
                        let {
                            code,
                            product_id,
                            variant,
                            variant_id,
                            label
                        } = ui.content[0];
                        $(this).autocomplete("close");
                        product_barcode_search(product_id, variant, code, variant_id, label,
                            warehouse_id, showroom_id);
                        notification('success', 'Successfully Added To Cart');
                    }
                },
                select: function (event, ui) {
                    let {
                        code,
                        product_id,
                        variant,
                        variant_id,
                        label
                    } = ui.item;
                    product_barcode_search(product_id, variant, code, variant_id, label,
                        warehouse_id, showroom_id);
                },
            }).data('ui-autocomplete')._renderItem = function (ul, item) {
                return $("<li class='ui-autocomplete-row'></li>")
                    .data("item.autocomplete", item)
                    .append(item.label)
                    .appendTo(ul);
            };

            // }

            function product_barcode_search(product_id, hasVariant, code, variant_id, variation, warehouse_id,
                                            showroom_id) {
                let html = '';
                $.ajax({
                    url: "<?php echo e(route('set.showroom.warehouse.product')); ?>",
                    type: 'POST',
                    data: {
                        code: code,
                        _token: _token,
                        warehouse_id: warehouse_id,
                        showroom_id: showroom_id,
                        product_id: product_id,
                        hasVariant: hasVariant
                    },
                    success: function (data) {
                        console.log(data.productName);
                        if (data.qty > 0) {
                            var flag = 1;
                            $('.product-code').each(function (i) {

                                if ($(this).val() == data.code) {
                                    flag = 0;
                                    notification('error', 'You Have Already Added The product');
                                }
                            });
                            $('#product_code_name').val('');
                            if (flag) {
                                html = ` <tr>
                                            <td>${data.name}</td>
                                            <td>
                                                <input type="text" name="carton[${material_count}][product_code]"
                                                    id="carton_${material_count}_product_code" class="form-control product-code text-center"
                                                    value="${data.code}" readonly>

                                                <input type="hidden" name="carton[${material_count}][product_id]"
                                                    id="carton_${material_count}_product_id" class="form-control"
                                                    value="${data.id}">

                                                <input type="hidden" name="carton[${material_count}][type]"
                                                    id="carton_${material_count}_type" class="form-control" value="${hasVariant}">

                                                <input type="hidden" name="carton[${material_count}][purchase_price]"
                                                    id="carton_${material_count}_purchase_price"
                                                    class="form-control purchase-price" value="${data.purchase_price}" data-key="${material_count}">

                                                <input type="hidden" name="carton[${material_count}][discount]"
                                                    id="carton_${material_count}_discount"
                                                    class="form-control discount" value="${data.discount}" data-key="${material_count}">
                                            </td>
                                            <td>
                                                <input type="text" name="carton[${material_count}][available_qty]"
                                                    id="carton_${material_count}_available_qty"
                                                    class="form-control available_qty text-center" value="${data.qty}" data-key="${material_count}" readonly>
                                            </td>
                                            <td>
                                                <input type="text" name="carton[${material_count}][ratio]"
                                                    id="carton_${material_count}_ratio"
                                                    class="form-control ratio text-center" value="1" data-key="${material_count}" onkeyup="calculateRatio()">
                                            </td>
                                            <td>
                                                <input type="text" name="carton[${material_count}][qty]"
                                                    id="carton_${material_count}_qty"
                                                    class="form-control qty text-center" value="1" data-key="${material_count}" readonly>
                                            </td>
                                            <td>
                                                <input type="text" name="carton[${material_count}][regular_price]"
                                                    id="carton_${material_count}_regular_price"
                                                    class="form-control regular-price text-center" value="${data.regular_price}" data-key="${material_count}" onkeyup="calculateCarton();">
                                            </td>
                                            <td>
                                                <input type="text" name="carton[${material_count}][sale_price]"
                                                    id="carton_${material_count}_sale_price"
                                                    class="form-control sale-price text-center" data-key="${material_count}" value="${data.sale_price}" onkeyup="calculateCarton();">
                                            </td>
                                            <td>
                                                <input type="text" name="carton[${material_count}][whole_sale_price]"
                                                    id="carton_${material_count}_whole_sale_price"
                                                    class="form-control whole-sale-price text-center" data-key="${material_count}" value="${data.whole_sale_price}" onkeyup="calculateCarton();">
                                            </td>
                                            <td><button type="button" class="btn btn-danger delete-row"><i
                                                        class="fas fa-trash"></i></button></td>
                                        </tr>`;
                                $('#product_table tbody').append(html);
                                material_count++;
                                calculateCarton();
                            }
                        } else {
                            $('#product_code_name').val('');
                            notification('error', 'This product is out of stock!');
                        }
                    }
                });
            }

            $('#product_sku').on('input', function () {
                let type = $('#type').val();
                if (type == 1) {
                    warehouse_id = $('#warehouse_id').val();
                    showroom_id = '';
                } else {
                    showroom_id = $('#showroom_id').val();
                    warehouse_id = '';
                }
                var temp_data = $('#product_sku').val();
            });

            $('#product_sku').autocomplete({
                source: function (request, response) {
                    $.ajax({
                        url: "<?php echo e(url('get-showroom-warehouse-sku-search')); ?>",
                        type: 'post',
                        dataType: "json",
                        data: {
                            _token: _token,
                            search: request.term,
                            warehouse_id: warehouse_id,
                            showroom_id: showroom_id

                        },
                        success: function (data) {
                            response(data);
                        }
                    });
                },
                // minLength: 3,
                response: function (event, ui) {
                    if (ui.content.length == 1) {
                        let sku = ui.content[0].sku;
                        let productId = ui.content[0].product_id;
                        let hasVariant = ui.content[0].product_variation_status;
                        let variation = ui.content[0].label;
                        $(this).autocomplete("close");
                        product_sku_search(productId, hasVariant, sku);
                        notification('success', 'Successfully Added To Cart');

                    }
                },
                select: function (event, ui) {
                    let sku = ui.item.sku;
                    let productId = ui.item.product_id;
                    let hasVariant = ui.item.product_variation_status;
                    let variation = ui.item.label;
                    product_sku_search(productId, hasVariant, sku);
                },
            }).data('ui-autocomplete')._renderItem = function (ul, item) {
                return $("<li class='ui-autocomplete-row'></li>")
                    .data("item.autocomplete", item)
                    .append(item.label)
                    .appendTo(ul);
            };

            function product_sku_search(product_id, hasVariant, sku) {
                $.ajax({
                    url: "<?php echo e(route('set.showroom.warehouse.sku')); ?>",
                    type: 'POST',
                    data: {
                        sku: sku,
                        _token: _token,
                        showroom_id: $('#showroom_id option:selected').val(),
                        product_id: product_id,
                        hasVariant: hasVariant
                    },
                    success: function (dataArray) {
                        console.log(dataArray);
                        $.each(dataArray, function (index, data) {
                            if (data.qty > 0) {
                                var flag = 1;
                                $('.product-code').each(function (i) {
                                    if ($(this).val() == data.code) {
                                        rowindex = i;
                                        var qty = parseFloat($(
                                            '#product_table tbody tr:nth-child(' + (
                                                rowindex + 1) + ') .qty').val()) + 1;
                                        $('#product_table tbody tr:nth-child(' + (rowindex + 1) +
                                            ') .qty').val(qty);
                                        checkQuantity(String(qty), true, input = 2);
                                        flag = 0;
                                    }
                                });
                                $('#product_sku').val('');
                                if (flag) {
                                    // temp_unit_name = data.unit_name.split(',');
                                    html = ` <tr>
                                            <td>${data.name}</td>
                                            <td>
                                                <input type="text" name="carton[${material_count}][product_code]"
                                                    id="carton_${material_count}_product_code" class="form-control product-code text-center"
                                                    value="${data.code}" readonly>

                                                <input type="hidden" name="carton[${material_count}][product_id]"
                                                    id="carton_${material_count}_product_id" class="form-control"
                                                    value="${data.id}">

                                                <input type="hidden" name="carton[${material_count}][type]"
                                                    id="carton_${material_count}_type" class="form-control" value="${hasVariant}">

                                                <input type="hidden" name="carton[${material_count}][purchase_price]"
                                                    id="carton_${material_count}_purchase_price"
                                                    class="form-control purchase-price" value="${data.purchase_price}" data-key="${material_count}">

                                                <input type="hidden" name="carton[${material_count}][discount]"
                                                    id="carton_${material_count}_discount"
                                                    class="form-control discount" value="${data.discount}" data-key="${material_count}">
                                            </td>
                                            <td>
                                                <input type="text" name="carton[${material_count}][available_qty]"
                                                    id="carton_${material_count}_available_qty"
                                                    class="form-control available_qty text-center" value="${data.qty}" data-key="${material_count}" readonly>
                                            </td>
                                            <td>
                                                <input type="text" name="carton[${material_count}][ratio]"
                                                    id="carton_${material_count}_ratio"
                                                    class="form-control ratio text-center" value="1" data-key="${material_count}" onkeyup="calculateRatio()">
                                            </td>
                                            <td>
                                                <input type="text" name="carton[${material_count}][qty]"
                                                    id="carton_${material_count}_qty"
                                                    class="form-control qty text-center" value="1" data-key="${material_count}" readonly>
                                            </td>
                                            <td>
                                                <input type="text" name="carton[${material_count}][regular_price]"
                                                    id="carton_${material_count}_regular_price"
                                                    class="form-control regular-price text-center" value="${data.regular_price}" data-key="${material_count}" onkeyup="calculateCarton();">
                                            </td>
                                            <td>
                                                <input type="text" name="carton[${material_count}][sale_price]"
                                                    id="carton_${material_count}_sale_price"
                                                    class="form-control sale-price text-center" data-key="${material_count}" value="${data.sale_price}" onkeyup="calculateCarton();">
                                            </td>
                                            <td>
                                                <input type="text" name="carton[${material_count}][whole_sale_price]"
                                                    id="carton_${material_count}_whole_sale_price"
                                                    class="form-control whole-sale-price text-center" data-key="${material_count}" value="${data.whole_sale_price}" onkeyup="calculateCarton();">
                                            </td>
                                            <td><button type="button" class="btn btn-danger delete-row"><i
                                                        class="fas fa-trash"></i></button></td>
                                        </tr>`;
                                    $('#product_table tbody').append(html);
                                    material_count++;
                                    calculateCarton();
                                }
                            } else {
                                $('#product_sku').val('');
                                notification('error', 'No Stock Available For This Product');
                            }
                        });
                    },
                    error: function (xhr, ajaxOption, thrownError) {
                        console.log(thrownError + '\r\n' + xhr.statusText + '\r\n' + xhr.responseText);
                    }
                });
            }

            //delete row
            $(document).on('click', '.delete-row', function () {
                $(this).closest('tr').remove();
                calculateCarton();
            });

            //Generate Code
            $(document).on('click', '#generate-code', function () {
                $.ajax({
                    url: "<?php echo e(route('carton.generate.code')); ?>",
                    type: "GET",
                    dataType: "JSON",
                    beforeSend: function () {
                        $('#generate-code').addClass('spinner spinner-white spinner-right');
                    },
                    complete: function () {
                        $('#generate-code').removeClass('spinner spinner-white spinner-right');
                    },
                    success: function (data) {
                        data ? $('#store_or_update_form #barcode').val(data) : $(
                            '#store_or_update_form #barcode').val('');
                    },
                    error: function (xhr, ajaxOption, thrownError) {
                        console.log(thrownError + '\r\n' + xhr.statusText + '\r\n' + xhr
                            .responseText);
                    }
                });
            });
            // Generate Sku
            $(document).on('click', '#generate-sku', function () {
                $.ajax({
                    url: "<?php echo e(route('carton.generate.sku')); ?>",
                    type: "GET",
                    dataType: "JSON",
                    beforeSend: function () {
                        $('#generate-sku').addClass('spinner spinner-white spinner-right');
                    },
                    complete: function () {
                        $('#generate-sku').removeClass('spinner spinner-white spinner-right');
                    },
                    success: function (data) {
                        data ? $('#store_or_update_form #sku').val(data) : $(
                            '#store_or_update_form #sku').val('');
                    },
                    error: function (xhr, ajaxOption, thrownError) {
                        console.log(thrownError + '\r\n' + xhr.statusText + '\r\n' + xhr
                            .responseText);
                    }
                });
            });
        });

        function selectedStore() {
            let type = $('#type').val();
            var html = '';
            $('#showStore').html('');
            if (type == 1) {
                html = `<label for="warehouse_id"><?php echo e('Warehouse'); ?></label>
                        <select class="form-control selectpicker" id="warehouse_id" name="warehouse_id" required data-live-search="true">
                            <option value=""><?php echo e('Please Select'); ?></option>
                            <?php $__currentLoopData = $warehouses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($value->id); ?>"><?php echo e($value->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>`;
            } else {
                html = `<label for="showroom_id"><?php echo e('Showroom'); ?></label>
                        <select class="form-control selectpicker" id="showroom_id" name="showroom_id" required data-live-search="true">
                            <option value=""><?php echo e('Please Select'); ?></option>
                            <?php $__currentLoopData = $showrooms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($value->id); ?>"><?php echo e($value->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>`;
            }
            $('#showStore').html(html);
            $('.selectpicker').selectpicker('refresh');
            $('#product_table tbody').empty();
            calculateCarton();
        }

        function calculateCarton() {
            let purchasePrice = 0;
            let regularPrice = 0;
            let salePrice = 0;
            let wholesalePrice = 0;
            let discount = 0;
            let quantity = 0;
            $('.qty').each(function () {
                quantity += Number($(this).val());
            });

            $('.purchase-price').each(function () {
                let thisKey = $(this).attr('data-key');
                let thisQty = Number($(`#carton_${thisKey}_ratio`).val());
                purchasePrice += Number($(this).val()) * thisQty;
            });

            $('.regular-price').each(function () {
                let thisKey = $(this).attr('data-key');
                let thisQty = Number($(`#carton_${thisKey}_ratio`).val());
                regularPrice += Number($(this).val()) * thisQty;
            });

            $('.sale-price').each(function () {
                let thisKey = $(this).attr('data-key');
                let thisQty = Number($(`#carton_${thisKey}_ratio`).val());
                salePrice += Number($(this).val()) * thisQty;
            });

            $('.whole-sale-price').each(function () {
                let thisKey = $(this).attr('data-key');
                let thisQty = Number($(`#carton_${thisKey}_ratio`).val());
                wholesalePrice += Number($(this).val()) * thisQty;
            });

            $('.discount').each(function () {
                let thisKey = $(this).attr('data-key');
                let thisQty = Number($(`#carton_${thisKey}_ratio`).val());
                discount += Number($(this).val()) * thisQty;
            });
            $('#total_regular_price').text('');
            $('#total_quantity').text('');
            $('#total_sale_price').text('');
            $('#total_whole_sale_price').text('');
            $('#total_regular_price').text(regularPrice);
            $('#regular_price').val(regularPrice);
            $('#total_quantity').text(quantity);
            $('#total_sale_price').text(salePrice);
            $('#sale_price').val(salePrice);
            $('#total_whole_sale_price').text(wholesalePrice);
            $('#whole_sale_price').val(wholesalePrice);

            $('#discount').val(discount);
            $('#purchase_price').val(purchasePrice);
        }

        function storeData() {
            let form = document.getElementById('store_or_update_form');
            let formData = new FormData(form);
            let url = "<?php echo e(route('carton.store')); ?>";
            $.ajax({
                url: url,
                type: "POST",
                data: formData,
                dataType: "JSON",
                contentType: false,
                processData: false,
                cache: false,
                beforeSend: function () {
                    $('#save-btn').addClass('spinner spinner-white spinner-right');
                },
                complete: function () {
                    $('#save-btn').removeClass('spinner spinner-white spinner-right');
                },
                success: function (data) {
                    $('#store_or_update_form').find('.is-invalid').removeClass('is-invalid');
                    $('#store_or_update_form').find('.error').remove();
                    if (data.status == false) {
                        $.each(data.errors, function (key, value) {
                            var key = key.split('.').join('_');
                            $('#store_or_update_form input#' + key).addClass('is-invalid');
                            $('#store_or_update_form textarea#' + key).addClass('is-invalid');
                            $('#store_or_update_form select#' + key).parent().addClass('is-invalid');
                            $('#store_or_update_form #' + key).parent().append(
                                '<small class="error text-danger">' + value + '</small>');
                        });
                    } else {
                        notification(data.status, data.message);
                        if (data.status == 'success') {
                            window.location.replace("<?php echo e(route('carton')); ?>");
                        }
                    }
                },
                error: function (xhr, ajaxOption, thrownError) {
                    console.log(thrownError + '\r\n' + xhr.statusText + '\r\n' + xhr.responseText);
                }
            });
        }
        function calculateRatio()
        {
            let cartonqty = Number($('#qty').val());
            $('.ratio').each(function () {
                let ratio = Number($(this).val());
                let index = $(this).data('key');
                let qty = ratio * cartonqty;
                let available = Number($(`#carton_${index}_available_qty`).val());
                if(available < qty){
                    notification('error','Available Qty can not be Less Then Qty ');
                    $(`#carton_${index}_qty`).val('0');
                    $(this).val('0');
                }
                else{
                    $(`#carton_${index}_qty`).val(qty);

                }
            });
            calculateCarton();
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iconshoppercom/iconshopper/Modules/Carton/Resources/views/carton/create.blade.php ENDPATH**/ ?>