

<?php $__env->startSection('title', $page_title); ?>

<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-tagsinput/0.8.0/bootstrap-tagsinput.css" crossorigin="anonymous">
    <!-- select2 -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/css/select2.min.css" rel="stylesheet" />

    <!-- select2-bootstrap4-theme -->
    <link href="https://raw.githack.com/ttskch/select2-bootstrap4-theme/master/dist/select2-bootstrap4.css" rel="stylesheet"> <!-- for live demo page -->
    <link href="select2-bootstrap4.css" rel="stylesheet"> <!-- for local development env -->


<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="d-flex flex-column-fluid">
        <div class="container-fluid">
            <!--begin::Notice-->
            <div class="card card-custom gutter-b">
                <div class="card-header flex-wrap py-5">
                    <div class="card-title">
                        <h3 class="card-label"><i class="<?php echo e($page_icon); ?> text-primary"></i> <?php echo e($sub_title); ?></h3>
                    </div>
                    <div class="card-toolbar">
                        <!--begin::Button-->
                        <a href="<?php echo e(route('product')); ?>" class="btn btn-warning btn-sm font-weight-bolder">
                            <i class="fas fa-arrow-left"></i> Back</a>
                        <!--end::Button-->
                    </div>
                </div>
            </div>

            
            
            <form class="form form-horizontal mar-top"  action="" method="POST" enctype="multipart/form-data" id="store_or_update_form">
                <?php echo csrf_field(); ?>
                <div>
                    <div class="row">
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $p = \App\Models\Category::where('id',$cat->id)->first();
                            ?>
                            <div class="col-sm-2">
                                <div class="card" style="height: 300px;">
                                    <div class="card-body">
                                        <p style="text-align: center;"><img src='<?php echo e(asset('storage/'.PRODUCT_IMAGE_PATH.$cat->image)); ?>' alt='' style='width:100px;height: 133px;'/></p>
                                        <p style="text-align: center;padding-top: 0px;font-size: 12px;color: #034d97;font-weight: 600;"><?php echo e($cat->name); ?></p>
                                        <input name="products[<?php echo e($key + 1); ?>][id]" type="hidden" value="<?php echo e($cat->id); ?>">
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <input type="number" class="form-control" name="products[<?php echo e($key + 1); ?>][order_level]" id="order_level" value="<?php echo e($cat->order_level ?? 0); ?>" placeholder="Product Serial" required style="margin-bottom: 10px;">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>

                <div class="form-group col-md-12 pt-5 text-center ">
                    <button type="button" class="btn btn-primary btn-sm rounded" id="save-btn-1" onclick="storeData(1)">Save</button>
                </div>
            </form>
            <!--end::Card-->
        </div>

    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="js/spartan-multi-image-picker.min.js"></script>

    <script type="text/javascript">
        function storeData(btn){
            let form = document.getElementById('store_or_update_form');
            let formData = new FormData(form);

            $.ajax({
                url: "<?php echo e(route('category.serial.store')); ?>",
                type: "POST",
                data: formData,
                dataType: "JSON",
                contentType: false,
                processData: false,
                cache: false,
                beforeSend: function(){
                    $('#save-btn-'+btn).addClass('spinner spinner-white spinner-right');
                },
                complete: function(){
                    $('#save-btn-'+btn).removeClass('spinner spinner-white spinner-right');
                },
                success: function (data) {
                    $('#store_or_update_form').find('.is-invalid').removeClass('is-invalid');
                    $('#store_or_update_form').find('.error').remove();
                    if (data.status == false) {
                        $.each(data.errors, function (key, value){

                            console.log(key , value);
                            var key = key.split('.').join('_');
                            $('#store_or_update_form input#' + key).addClass('is-invalid');
                            $('#store_or_update_form textarea#' + key).addClass('is-invalid');
                            $('#store_or_update_form select#' + key).parent().addClass('is-invalid');
                            if(key == 'code'){
                                $('#store_or_update_form #' + key).parents('.form-group').append(
                                    '<small class="error text-danger">' + value + '</small>');
                            }else{
                                $('#store_or_update_form #' + key).parent().append(
                                    '<small class="error text-danger">' + value + '</small>');
                            }
                        });

                        $('html, body').animate({
                            scrollTop: ($('.is-invalid').offset().top - 300)
                        }, 1000);

                    } else {
                        notification(data.status, data.message);
                        if (data.status === 'success') {
                            window.location.reload();
                        }
                    }
                },
                error: function (xhr, ajaxOption, thrownError) {
                    console.log(thrownError + '\r\n' + xhr.statusText + '\r\n' + xhr.responseText);
                }
            });
        }

    </script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iconshoppercom/iconshopper/resources/views/category/allCategorySerial.blade.php ENDPATH**/ ?>