<?php
    use Modules\Product\Entities\ProductVariant;
    use App\Jobs\TestSendEmail;
?>
<?php if(count($combinations[0]) > 0): ?>
    <table class="table table-bordered table" id="variantTableContainer">
        <thead>
        <tr class="bg-primary" style="color: white;">

            <td class="text-center">
                <?php echo e('Variant'); ?>

            </td>
            <td class="text-center">
                <?php echo e('Code'); ?>

            </td>
            <td class="text-center" data-breakpoints="lg">
                <?php echo e('Quantity'); ?>

            </td>
            <td class="text-center">
                <?php echo e('Unit P.'); ?>

                <label class="aiz-switch aiz-switch-success mb-0">
                    <input type="checkbox" value="1" id="unit_price_apply_for_all">
                    <span></span>
                </label>
            </td>
            <td class="text-center">
                <?php echo e('Regular P.'); ?>

            </td>
            <td class="text-center">
                <?php echo e('Discount A.'); ?>

            </td>
            <td class="text-center">
                <?php echo e('Discount T.'); ?>

            </td>
            <td class="text-center">
                <?php echo e('Sale Price'); ?>

            </td>
            <td class="text-center" data-breakpoints="lg">
                <?php echo e('WholeSale Price'); ?>

                <label class="aiz-switch aiz-switch-success mb-0">
                    <input type="checkbox" value="1" id="whole_sale_apply_for_all">
                    <span></span>
                </label>
            </td>

            <td></td>
        </tr>
        </thead>
        <tbody>
        <?php $__currentLoopData = $combinations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key1 => $combination): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $sku = '';
                $idx = 0;
                foreach (explode(' ', $product_name) as $key => $value) {
                    $sku .= substr($value, 0, 1);
                }

                $str = '';
                $str_name = '';
                $str_id = '';
                $c_id = '';
                $attr_id = '';

                foreach ($combination as $key => $item) {
                    if ($key > 0) {
                        $str .= '-' . str_replace(' ', '', $item->name);
                        $str_name .= '-' . str_replace(' ', '', $item->name);
                        $str_id .= '-' . str_replace(' ', '', $item->id);
                        $attr_id .= str_replace(' ', '', $item->id) . '-';

                        $sku .= '-' . str_replace(' ', '', $item->name);
                    } else {
                        if ($colors_active == 1 && $key == 0) {
                            // dd($combination);

                            $color = \Modules\Product\Entities\Color::where('code', $item)->first();
                            $color_name = $color->name;
                            $color_id = $color->id;
                            $str .= $color_name;
                            $str_name .= $color_name;
                            $str_id .= $color_id;

                            $sku .= '-' . $color_name;
                            $c_id .= $color_id;
                        } else {
                            $str .= str_replace(' ', '', $item->name);
                            $str_name .= str_replace(' ', '', $item->name);
                            $str_id .= str_replace(' ', '', $item->id);
                            $attr_id .= str_replace(' ', '', $item->id);
                            $sku .= '-' . str_replace(' ', '', $item->name);
                        }
                    }
                }
            ?>
            <?php if(strlen($str) > 0): ?>
                <tr class="variant" id="MyTable">

                    <?php

                        $p = ProductVariant::where(['attribute_id' => $str_id, 'product_id' => $product_id])->first();
                        $warehouse_p = \Modules\Stock\Entities\WarehouseProduct::where('product_id',$product_id)->first();

                    ?>

                    <td>

                        <input type="hidden" name="product_attribute[<?php echo e($str_id); ?>][color_id]"
                               value="<?php echo e($c_id); ?>">
                        <input type="hidden" name="product_attribute[<?php echo e($str_id); ?>][attribute_id]"
                               value="<?php echo e($str_id); ?>">
                        <input type="hidden" name="product_attribute[<?php echo e($str_id); ?>][variant_id]"
                               value="<?php echo e($attr_id); ?>">


                        <label for="" class="control-label"><?php echo e($str); ?></label>
                        <input type="hidden" name="product_attribute[<?php echo e($str_id); ?>][product_variant_name]"
                               id="product_attribute_<?php echo e($str_id); ?>_product_variant_name"
                               value="<?php echo e($str); ?>">

                    </td>
                    <td>
                        <div class="form-group mb-0">
                            <div class="input-group" id="code_section">
                                <input type="text" class="form-control text-center"
                                       value="<?php echo e($p->product_code ?? ''); ?>"
                                       name="product_attribute[<?php echo e($str_id); ?>][product_code]"
                                       id="product_attribute_<?php echo e($str_id); ?>_product_code"
                                       data-row="<?php echo e($str_id); ?>" <?php if(isset($p->product_code)): ?> readonly <?php endif; ?>>

                                <?php if(!isset($p->product_code)): ?>
                                    <div class="input-group-prepend">
                                        <span class="input-group-text bg-primary"
                                              id="generate-<?php echo e($str_id); ?>-code"
                                              onclick="generate_variants_code('<?php echo e($str_id); ?>')"
                                              data-toggle="tooltip" data-theme="dark" title="Generate Code"
                                              style="border-top-right-radius: 0.42rem; border-bottom-right-radius: 0.42rem; border: 0; cursor: pointer; width: 0;">
                                            <i class="fas fa-retweet text-white" style="margin-left: -10px;"></i>
                                        </span>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </td>
                    <td>
                        <input type="number" lang="en" name="product_attribute[<?php echo e($str_id); ?>][qty]"
                               id="product_attribute_<?php echo e($str_id); ?>_qty" value="<?php echo e($warehouse_p->qty ?? 0); ?>"
                               min="0" step="1" class="form-control" required <?php if(isset($p->qty)): ?> readonly <?php endif; ?>>
                    </td>
                    <td>
                        <input type="number" lang="en"
                               name="product_attribute[<?php echo e($str_id); ?>][unit_price]"
                               id="product_attribute_<?php echo e($str_id); ?>_unit_price"
                               value="<?php echo e($p->unit_price ?? 0); ?>" min="0" step="0.01"
                               class="form-control unit_price_picker" required>
                    </td>
                    <td>
                        <input type="number" lang="en"
                               name="product_attribute[<?php echo e($str_id); ?>][regular_price]"
                               id="product_attribute_<?php echo e($str_id); ?>_regular_price"
                               oninput="calculateSalePrice1('<?php echo e(json_encode($str_id)); ?>')"
                               value="<?php echo e($p->regular_price ?? 0); ?>" min="0" step="0.01"
                               class="form-control calculateSalePrice_change" required >

                    </td>

                    <td>
                        <input type="number" lang="en"
                               name="product_attribute[<?php echo e($str_id); ?>][discount]"
                               value="<?php echo e($p->discount ?? 0); ?>"
                               oninput="calculateSalePrice1('<?php echo e(json_encode($str_id)); ?>')"
                               id="product_attribute_<?php echo e($str_id); ?>_discount" min="0" step="1"
                               class="form-control calculateSalePrice_change">
                    </td>
                    <td>
                        <select class="form-control selectpicker calculateSalePrice_change"
                                name="product_attribute[<?php echo e($str_id); ?>][discount_type]"
                                onchange="calculateSalePrice1('<?php echo e(json_encode($str_id) ?? 0); ?>')"
                                id="product_attribute_<?php echo e($str_id); ?>_discount_type">

                            <?php

                                if ($p) {
                                    $discount_types = $p->discount_type;
                                } else {
                                    $discount_types = '';
                                }

                            ?>
                            <option value="amount" <?php echo e($discount_types == 'amount' ? 'selected' : ''); ?>>
                                <?php echo e('Flat'); ?></option>

                            <option value="percent" <?php echo e($discount_types == 'percent' ? 'selected' : ''); ?>>
                                <?php echo e('Percent'); ?></option>
                        </select>
                    </td>


                    <td>
                        <input type="number" lang="en"
                               name="product_attribute[<?php echo e($str_id); ?>][sale_price]"
                               value="<?php echo e($p->sale_price ?? 0); ?>"
                               id="product_attribute_<?php echo e($str_id); ?>_sale_price" min="0" step="0.01"
                               class="form-control" id="salePrice-<?php echo e($key1); ?>" required>
                    </td>
                    <td>
                        <input type="number" lang="en"
                               name="product_attribute[<?php echo e($str_id); ?>][whole_sale_price]"
                               id="product_attribute_<?php echo e($str_id); ?>_whole_sale_price"
                               value="<?php echo e($p->whole_sale_price ?? 0); ?>" min="0" step="0.01"
                               class="form-control whole_sale_price_picker" required>
                    </td>

                    <td class="text-center">
                        <i class="fas fa-trash remove-product text-danger trash-button"
                           style="cursor:pointer;"></i>
                    </td>
                </tr>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>



    <?php if($colors_active): ?>
        <div class="card color_image_card">
            <div class="card-header">
                <h5 class="mb-0 h6"><?php echo e('Color Images'); ?></h5>
            </div>
            <div class="card-body">
                <div class="form-group row">
                    
                    <div class="col-md-12">
                        <div class="row">
                            <div class="form-group col-md-12 row mb-0 text-center">
                                <?php $__currentLoopData = $colors_only; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key_color => $color_item_code): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php

                                        $colorCode = $color_item_code; // Your color code

                                        // Remove the "#" symbol
                                        $colorCodeWithoutHash = str_replace('#', '', $colorCode);

                                        $color_images = \Modules\Product\Entities\ColorImage::where(['color_code' => $colorCodeWithoutHash, 'product_id' => $product_id])->get(['image']);

                                    ?>

                                    <?php if($color_images->isNotEmpty()): ?>
                                        <?php $__currentLoopData = $color_images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $color_idx => $color_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php

                                                $color_items_only = $color_item->image;

                                            ?>

                                            <?php if(isset($color_items_only)): ?>
                                                <?php $__currentLoopData = $color_items_only; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item_idx => $color_item_only): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div id="color_image_<?php echo e($colorCodeWithoutHash); ?>_<?php echo e($item_idx); ?>"
                                                         class="col-md-4 row"></div>
                                                    <input type="hidden"
                                                           id="color_old_image_<?php echo e($colorCodeWithoutHash); ?>_<?php echo e($item_idx); ?>"
                                                           name="color_old_image[<?= $colorCodeWithoutHash ?>][<?= $item_idx ?>]" />

                                                    <style>
                                                        .color_code_bg_<?php echo e($colorCodeWithoutHash); ?> {
                                                            background: #<?php echo e($colorCodeWithoutHash); ?>;

                                                        }
                                                    </style>

                                                    <script>
                                                        $('#color_image_<?= $colorCodeWithoutHash ?>_<?= $item_idx ?>').spartanMultiImagePicker({
                                                            fieldName: 'color_image[<?= $colorCodeWithoutHash ?>][<?= $item_idx ?>]',
                                                            maxCount: 1,
                                                            rowWidth: '380px', // Use rowWidth to set the width of the rows
                                                            rowHeight: '100px',
                                                            groupClassName: 'col-md-4 col-sm-4 col-xs-4 color_code_bg_<?= $colorCodeWithoutHash ?>',
                                                            maxFileSize: '',
                                                            dropFileLabel: "Drop Here",
                                                            allowedExt: '',
                                                            // onExtensionErr : function(index, file){
                                                            //     Swal.fire({icon: 'error',title: 'Oops...',text: 'Only png,jpg,jpeg file format allowed!'});
                                                            // },
                                                        });


                                                        // Modify the display of elements
                                                        $('#color_image_<?= $colorCodeWithoutHash ?>_<?= $item_idx ?> img').css('display', 'none');
                                                        $('#color_image_<?= $colorCodeWithoutHash ?>_<?= $item_idx ?> .spartan_remove_row').css('display', 'block');
                                                        $('#color_image_<?= $colorCodeWithoutHash ?>_<?= $item_idx ?> .img_').css('display', 'block');

                                                        // Set the image source and old image value
                                                        var imagePath = "<?php echo e(asset('storage/' . PRODUCT_IMAGE_PATH)); ?>/<?php echo e($color_item_only); ?>";
                                                        $('#color_image_<?= $colorCodeWithoutHash ?>_<?= $item_idx ?> .img_').attr('src', imagePath);
                                                        $('#color_old_image_<?= $colorCodeWithoutHash ?>_<?= $item_idx ?>').attr('value', "<?php echo e($color_item_only); ?>");
                                                    </script>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>



                                    <?php if($color_images->isEmpty()): ?>
                                        <?php for($i = 0; $i < 3; $i++): ?>
                                            <div id="color_image_<?php echo e($colorCodeWithoutHash); ?>_<?php echo e($i); ?>"
                                                 class="col-md-4 row"></div>
                                            <input type="hidden"
                                                   id="color_old_image_<?php echo e($colorCodeWithoutHash); ?>_<?php echo e($i); ?>"
                                                   name="color_old_image[<?= $colorCodeWithoutHash ?>][<?= $i ?>]"
                                                   value="" />

                                            <style>
                                                .color_code_bg_<?php echo e($colorCodeWithoutHash); ?> {
                                                    background: #<?php echo e($colorCodeWithoutHash); ?>;

                                                }
                                            </style>

                                            <script>
                                                $('#color_image_<?= $colorCodeWithoutHash ?>_<?= $i ?>').spartanMultiImagePicker({
                                                    fieldName: 'color_image[<?= $colorCodeWithoutHash ?>][<?= $i ?>]',
                                                    maxCount: 1,
                                                    rowWeight: '80px',
                                                    rowHeight: '80px',
                                                    groupClassName: 'col-md-4 col-sm-4 col-xs-4 color_code_bg_<?= $colorCodeWithoutHash ?>',
                                                    maxFileSize: '',
                                                    dropFileLabel: "Drop Here",
                                                    allowedExt: '',
                                                    // onExtensionErr : function(index, file){
                                                    //     Swal.fire({icon: 'error',title: 'Oops...',text: 'Only png,jpg,jpeg file format allowed!'});
                                                    // },
                                                });
                                            </script>
                                        <?php endfor; ?>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>

                            <input type="hidden" name="old_image" id="old_image" multiple>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
<?php else: ?>
    <p>No combinations available.</p>
<?php endif; ?>
<script src="js/spartan-multi-image-picker.min.js"></script>

<script>
    $(document).ready(function() {

        $('.calculateSalePrice_change').trigger('change');


        $("#unit_price_apply_for_all").on("change", function() {
            if ($(this).is(":checked")) {
                $(".unit_price_picker").attr("oninput", "setUnitPrice(this.value)");

            } else {
                $(".unit_price_picker").removeAttr("oninput");


            }
        });


        $("#whole_sale_apply_for_all").on("change", function() {
            if ($(this).is(":checked")) {
                $(".whole_sale_price_picker").attr("oninput", "setWholeSalePrice(this.value)");

            } else {

                $(".whole_sale_price_picker").removeAttr("oninput");


            }
        });



    });




    function calculateSalePrice1(item) {

        let row = JSON.parse(item);
        console.log(row, 'inside function');

        var regular_price = parseFloat($('#product_attribute_' + row + '_regular_price').val());
        var discountType = ($('#product_attribute_' + row + '_discount_type').val());
        var discountValue = parseFloat($('#product_attribute_' + row + '_discount').val());


        console.log(discountType, discountValue);

        if (isNaN(regular_price) || isNaN(discountValue)) {
            // $('#result').text("Please enter valid numbers.");
            return;
        }

        var salePrice = regular_price; // Initialize sale price with unit price

        if (discountType === 'percent') {
            salePrice = regular_price - (regular_price * (discountValue / 100));
        } else if (discountType === 'amount') {
            salePrice = regular_price - discountValue;
        }

        $('#product_attribute_' + row + '_sale_price').val(salePrice.toFixed(2));
        $('.selectpicker').selectpicker('refresh');

    }


    function setUnitPrice(unitPrice) {

        $('.unit_price_picker').val(unitPrice);

    }

    function setWholeSalePrice(unitPrice) {

        $('.whole_sale_price_picker').val(unitPrice);

    }

</script>
<?php /**PATH /home/iconshoppercom/iconshopper/Modules/Product/Resources/views/edit_sku_combinations.blade.php ENDPATH**/ ?>