
<?php $__env->startSection('title', $page_title); ?>
<?php $__env->startPush('styles'); ?>
    <link href="<?php echo e(asset('css/bootstrap-datetimepicker.min.css')); ?>" rel="stylesheet" type="text/css" />
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <div class="d-flex flex-column-fluid">
        <div class="container-fluid">
            <div class="card card-custom gutter-b">
                <div class="card-header flex-wrap py-5">
                    <div class="card-title">
                        <h3 class="card-label"><i class="<?php echo e($page_icon); ?> text-primary"></i> <?php echo e($sub_title); ?></h3>
                    </div>
                    <div class="card-toolbar"><a href="<?php echo e(route('requisition')); ?>"
                                                 class="btn btn-warning btn-sm font-weight-bolder"><i
                                class="fas fa-arrow-left"></i><?php echo e('Back'); ?></a></div>
                </div>
            </div>
            <div class="card card-custom" style="padding-bottom: 100px !important;">
                <div class="card-body">
                    <form id="transfer_form" method="post" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-md-3 form-group" id="showStore">

                            </div>
                            <div class="form-group col-md-12">
                                <label for="sku_name">Search</label>
                                <input type="text" class="form-control" name="product_code_name" id="product_code_name"
                                       placeholder="Scan/Search by product code">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12 pb-5">
                                <table class="table table-bordered" id="stock-transfer-table">
                                    <thead class="bg-primary">
                                    <tr class="text-center">
                                        <th width="15%"><?php echo e('Product Name'); ?></th>
                                        <th width="15%"><?php echo e('Variant'); ?></th>
                                        <th width="15%"><?php echo e('Product Code'); ?></th>
                                        <th width="15%"><?php echo e('Sku'); ?></th>

                                        <th width="15%"><?php echo e('Qty'); ?></th>
                                        <th width="5%"><?php echo e('Action'); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody></tbody>
                                    <tfoot>
                                    <tr>
                                        <td></td>
                                        <td colspan="3"><button type="button"
                                                                class="text-right btn btn-primary btn-block"><b><?php echo e('Total Quantity'); ?></b></button>
                                        </td>
                                        <td><button type="button" class="text-left btn btn-primary btn-block"><input
                                                    type="hidden" id="total_qty" name="total_qty" /> <b><span
                                                        id="total_qty_show">0</span></b></button></td>
                                    </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                        <div class="form-group col-md-12">
                            <label for="shipping_cost">Customer Information</label>
                            <textarea class="form-control" name="address" id="address" cols="30" rows="3"></textarea>
                        </div>
                        <div class="row pt-5">
                            <div class="form-group col-md-12 text-center px-0">
                                <button type="button" class="btn btn-primary btn-sm mr-3" id="save-btn" onclick="transferData()"><i class="fas fa-save"></i><?php echo e('Submit'); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('js/jquery-ui.js')); ?>"></script>
    <script src="<?php echo e(asset('js/moment.js')); ?>"></script>
    <script src="<?php echo e(asset('js/knockout-3.4.2.js')); ?>"></script>
    <script src="<?php echo e(asset('js/daterangepicker.min.js')); ?>"></script>
    <script type="text/javascript">
        function _(x) {
            return document.getElementById(x);
        }
        let i = 1;
        let j = 10000000;

        $(document).ready(function(){
            // selectedStore();
            $('#product_code_name').on('input', function(){
                let type = $('#type').val();

                var temp_data = $('#product_code_name').val();
            });

            $('#product_code_name').autocomplete({
                source: function(request, response){
                    $.ajax({
                        url: "<?php echo e(url('itemProposal-product-search')); ?>",
                        type: 'post',
                        dataType: "json",
                        data: {
                            _token: _token,
                            search: request.term,
                            warehouse_id: $('#transfer_warehouse_id option:selected').val()

                        },
                        success: function(data) {
                            response(data);
                        }
                    });
                },
                // minLength: 3,
                response: function(event, ui) {
                    if (ui.content.length == 1) {
                        let code = ui.content[0].code;
                        let productId = ui.content[0].product_id;
                        let hasVariant = ui.content[0].variant;
                        let variant_id = ui.content[0].variant_id;
                        let variation = ui.content[0].label;
                        $(this).autocomplete("close");
                        product_barcode_search(productId, hasVariant, code, variant_id, variation);
                        notification('success', 'Successfully Added To Cart');

                    };
                },
                select: function(event, ui){
                    let code = ui.item.code;
                    let productId = ui.item.product_id;
                    let hasVariant = ui.item.variant;
                    let variant_id = ui.item.variant_id;
                    let variation = ui.item.label;
                    product_barcode_search(productId, hasVariant, code, variant_id, variation);
                },
            }).data('ui-autocomplete')._renderItem = function(ul, item){
                return $("<li class='ui-autocomplete-row'></li>")
                    .data("item.autocomplete", item)
                    .append(item.label)
                    .appendTo(ul);
            };
        });



        $(document).on('input', '.qty', function(){
            // let stockQty = parseFloat(_($(this).data('stock_qty')).value);
            let value = $(this).val();
            if (value) {

            } else {
                $(this).val('');
                notification('error', 'Transfer Quantity Can\'t Be Greater Then Stock Quantity');
            }
            calculation();
        })

        $('#stock-transfer-table').on('click', '.remove-product', function () {
            rowindex = $(this).closest('tr').index();
            // product_price.splice(rowindex, 1);

            $(this).closest('tr').remove();
            calculation();
            notification('success', 'Product Removed Successfully');
        });

        function calculation() {
            let qty = 0;
            $('.qty').each(function() {
                if ($(this).val() == '') {
                    qty += +0;
                } else {
                    qty += +$(this).val();
                }
            });
            _('total_qty').value = qty;
            _('total_qty_show').innerText = qty;
        }



        function transferData(){
                let form = _('transfer_form');
                let formData = new FormData(form);
                let url = "<?php echo e(route('itemProposal.store')); ?>";
                $.ajax({
                    url: url,
                    type: "POST",
                    data: formData,
                    dataType: "JSON",
                    contentType: false,
                    processData: false,
                    cache: false,
                    beforeSend: function() {
                        $('#save-btn').addClass('spinner spinner-white spinner-right');
                    },
                    complete: function() {
                        $('#save-btn').removeClass('spinner spinner-white spinner-right');
                    },
                    success: function(data) {
                        $('#transfer_form').find('.is-invalid').removeClass('is-invalid');
                        $('#transfer_form').find('.error').remove();
                        if (data.status == false) {
                            $.each(data.errors, function(key, value) {
                                var key = key.split('.').join('_');
                                $('#transfer_form input#' + key).addClass('is-invalid');
                                $('#transfer_form textarea#' + key).addClass('is-invalid');
                                $('#transfer_form select#' + key).parent().addClass('is-invalid');
                                $('#transfer_form #' + key).parent().append(
                                    '<small class="error text-danger">' + value + '</small>');
                            });
                        } else {
                            notification(data.status, data.message);
                            if (data.status == 'success') {
                                window.location.replace("<?php echo e(route('item.proposal')); ?>");
                            }
                        }
                    },
                    error: function(xhr, ajaxOption, thrownError) {
                        console.log(thrownError + '\r\n' + xhr.statusText + '\r\n' + xhr.responseText);
                    }
                });
        }

        function product_barcode_search(product_id, hasVariant, code, variant_id, variation){
            let html = '';
            $.ajax({
                url: "<?php echo e(route('itemProposal.warehouse.product')); ?>",
                type: 'POST',
                data: {
                    code: code,
                    _token: _token,
                    warehouse_id: $('#transfer_warehouse_id option:selected').val(),
                    type_id: $('#type option:selected').val(),
                    product_id: product_id,
                    hasVariant: hasVariant
                },
                success: function(data){
                    console.log(data.productName);
                        var flag = 1;
                        $('#product_code_name').val('');
                        if (flag) {
                            html =
                                `<tr class = "text-center">
                                    <input type="hidden" id="transfer_` + i + `_product_code" name="transfer[` + i + `][product_code]" value = "` + data.product_code + `"/>
                                    <input type="hidden" id="transfer_` + i + `_type" name="transfer[` + i + `][type]" value = "` + data.type + `"/>

                                       <td>
                                            <input type="text" class="form-control bg-primary text-white product-name" id="transfer_` + i + `_product_name"  value="` + data.productName + `" readonly/>
                                            <input type="hidden" id="transfer_` + i + `_product_id" name="transfer[` + i + `][product_id]" value = "` + data.productId + `"/>
                                        </td>
                                        <td>
                                            <input type="text" class="form-control bg-primary text-white product_variant" id="transfer_` + i + `_product_variant"  value="` + data.variant + `" readonly/>
                                            <input type="hidden" id="transfer_` + i + `_product_variant" name="transfer[` + i + `][product_variant]" value = "` + data.variant + `"/>
                                        </td>
                                        <td>
                                            <input type="text" class="form-control bg-primary text-white product_code" id="transfer_` + i + `_product_code"  value="` + data.product_code + `" readonly/>
                                            <input type="hidden" id="transfer_` + i + `_product_code" name="transfer[` + i + `][product_code]" value = "` + data.product_code + `"/>
                                        </td>
                                        <td>
                                            <input type="text" class="form-control bg-primary text-white sku" id="transfer_` + i + `_sku"  value="` + data.sku + `" readonly/>
                                            <input type="hidden" id="transfer_` + i + `_sku" name="transfer[` + i + `][sku]" value = "` + data.sku + `"/>
                                        </td>

                                       <td><input type="text" class="form-control qty" id="transfer_` + i + `_qty" data-stock_qty="transfer_` + i + `_stock_qty" name="transfer[` + i + `][qty]"/></td>
                                        <td class="text-center d-flex"><button type="button" class="btn btn-danger btn-sm remove-product"><i class="fas fa-trash"></i></button></td>
                                    </tr>`
                            $('#stock-transfer-table tbody').append(html);
                            i++;
                        }
                }
            });
        }

    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iconshoppercom/iconshopper/Modules/ItemProposal/Resources/views/create.blade.php ENDPATH**/ ?>