<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="images/favicon.png" rel="icon"/>
    <title><?php echo e($sale->name ? $sale->name : $sale->customer->name); ?> - IconShopper Invoice</title>
    <meta name="author" content="harnishdesign.net">

    <!-- Web Fonts
    ======================= -->
    <link rel='stylesheet' href='https://fonts.googleapis.com/css?family=Poppins:100,200,300,400,500,600,700,800,900' type='text/css'>

    <!-- Stylesheet
    ======================= -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('invoice/inv_bootstrap.min.css')); ?>"/>
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css"
          integrity="sha512-1ycn6IcaQQ40/MKBW2W4Rhis/DbILU74C1vSrLJxCq57o941Ym01SwNsOMqvEBFlcgUa6xLiPY/NS5R+E6ztJQ==" crossorigin="anonymous" referrerpolicy="no-referrer"/>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('invoice/inv_stylesheet.css')); ?>"/>
    <style>
        .ticket {
            width: 85%;
            max-width: 100%;
        }

        @media  print {
            /*@page  {*/
            /*    size: A4 landscape; !* Set page size to landscape A4 *!*/
            /*}*/
            body {
                width: 210mm; /* Set the body width to half of A4 width */
                height: 148mm; /* Set the body height to A4 height */
                background: #FFFFFF;
            }

            .invoice-container {
                border: none !important;
                margin-top: -3%;
                transform: scaleY(0.7);
                transform-origin: top left;
                width: 150% !important; /* Set the width of the invoice to half of the body width */
                /*height: 50%; !* Set the height to the full body height *!*/
                /*float: left; !* Make it float to the left so it takes the left half *!*/
            }

            .hidden-print,
            .hidden-print * {
                display: none !important;
            }
        }
    </style>
</head>
<body>
<!-- Container -->
<div class="container-fluid invoice-container">
    <?php
        date_default_timezone_set('Asia/Dhaka');
        $date = date('Y-m-d');
        $reference = date('Ymd');
        $date_time = date('Y-m-d h:i:s A');
    ?>
        <!-- Header -->
    <header>
        <div class="row align-items-center">
            <div class="col-sm-2 text-center text-sm-start mb-3 mb-sm-0">
                <img id="logo" src="<?php echo e(asset('images/logo.png')); ?>" title="Iconshopper" alt="Iconshopper" width="110px"/>
            </div>
            <div class="col-sm-10 text-center text-sm-end">
                <h4 class="text-7 mb-0">Iconshopper - Invoice</h4>
                <?php
                    $showroom = \Illuminate\Support\Facades\DB::table('showrooms')->where('id', $sale->showroom_id)->first();
                    $created_by = \App\Models\User::where('id', $sale->created_by)->pluck('name')->first();
                ?>
                <address>
                    <?php echo e($showroom->address); ?><br/>
                    <strong>Phone: </strong><?php echo e(config('settings.contact_no')); ?> <strong>Email: </strong><?php echo e(config('settings.email')); ?>

                </address>
            </div>
        </div>
        <hr>
    </header>

    <!-- Main Content -->
    <main>
        <div class="row">
            <div class="col-sm-4">
                <strong>Date:</strong> <?php echo e(date('d-M-Y', strtotime($sale->sale_date))); ?><br>
                <strong>Payment Status:</strong> <span class="badge bg-warning text-dark rounded-pill"><?php echo e(PAYMENT_STATUS[$sale->payment_status ?? 3]); ?></span><br>
                <strong>Invoice No:</strong> <?php echo e($sale->invoice_no); ?> <br>
                <div style="text-align: left;width:100%;">
                    
                    <img src="<?php echo e('data:image/png;base64,' . DNS1D::getBarcodePNG($sale->invoice_no, 'C128')); ?>" alt="<?php echo e($sale->invoice_no); ?>"
                         style="font-family: sans-serif;width: 80% !important; color: black"/>
                </div>

                
                <strong>Created By:</strong> <?php echo e($created_by); ?>

            </div>
            <div class="col-sm-8 text-sm-end">
                <strong>Invoiced To:</strong>
                <address>
                    <?php echo e($sale->name ? $sale->name : $sale->customer->name); ?><br />
                    <?php if($sale->sale_type == 4): ?>
                        <?php echo e($sale->information); ?><br> 
                    <?php else: ?>
                        <?php echo e($sale->shipping_address ? $sale->shipping_address : $sale->customer->address); ?><br />
                    <?php endif; ?>
                    <?php echo e($sale->phone ? $sale->phone : $sale->customer->mobile); ?><br />
                </address>
            </div>

        </div>
        <hr>
        
        
        
        

        <div class="card">
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table mb-0">
                        <thead class="card-header">
                        <tr>
                            <td class="col-3"><strong>Product</strong></td>
                            <td class="col-1"><strong>SKU</strong></td>
                            <td class="col-2"><strong>Code</strong></td>
                            <td class="col-1"><strong>Price</strong></td>
                            <td class="col-1 text-center"><strong>QTY</strong></td>
                            <td class="col-1 text-center"><strong>Discount</strong></td>
                            <td class="col-2 text-end"><strong>Amount</strong></td>
                        </tr>
                        </thead>
                        <tbody>
                        <?php if(!$sale->products->isEmpty()): ?>
                            <?php $__currentLoopData = $sale->products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $unit_name = '';
                                    if ($item->sale_unit_id) {
                                        $unit_name = \Illuminate\Support\Facades\DB::table('units')
                                            ->where('id', $item->pivot->sale_unit_id)
                                            ->value('unit_name');
                                    }
                                ?>
                                <?php
                                    $productCode = '';
                                    if (!empty($item->pivot->variant_id)) {
                                        $variant = \Illuminate\Support\Facades\DB::table('product_variants as pv')
                                            ->where('pv.product_id', $item->id)
                                            ->where('pv.product_code', $item->pivot->product_code)
                                            ->first();

                                        $color = '';
                                        if (!empty($variant->color_id)) {
                                            $colorObj = \Illuminate\Support\Facades\DB::table('colors')
                                                ->where('id', $variant->color_id)
                                                ->first('name');
                                            $color = $colorObj->name . '-';
                                        }

                                        $attributes = '';
                                        if (!empty($variant->variant_id)) {
                                            $attributeArr = array_filter(explode('-', $variant->variant_id));

                                            foreach ($attributeArr as $attributeKey => $attributeValue) {
                                                $variantValue = \Illuminate\Support\Facades\DB::table('attribute_values')
                                                    ->where('id', $attributeValue)
                                                    ->first('value');
                                                if ($variantValue) {
                                                    if ($attributeKey != 0) {
                                                        $attributes .= '-' . $variantValue->value;
                                                    } else {
                                                        $attributes = $variantValue->value;
                                                    }
                                                }
                                            }
                                        }
                                        $productCode = $color . '' . $attributes;
                                    } else {
                                        $productCode = $item->product_code;
                                    }
                                ?>
                                <tr>
                                    <td class="col-3"><?php echo e($item->product_name); ?></td>
                                    <td class="col-1"><?php echo e($item->sku); ?></td>
                                    <td class="col-1"><?php echo e($item->pivot->product_code); ?> - <?php echo e($productCode); ?></td>
                                    <td class="col-2 text-1">
                                        <?php if($sale->sale_type == 4): ?>
                                            <?php echo e(number_format($item->pivot->regular_price, 2)); ?> ৳
                                        <?php elseif($sale->sale_type != 4): ?>
                                            <?php echo e(number_format($item->pivot->net_unit_price, 2)); ?> ৳
                                        <?php endif; ?>







                                    </td>
                                    <td class="col-1 text-center"><?php echo e($item->pivot->qty . ' ' . $unit_name); ?></td>
                                    <td class="col-1 text-center">
                                        <?php echo e(number_format($item->pivot->discount ?? '0', 2)); ?> <?php echo e(($item->pivot->discount_type == 1 ? ' ৳' : ($item->pivot->discount_type == 2 ? ' %' : ''))); ?>

                                    </td>
                                    <td class="col-2 text-end">
                                        <?php if(config('settings.currency_position') == 2): ?>
                                            <?php echo e(number_format($item->pivot->total, 2)); ?>

                                            <?php echo e(config('settings.currency_symbol')); ?>

                                        <?php else: ?>
                                            <?php echo e(config('settings.currency_symbol')); ?>

                                            <?php echo e(number_format($item->pivot->total, 2)); ?>

                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                        </tbody>

                    </table>
                    <div class="row col-sm-12">
                        <div class="col-sm-6">
                            <?php if(isset($sale->payments)): ?>
                                <?php $__currentLoopData = $sale->payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <p class="text-2 ms-4 h2" style="margin-top: 10px"><?php echo e(SALE_PAYMENT_METHOD[$payment->payment_method]); ?> (<?php echo e($payment->coa->name); ?>) - <?php echo e($payment->paid_amount); ?> ৳</p>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                            <?php if(isset($sale->notes)): ?>
                                <p class="text-1 ms-4 h2" style="margin-top: 10px"><strong>NOTE :</strong> <?php echo e($sale->notes); ?></p>
                            <?php elseif(isset($status_last->note)): ?>
                                <p class="text-1 ms-4 h3" style="margin-top: 10px"><strong>NOTE :</strong> <?php echo e($status_last->note); ?></p>
                            <?php endif; ?>
                            <?php if($sale->exchange_type == 1): ?>
                                <?php
                                    $old_product_invoice = \Modules\Exchange\Entities\Exchange::where('return_no',$sale->invoice_no)->first('invoice_no');
                                    $old_product        = \Modules\Exchange\Entities\ExchangeProduct::where('invoice_no',$sale->invoice_no)->get();
                                ?>
                                <div style="margin: 14px;border-style: dotted;width: 129%;">
                                    <table class="table mb-0" style="border-radius: 2px;">
                                        <h1 style="font-size: 17px;margin: 14px;">Old Invoice: <?php echo e($old_product_invoice->invoice_no); ?></h1>
                                        <thead class="card-header">
                                        <tr>
                                            <td class="col-3"><strong>Product</strong></td>
                                            <td class="col-1"><strong>Price</strong></td>
                                            <td class="col-1 text-center"><strong>QTY</strong></td>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php $__currentLoopData = $old_product; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td>
                                                    <?php echo e($row->product->product_name); ?>-<?php echo e($row->product_variant->product_variant_name); ?>-<?php echo e($row->product->sku); ?>

                                                    - <?php echo e($row->old_product_code); ?>

                                                </td>
                                                <td><?php echo e($row->old_price); ?></td>
                                                <td><?php echo e($row->old_exchange_qty); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>

                                    </table>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="text-end col-sm-6 p-0">
                            <div class="row col-sm-12 m-auto mt-2">
                                <div class="col-sm-3"></div>
                                <div class="col-sm-5"><strong>Sub Total:</strong></div>
                                <div class="col-sm-4">
                                    <?php if(config('settings.currency_position') == 2): ?>
                                        <?php echo e(number_format($sale->total_price, 2, '.', ',')); ?>

                                        <?php echo e(config('settings.currency_symbol')); ?>

                                    <?php else: ?>
                                        <?php echo e(config('settings.currency_symbol')); ?>

                                        <?php echo e(number_format($sale->total_price, 2, '.', ',')); ?>

                                    <?php endif; ?>

                                </div>
                            </div>

                            <div style="width: 65%;height:1px;border-top:1px dashed rgb(0, 0, 0)" class="float-end"></div>
                            <div class="row col-sm-12 m-auto">
                                <div class="col-sm-3"></div>
                                <div class="col-sm-5"><strong>Discount:</strong></div>
                                <div class="col-sm-4">
                                    <?php if(config('settings.currency_position') == 2): ?>
                                        <?php echo e(number_format($sale->order_discount, 2, '.', ',')); ?>

                                        <?php echo e(config('settings.currency_symbol')); ?>

                                    <?php else: ?>
                                        <?php echo e(config('settings.currency_symbol')); ?>

                                        <?php echo e(number_format($sale->order_discount, 2, '.', ',')); ?>

                                    <?php endif; ?>
                                </div>
                            </div>
                            <?php if(!empty($sale->card_number)): ?>
                                <div class="row col-sm-12 m-auto">
                                    <div class="col-sm-3"></div>
                                    <div class="col-sm-5"><strong>Gift Card Amount:</strong></div>
                                    <div class="col-sm-4">
                                        <?php if(config('settings.currency_position') == 2): ?>
                                            <?php echo e(number_format($sale->use_balance, 2, '.', ',')); ?>

                                            <?php echo e(config('settings.currency_symbol')); ?>

                                        <?php else: ?>
                                            <?php echo e(config('settings.currency_symbol')); ?>

                                            <?php echo e(number_format($sale->use_balance, 2, '.', ',')); ?>

                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                            
                            
                            
                            
                            
                            
                            
                            
                            
                            
                            
                            
                            
                            
                            
                            
                            
                            
                            
                            
                            
                            
                            
                            
                            
                            
                            
                            
                            
                            
                            
                            
                            
                            <div class="row col-sm-12 m-auto">
                                <div class="col-sm-3"></div>
                                <div class="col-sm-5"><strong>Net Total:</strong></div>
                                <div class="col-sm-4">
                                    <?php if(config('settings.currency_position') == 2): ?>
                                        <?php echo e(number_format($sale->net_total, 2, '.', ',')); ?>

                                        <?php echo e(config('settings.currency_symbol')); ?>

                                    <?php else: ?>
                                        <?php echo e(config('settings.currency_symbol')); ?>

                                        <?php echo e(number_format($sale->net_total, 2, '.', ',')); ?>

                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="row col-sm-12 m-auto">
                                <div class="col-sm-3"></div>
                                <div class="col-sm-5"><strong>Delivery Charge:</strong></div>
                                <div class="col-sm-4">
                                    <?php if(config('settings.currency_position') == 2): ?>
                                        <?php echo e(number_format($sale->shipping_cost, 2, '.', ',')); ?>

                                        <?php echo e(config('settings.currency_symbol')); ?>

                                    <?php else: ?>
                                        <?php echo e(config('settings.currency_symbol')); ?>

                                        <?php echo e(number_format($sale->shipping_cost, 2, '.', ',')); ?>

                                    <?php endif; ?>
                                </div>
                            </div>
                            <div style="width: 65%;height:1px;border-top:1px dashed rgb(0, 0, 0)" class="float-end"></div>
                            <div class="row col-sm-12 m-auto">
                                <div class="col-sm-3"></div>
                                <div class="col-sm-5"><strong>Grand Total:</strong></div>
                                <div class="col-sm-4">
                                    <?php if(config('settings.currency_position') == 2): ?>
                                        <?php echo e(number_format($sale->grand_total, 2, '.', ',')); ?>

                                        <?php echo e(config('settings.currency_symbol')); ?>

                                    <?php else: ?>
                                        <?php echo e(config('settings.currency_symbol')); ?>

                                        <?php echo e(number_format($sale->grand_total, 2, '.', ',')); ?>

                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="row col-sm-12 m-auto">
                                <div class="col-sm-3"></div>
                                <div class="col-sm-5"><strong>Paid Amount:</strong></div>
                                <div class="col-sm-4">
                                    <?php if(config('settings.currency_position') == 2): ?>
                                        <?php echo e(number_format($sale->paid_amount, 2, '.', ',')); ?>

                                        <?php echo e(config('settings.currency_symbol')); ?>

                                    <?php else: ?>
                                        <?php echo e(config('settings.currency_symbol')); ?>

                                        <?php echo e(number_format($sale->paid_amount, 2, '.', ',')); ?>

                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="row col-sm-12 m-auto">
                                <div class="col-sm-3"></div>
                                <div class="col-sm-5"><strong>Due Amount:</strong></div>
                                <div class="col-sm-4">
                                    <?php if(config('settings.currency_position') == 2): ?>
                                        <?php echo e(number_format($sale->due_amount, 2, '.', ',')); ?>

                                        <?php echo e(config('settings.currency_symbol')); ?>

                                    <?php else: ?>
                                        <?php echo e(config('settings.currency_symbol')); ?>

                                        <?php echo e(number_format($sale->due_amount, 2, '.', ',')); ?>

                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
    <!-- Footer -->
    <footer class="text-center">
        <p class="text-1 mt-1">Item sold will not be returned. Exchange will be executed Between 7 days with good
            condition of product with Money receipt. Thanks for allowing us to serve you.</p>
        <div class="btn-group btn-group-sm d-print-none"><a href="<?php echo e(route('ecommerce-order-list')); ?>" class="btn btn-danger border shadow-none me-2"><i
                    class="fas fa-arrow-left"></i> Back</a><a
                href="javascript:window.print()" class="btn btn-warning text-dark border shadow-none"><i class="fas fa-print"></i>
                Print</a></div>
    </footer>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/js/all.min.js"
        integrity="sha512-Tn2m0TIpgVyTzzvmxLNuqbSJH3JP8jm+Cy3hvHrW7ndTDcJ1w5mBiksqDBb8GpE2ksktFvDB/ykZ0mDpsZj20w==" crossorigin="anonymous"
        referrerpolicy="no-referrer">
</script>
<script>
    window.print();
</script>
</body>
</html>
<?php /**PATH /home/iconshoppercom/iconshopper/Modules/Sale/Resources/views/ecommerce-pos/pos-invoice.blade.php ENDPATH**/ ?>