
<?php $__env->startSection('title', $page_title); ?>
<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('css/jquery-ui.css')); ?>"/>
    <link href="<?php echo e(asset('css/bootstrap-datetimepicker.min.css')); ?>" rel="stylesheet" type="text/css"/>
    <style>
        .small-btn {
            width: 20px !important;
            height: 20px !important;
            padding: 0 !important;
        }

        .small-btn i {
            font-size: 10px !important;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <div class="d-flex flex-column-fluid">
        <div class="container-fluid">
            <div class="card card-custom gutter-b">
                <div class="card-header flex-wrap py-5">
                    <div class="card-title"><h3 class="card-label"><i class="<?php echo e($page_icon); ?> text-primary"></i> <?php echo e($sub_title); ?></h3></div>
                    <?php if(permission('sale-access')): ?>
                        <div class="card-toolbar"><a href="<?php echo e(route('sale')); ?>" class="btn btn-warning btn-sm font-weight-bolder"><i
                                    class="fas fa-arrow-left"></i> <?php echo e(__('file.Back')); ?></a></div>
                    <?php endif; ?>
                </div>
            </div>
            <div class="card card-custom">
                <div class="card-body">
                    <div id="kt_datatable_wrapper" class="dataTables_wrapper dt-bootstrap4 no-footer">
                        <form action="" id="sale_store_form" method="post" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <input type="hidden" name="reseller_id" value="<?php echo e($sale->reseller_id); ?>">
                                <input type="hidden" name="customer_id" value="<?php echo e($sale->customer_id); ?>">
                                <input type="hidden" class="sale_type" name="sale_type" value="<?php echo e($sale->sale_type); ?>">
                                <input type="hidden" name="showroom_id" value="<?php echo e($sale->showroom_id); ?>">
                                <input type="hidden" name="warehouse_id" value="<?php echo e($sale->warehouse_id); ?>">
                                <input type="hidden" name="name" value="<?php echo e($sale->name); ?>">
                                <input type="hidden" name="phone" value="<?php echo e($sale->phone); ?>">
                                <input type="hidden" name="information" value="<?php echo e($sale->information); ?>">
                                <input type="hidden" name="sale_type" value="<?php echo e($sale->sale_type); ?>">
                                <input type="hidden" class="form-control" name="sale_date" id="sale_date" value="<?php echo e($sale->sale_date); ?>" readonly/>

                                <div class="form-group col-md-3 required">
                                    <label for="invoice_no">Invoice No.</label>
                                    <input type="text" class="form-control" name="invoice_no" id="invoice_no" value="<?php echo e($sale->invoice_no); ?>" readonly/>
                                </div>
                                <div class="form-group col-md-3 required">
                                    <label>Exchange Status</label>
                                    <select class="form-control"  name="status" >
                                        <option value="1">Pending</option>
                                        <option value="2">Approved</option>
                                    </select>
                                </div>
                                <div class="form-group col-md-3 required">
                                    <label for="return_date">Exchange Date</label>
                                    <input type="text" class="form-control date" name="return_date" id="return_date" value="<?php echo e(date('Y-m-d')); ?>" readonly/>
                                </div>
                                <div class="form-group col-md-3 required">
                                    <label for="customer_name">Customer Name</label>
                                    <input type="text" class="form-control" name="customer_name" value="<?php echo e($sale->name ? $sale->name : $sale->customer->name); ?>" readonly/>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <div class="">
                                            <table class="table table-bordered quarterSelectTable" id="oldSaleTable">
                                                <thead class="bg-primary text-center">

                                                <th width="20%"><?php echo e(__('Product Name')); ?></th>
                                                <th width="20%" style="width: 10% !important;"><?php echo e(__('Code')); ?></th>
                                                <th width="5%" style="width: 5% !important;"><?php echo e(__('Sold Qty')); ?></th>
                                                <th width="10%"><?php echo e(__('Sale Price')); ?></th>
                                                <th width="5%" style="width: 5% !important;"><?php echo e(__('Exchange Qty')); ?></th>
                                                <th width="10%"><?php echo e(__('Action')); ?></th>
                                                </thead>
                                                <tbody>
                                                <tr class="text-center">
                                                    <td width="20%">
                                                        <select class="form-control selectpicker productDetails" id="old_sale_1_old_product_id" data-product_id="old_sale_1_product_id"
                                                                data-product_code="old_sale_1_product_code" data-stock_qty="old_sale_1_stock_qty" data-price="old_sale_1_price"
                                                                name="old_sale[1][old_product_id]" data-live-search="true">
                                                            <option value="" selected>Select Product</option>
                                                            <?php if(!$sale->sale_products->isEmpty()): ?>
                                                                <?php $__currentLoopData = $sale->sale_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $sale_product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <option value="<?php echo e($sale_product->id); ?>"><?php echo e(!empty($sale_product->variant_id) ? \Str::slug($sale_product->product->product_name) .' -'. ($sale_product->product->sku ).' - ('.$sale_product->productVariant->product_variant_name.')' : $sale_product->product->product_name); ?></option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            <?php endif; ?>
                                                        </select>
                                                        <input type="hidden" class="form-control" id="old_sale_1_product_id" name="old_sale[1][old_product_id]" readonly/>
                                                    </td>
                                                    <td width="10%"><input type="text" class="form-control bg-primary text-white" id="old_sale_1_product_code" name="old_sale[1][old_product_code]" readonly/></td>
                                                    <td width="10%"><input type="text" class="form-control bg-primary text-white" id="old_sale_1_stock_qty" name="old_sale[1][old_stock_qty]" readonly/></td>
                                                    <td width="10%"><input type="number" class="form-control price" id="old_sale_1_price" name="old_sale[1][old_price]"/></td>
                                                    <td width="10%">
                                                        <input type="number" class="form-control old_exchange_qty" id="old_sale_1_old_exchange_qty" name="old_sale[1][old_exchange_qty]"/>

                                                    </td>
                                                    <td>
                                                        <button type="button" class="btn btn-primary btn-sm oldProductAddRaw"><i class="fas fa-plus-circle"></i></button>
                                                    </td>
                                                </tr>
                                                </tbody>
                                                <tfoot>
                                                    <tr>
                                                        <td colspan="4" style="color: #000 !important;border: none;" class="text-right font-weight-bolder">Exchange Qty</td>

                                                        <td class="text-right font-weight-bolder"  colspan="2">
                                                            <input class="form-control  text-right exchange_qty" type="text" name="exchange_qty" id="exchange_qty" readonly>

                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td colspan="4" style="color: #000 !important;border: none;" class="text-right font-weight-bolder">Previous Payment</td>

                                                        <td class="text-right font-weight-bolder"  colspan="2">
                                                            <input class="form-control  text-right" type="text" name="previous_payment" value="<?php echo e($sale->grand_total); ?>"  readonly>
                                                        </td>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <div class="">
                                            <table class="table table-bordered quarterSelectTable" id="saleTable">
                                                <thead class="bg-primary text-center">
                                                    <th width="10%"><?php echo e(__('Exchange Product')); ?></th>
                                                    <th width="10%"><?php echo e(__('Stock Qty')); ?></th>
                                                    <th width="10%" style="width: 8%;"><?php echo e(__('Price')); ?></th>
                                                    <th width="10%" style="width: 5%;"><?php echo e(__('Exchange Qty')); ?></th>

                                                    <th width="10%"><?php echo e(__('Action')); ?></th>
                                                </thead>
                                                <tbody>
                                                <tr class="text-center">
                                                    <td width="20%">
                                                        <select class="form-control selectpicker showroomProductDetails"
                                                                data-product_id="new_sale_1_product_id" data-product_code="new_sale_1_product_code" data-price="new_sale_1_price" data-price="new_sale_1_price" data-stock_qty="new_sale_1_stock_qty"
                                                                name="new_sale[1][sp_product_id]" data-charge_amount="new_sale_1_charge_amount" data-live-search="true">
                                                            <option value="" selected>Select Product</option>
                                                            <?php if(!$warehouse_product->isEmpty()): ?>
                                                                <?php $__currentLoopData = $warehouse_product; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $wp_product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <option value="<?php echo e($wp_product->product_code); ?>">
                                                                        <?php echo e($wp_product->product ? (\Str::slug($wp_product->product->product_name)) : ''); ?>

                                                                        <?php if($wp_product->product_variant): ?>
                                                                            - (<?php echo e($wp_product->product_variant->product_variant_name); ?>)
                                                                        <?php endif; ?>
                                                                        - (<?php echo e($wp_product->product_code); ?>)- <?php echo e($wp_product->product ? $wp_product->product->sku : ''); ?>

                                                                    </option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            <?php endif; ?>
                                                        </select>
                                                        <input type="hidden" class="form-control" id="new_sale_1_product_id" name="new_sale[1][product_id]" readonly/>
                                                        <input type="hidden" class="form-control" id="new_sale_1_product_code" name="new_sale[1][product_code]" readonly/>
                                                    </td>

                                                    <td><input type="text" class="form-control bg-primary text-white" id="new_sale_1_stock_qty" name="new_sale[1][stock_qty]" readonly/></td>
                                                    <td><input type="number" class="form-control price" id="new_sale_1_price" name="new_sale[1][price]"/></td>
                                                    <td>
                                                        <input type="number" class="form-control exchange_qty" id="new_sale_1_exchange_qty" name="new_sale[1][exchange_qty]"/>
                                                    </td>

                                                    <td>
                                                        <button type="button" class="btn btn-primary btn-sm addRaw"><i class="fas fa-plus-circle"></i></button>
                                                    </td>
                                                </tr>
                                                </tbody>
                                                <tfoot>
                                                    <tr>
                                                        <td colspan="4" style="color: #000 !important;border: none;" class="text-right font-weight-bolder">Total</td>
                                                        <td class="text-right font-weight-bolder"  colspan="2">
                                                            <input class="form-control total_exchange_price" type="text" name="total_price" value="" id="total_exchange_price" readonly>
                                                            <input  class="form-control item" type="hidden" name="item" value="" id="item" readonly>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td colspan="4" style="color: #000 !important;border: none;"
                                                            class="text-right font-weight-bolder">Exchange Product Amount</td>
                                                        <td class="text-right font-weight-bolder"  colspan="2">
    
                                                            <input type="number" class="form-control old_total_price prv_value" id="old_total_price" readonly/>
                                                            <input type="hidden" class="form-control total_qty " id="total_qty" name="total_qty"/>
                                                        </td>
                                                    </tr>

                                                    <tr>
                                                        <td colspan="4" style="color: #000 !important;border: none;"
                                                            class="text-right font-weight-bolder">Net Total</td>
                                                        <td class="text-right font-weight-bolder"  colspan="2">
                                                            <input class="form-control sub_total" type="text" name="net_total" value="" id="total_sum_value" readonly>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td colspan="4" style="color: #000 !important;border: none;"
                                                            class="text-right font-weight-bolder">Delivery Charge</td>
                                                        <td class="text-right font-weight-bolder"  colspan="2">
                                                            <input class="form-control shipping_cost" type="text" name="shipping_cost" value="" id="shipping_cost" >
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td colspan="4" style="color: #000 !important;border: none;"
                                                            class="text-right font-weight-bolder">Grand Total</td>
                                                        <td class="text-right font-weight-bolder"  colspan="2">
                                                            <input class="form-control grand_total" type="text" name="grand_total" value="" id="grand_total" readonly>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td colspan="4" style="color: #000 !important;border: none;"
                                                            class="text-right font-weight-bolder">Paid Amount:
                                                        </td>
                                                        <td colspan="2">
                                                            <input type="text" class="form-control text-right bg-secondary paid_amount" name="paid_amount" id="paid_amount" value="0"
                                                                   placeholder="0.00">
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td colspan="4" style="color: #000 !important;border: none;"
                                                            class="text-right font-weight-bolder">Due Amount:
                                                        </td>
                                                        <td colspan="2">
                                                            <input type="text" class="form-control text-right bg-secondary due_amount" name="due_amount" id="due_amount" value="0"
                                                                   placeholder="0.00" readonly>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td colspan="4" style="color: #000 !important;border: none;"
                                                            class="text-right font-weight-bolder">Payment Status:
                                                        </td>
                                                        <td colspan="2">
                                                            <select class="form-control selectpicker" data-live-search="true" name="payment_status" id="payment_status"
                                                                    data-live-search-placeholder="Search">
                                                                <option value="">Select Please</option>
                                                                <?php $__currentLoopData = PAYMENT_STATUS; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <option value="<?php echo e($key); ?>"
                                                                            <?php if($key  == $sale->payment_status ): ?> selected <?php endif; ?> ><?php echo e($value); ?></option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>
                                                        </td>

                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="row col-md-12 pt-15 d-none" id="payment_method">
                                        <div class="row col-md-12"
                                             id="payment_method_tr_0">
                                            <div class="form-group col-md-3">
                                                <label>Payment Method</label>
                                                <select class="form-control selectpicker" name="payment[0][payment_method]" onchange="account_list(this.value,0)"
                                                        id="payment_0_payment_method" data-live-search="true" data-live-search-placeholder="Search">
                                                    <option value="">Select Please</option>
                                                    <?php $__currentLoopData = SALE_PAYMENT_METHOD; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($key); ?>" data-reference_id="0"><?php echo e($value); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>

                                            <div class="form-group col-md-3">
                                                <label>Account</label>
                                                <select class="form-control selectpicker" name="payment[0][account_id]" id="payment_0_account_id" data-live-search="true"
                                                        data-live-search-placeholder="Search">
                                                    <option value="">Select Please</option>
                                                </select>
                                            </div>

                                            <div class="form-group col-md-3 d-none  reference_no_0">
                                                <label for="reference_no">Reference No</label>
                                                <input type="text" class="fcs form-control" name="payment[0][reference_no]" id="payment_0_reference_no">
                                            </div>

                                            <div class="form-group col-md-2">
                                                <label for="reference_no">Amount</label>
                                                <input type="number" class="fcs form-control payment_amounts" oninput="calculatePaymentAmount(this.value)"
                                                       name="payment[0][payment_amount]" id="payment_0_payment_amount">
                                            </div>

                                            <div
                                                class=" d-flex flex-column justify-content-center align-items-center">
                                                <button type="button" class="btn btn-success btn-sm" onclick="addTableRow('payment_method',0)">
                                                    <i class="fas fa-plus"></i>
                                                </button>
                                            </div>

                                        </div>

                                    </div>
                                </div>

                                <div class="form-group col-md-12 text-center pt-5">
                                    <a class="btn btn-danger btn-sm mr-3" href="<?php echo e(route('sale.add')); ?>"><i class="fas fa-sync-alt"></i><?php echo e(__('Reset')); ?></a>
                                    <button type="button" class="btn btn-primary btn-sm mr-3" id="save-btn" onclick="storeData()"><i class="fas fa-save"></i><?php echo e(__('Save')); ?></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('js/jquery-ui.js')); ?>"></script>
    <script src="<?php echo e(asset('js/bootstrap-datetimepicker.min.js')); ?>"></script>
    <script>
        let i = 2;
        var item = [];
        var total_exchange_price = [];
        var total_qty = [];
        var sub_total = [];
        var paid_amount = [];
        var due_amount = [];


        function _(x) {
            return document.getElementById(x);
        }

        $(document).on('click', '.oldProductAddRaw', function () {
            let html;
            html = `<tr>
                 <td width="20%">
                     <select class="form-control productDetails selectpicker" id="old_sale_` + i + `_old_product_id" data-product_id="old_sale_` + i + `_product_id" data-product_code="old_sale_` + i + `_product_code" data-warehouse="sale1_` + i + `_warehouse_id" data-unit_name = "old_sale_` + i + `_unit_name" data-price = "old_sale_` + i + `_price" data-stock_qty = "old_sale_` + i + `_stock_qty"  name="old_sale[` + i + `][old_product_id]" data-live-search="true">
                        <option value="" selected>Select Product</option>
                           <?php if(!$sale->sale_products->isEmpty()): ?>
                                <?php $__currentLoopData = $sale->saleProductList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $sale_product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($sale_product->id); ?>"><?php echo e(!empty($sale_product->variant_id) ? (\Str::slug($sale_product->product->product_name)) . ' - ' . $sale_product->product->sku.'. - ('.$sale_product->productVariant->product_variant_name.')' : $sale_product->product->product_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                           <?php endif; ?>
                        </select>
                        <input type="hidden" class="form-control" id="old_sale_` + i + `_product_id" name="old_sale[` + i + `][old_product_id]" readonly/>
                 </td>
                  <td><input type="text" class="form-control bg-primary text-white" id="old_sale_` + i + `_product_code" name="old_sale[` + i + `][old_product_code]" readonly/></td>
                  <td><input type="text" class="form-control bg-primary text-white" id="old_sale_` + i + `_stock_qty" name="old_sale[` + i + `][old_stock_qty]" readonly/></td>
                   <td><input type="number" class="form-control price" id="old_sale_` + i + `_price" data-qty = "old_sale_` + i + `_qty" data-sub_total = "old_sale_` + i + `_sub_total" name="old_sale[` + i + `][old_price]"/></td>
                     <td><input type="number" class="form-control old_exchange_qty " id="old_sale_` + i + `_old_exchange_qty" name="old_sale[` + i + `][old_exchange_qty]"/>

                     </td>
                 <td class = "text-center"><button type = "button" class = "btn btn-danger btn-sm oldDeleteRaw"><i class = "fas fa-minus-circle"></i></button></td>
               </tr>`;
            $('#oldSaleTable tbody').append(html);
            $('.selectpicker').selectpicker('refresh');
            i++;
        });
        $(document).on('click', '.oldDeleteRaw', function () {
            $(this).parent().parent().remove();
            calculateTotal();
            $('.selectpicker').selectpicker('refresh');
        });

        $(document).on('click', '.addRaw', function () {
            let html;
            html = `<tr>
                   <td width="20%">
                     <select class="form-control selectpicker showroomProductDetails" id="new_sale_` + i + `_sp_product_id" data-product_id = "new_sale_` + i + `_product_id" data-product_code = "new_sale_` + i + `_product_code" data-price = "new_sale_` + i + `_price" data-stock_qty = "new_sale_` + i + `_stock_qty" name="new_sale[` + i + `][product_id]" data-live-search="true">
                        <option value="" selected>Select Product</option>
                            <?php if(!$warehouse_product->isEmpty()): ?>
                                <?php $__currentLoopData = $warehouse_product; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $wp_product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($wp_product->product_code); ?>"><?php echo e($wp_product->product ? (\Str::slug($wp_product->product->product_name)) : ''); ?>

                                <?php if($wp_product->product_variant): ?>
                                - (<?php echo e($wp_product->product_variant->product_variant_name); ?>)
                                                    <?php endif; ?>
                                - (<?php echo e($wp_product->product_code); ?>)
                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                           <?php endif; ?>
                     </select>
                    <input type="hidden" class="form-control" id="new_sale_` + i + `_product_id" name="new_sale[` + i + `][product_id]" readonly/>
                    <input type="hidden" class="form-control" id="new_sale_` + i + `_product_code" name="new_sale[` + i + `][product_code]" readonly/>
                  </td>
                <td><input type="text" class="form-control bg-primary text-white" id="new_sale_` + i + `_stock_qty" name="new_sale[` + i + `][stock_qty]" readonly/></td>
                 <td><input type="number" class="form-control price" id="new_sale_` + i + `_price" data-qty = "new_sale_` + i + `_qty" data-sub_total = "new_sale_` + i + `_sub_total" name="new_sale[` + i + `][price]"/></td>
                 <td><input type="number" class="form-control exchange_qty" id="new_sale_` + i + `_exchange_qty"  name="new_sale[` + i + `][exchange_qty]"/></td>
                 <td class = "text-center"><button type = "button" class = "btn btn-danger btn-sm deleteRaw"><i class = "fas fa-minus-circle"></i></button></td>
               </tr>`;
            $('#saleTable tbody').append(html);
            $('.selectpicker').selectpicker('refresh');
            i++;
        });

        $(document).on('click', '.deleteRaw', function (){
            $(this).parent().parent().remove();
            calculateTotal();
            $('.selectpicker').selectpicker('refresh');
        });

        $('#saleTable').on('click', '.deleteRaw', function () {
            rowindex = $(this).closest('tr').index();
            item.splice(rowindex, 1);
            $(this).closest('tr').remove();
            calculateTotal();
            notification('success', ' Removed Successfully');
        });


        $(document).on('change', '.productDetails', function () {
            let productId = $(this).find('option:selected').val();
            let warehouseId = $('#' + $(this).data('warehouse') + '').find('option:selected').val();
            let product_id = $(this).data('product_id');
            let product_code = $(this).data('product_code');
            let sale_type   = $(this).data('sale_type');
            let price = $(this).data('price');
            let stockQty = $(this).data('stock_qty');
            if (product_code != '') {
                $.ajax({
                    url: "<?php echo e(url('exchange-product-wise-details')); ?>/" + productId,
                    type: "GET",
                    sale_type: sale_type,
                    success: function (data) {
                        if (data != '') {
                            // console.log(data.price);
                            // _(unitName).value    = data.baseUnit;
                            _(product_id).value = data.product_id;
                            _(price).value = data.price;
                            _(stockQty).value = data.stockQty;
                            _(product_code).value = data.product_code;
                        }
                    }
                });
            }
        });

        $(document).on('change', '.showroomProductDetails', function () {
            parseFloat($('#shipping_cost').val(0))
            let productId = $(this).find('option:selected').val();
            let warehouseId = $('#' + $(this).data('warehouse') + '').find('option:selected').val();
            let productCode = $('#' + $(this).data('product_code') + '').find('option:selected').val();
            let product_id = $(this).data('product_id');
            let product_code = $(this).data('product_code');
            let price = $(this).data('price');
            let charge_amount = $(this).data('charge_amount');
            let stockQty = $(this).data('stock_qty');
            if (productId != '') {
                $.ajax({
                    url: "<?php echo e(url('showroom-product-wise-details')); ?>/" + productId,
                    type: "GET",
                    success: function (data) {
                        if (data != '') {
                            // _(unitName).value    = data.baseUnit;
                            _(product_id).value = data.product_id;
                            _(price).value = data.price;
                            _(stockQty).value = data.stockQty;
                            _(product_code).value = data.product_code;
                            _(charge_amount).value = data.price;
                        }
                    }
                });
            }
        });

        function account_list(payment_method, idx, account_idx = null) {
            $.ajax({
                url: "<?php echo e(route('account.list')); ?>",
                type: "POST",
                data: {
                    payment_method: payment_method,
                    account_id: account_idx,
                    _token: _token
                },
                success: function (data) {
                    // console.log(data, idx, payment_method);

                    $('#sale_store_form #payment_' + idx + '_account_id').empty().html(data);
                    $('#sale_store_form #payment_' + idx + '_account_id').selectpicker('refresh');

                    if (payment_method != 1) {

                        $(`.reference_no_${idx}`).removeClass('d-none').addClass('pt-1'); // You can change 'pt-4' to your desired padding class
                    } else {

                        $(`.reference_no_${idx}`).addClass('d-none');
                    }


                },
                error: function (xhr, ajaxOption, thrownError) {
                    console.log(thrownError + '\r\n' + xhr.statusText + '\r\n' + xhr.responseText);
                }
            });
        }

        $(document).ready(function () {
            $("#oldSaleTable").on('input', '.old_exchange_qty, .price', function () {
                var calculated_total_sum = 0;
                var dd = 0;
                var total_qty = 0;

                $("#oldSaleTable tr").each(function () {
                    var quantity = parseFloat($(this).find('.old_exchange_qty').val());
                    console.log(quantity);
                    var old_price = parseFloat($(this).find('.price').val());

                    if ($.isNumeric(quantity) && $.isNumeric(old_price)) {
                        calculated_total_sum += quantity * old_price;
                        dd = calculated_total_sum;
                        total_qty += quantity ;
                    }
                });

                $("#old_total_price").val(calculated_total_sum);
                $("#exchange_qty").val(total_qty);
                calculateTotal();
            });
        });

        $(document).ready(function () {
            $("#saleTable").on('input', '.exchange_qty, .price', function () {
                var calculated_total_sum = 0;
                var total_price = 0;
                var total_qty = 0;

                // Calculate calculated_total_sum
                $("#saleTable tr").each(function () {
                    var quantity = parseFloat($(this).find('.exchange_qty').val());
                    var old_price = parseFloat($(this).find('.price').val());
                    if ($.isNumeric(quantity) && $.isNumeric(old_price)) {
                        calculated_total_sum += quantity * old_price;
                        total_qty += quantity ;
                        total_price = calculated_total_sum ;
                    }

                });
                $("#total_exchange_price").val(calculated_total_sum);
                $("#total_qty").val(total_qty);
                calculateTotal();
            });



            $('#payment_status').on('change', function () {

                if ($(this).val() != 3) {
                    $('#payment_method *').prop('disabled', false);
                    $(`#payment_method`).removeClass('d-none');
                } else {
                    $('#payment_method *').prop('disabled', true);
                    $(`#payment_method`).addClass('d-none');
                }
            });

            $('#payment_status').trigger('change');

            $('#payment_method').on('change', function () {
                if ($(this).val() != 1) {
                    $('.reference_no').removeClass('d-none');
                } else {
                    $('.reference_no').addClass('d-none');
                }
            });
        });


        let table_row = 0;

        function removeRow(element, idx) {
            $('#' + element + idx).closest('div').remove();
            table_row--;
            calculateTotal();
        }


        function addTableRow(tableId, idx) {

            table_row = idx;
            ++table_row;

// Assuming PAYMENT_STATUS is a JavaScript array or object
            let paymentOptions = [
                    <?php $__currentLoopData = SALE_PAYMENT_METHOD; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                {
                    key: '<?php echo e($key); ?>', value: '<?php echo e($value); ?>'
                },
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            ];

            let selectOptions = '';
            paymentOptions.forEach(option => {
                selectOptions += `<option value="${option.key}" data-reference_id="${table_row}" >${option.value}</option>`;
            });

            let html = `
            <div class="row col-md-12" id="payment_method_tr_${table_row}">
                <div class="form-group col-md-3">
                    <label>Payment Method</label>
                    <select class="form-control selectpicker" data-live-search="true" name="payment[${table_row}][payment_method]" id="payment_${table_row}_payment_method" onchange="account_list(this.value,${table_row})" data-reference_id="${table_row}" data-live-search-placeholder="Search">
                       <option value="">Select Please</option>
                        ${selectOptions}
                    </select>
                </div>
                <div class="form-group col-md-3">
                    <label>Account</label>
                   <select class="form-control  selectpicker" id="payment_${table_row}_account_id" data-live-search="true" name="payment[${table_row}][account_id]" data-live-search-placeholder="Search">
                       <option value="">Select Please</option>
                   </select>
                </div>
                <div class="form-group col-md-3  d-none reference_no_${table_row}"
                <label for="reference_no">Reference No</label>
                <input type="text" class="fcs form-control" name="payment[${table_row}][reference_no]" id="payment_${table_row}_reference_no">
            </div>
           <div class="form-group col-md-2 ">
               <label for="payment_amount">Amount</label>
               <input type="number" class="fcs form-control payment_amounts" oninput="calculatePaymentAmount(this.value)" name="payment[${table_row}][payment_amount]" id="payment_${table_row}_payment_amount">
           </div>

            <div class="mb-2 d-flex flex-column justify-content-center align-items-center">
                <button type="button" class="btn btn-danger btn-sm" onclick="removeRow('payment_method_tr_','${table_row}')"><i class="fas fa-minus"></i></button>
                <button type="button" class="btn btn-success btn-sm" onclick="addTableRow('payment_method','${table_row}')"><i class="fas fa-plus"></i></button>
            </div>
        </div>
`;

// Append the new row to the table or container with the specified ID
            $('#' + tableId).append(html);

// Refresh the selectpicker to apply Bootstrap-select styling
            $('#' + tableId + ' .selectpicker').selectpicker('refresh');
        }


        function setReturnValue(row)
        {
            $('#old_sale_'+row+'_return_checkbox').is(':checked') ? $('#old_sale_return_'+row).val(1) : $('#old_sale_return_'+row).val(2);
        }
        $('.payment_amounts').on('input', function (){
            var value = $(this).val();
            if ((value !== '') && (value.indexOf('.') === -1)) {
                let payable_amount = parseFloat($('#total_price').val());
                let paid_amount = $('#paid_amount').val() ? parseFloat($('#paid_amount').val()) : 0;
                let ongoing = (payable_amount - paid_amount).toFixed(2);
                if (value > payable_amount) {
                    notification('error', 'The Payment Can not grater than payable amount');
                }

            }
        });

        function calculatePaymentAmount(value) {
            // return;
            let totals = 0;
            $(".payment_amounts").each(function () {
                var inputValue = $(this).val() > 0 ? $(this).val() : 0;
                if (!isNaN(inputValue)) {
                    totals += parseFloat(inputValue);
                }
            });

            if (!isNaN(totals)) {
                let payable_amount = parseFloat($('#total_sum_value').val());
                let dues = (payable_amount - totals).toFixed(2);
                if (dues >= 0) {
                    $('#paid_amount').val(totals);
                    $('#due_amount').val(dues);

                }

            }
        }

        function calculateTotal() {
            var item = $('#saleTable tbody tr:last').index();
            let prv_value = $("#old_total_price").val() ? parseFloat($('#old_total_price').val()) : 0;
            let sum_value = $("#total_exchange_price").val() ? parseFloat($('#total_exchange_price').val()) : 0;
            var subtotal = parseFloat($('#total_sum_value').text());

            var calculated_total_sum = 0;
            var dd = 0;
            item = ++item

            $("#saleTable .sub_total").each(function () {
                var get_textbox_value = $(this).val();
                if ($.isNumeric(get_textbox_value)) {
                    calculated_total_sum += parseFloat(get_textbox_value);
                    if(prv_value > sum_value){
                        dd = 0;
                    }else {
                        dd = parseFloat(sum_value) - parseFloat(prv_value)
                    }
                }
            });
            // Set the value of the input field
            $("#total_sum_value").val(dd);
            $('#grand_total').val(dd);
            $('#item').text(item);
            $('input[name="item"]').val($('#saleTable tbody tr:last').index() + 1);

            var paid_amount = $('#paid_amount').val() ? parseFloat($('#paid_amount').val()) : 0;

            let due_ongoing = (dd - paid_amount).toFixed(2);
            if (paid_amount > dd) {
                $('input[name="due_amount"]').val(due_ongoing);
            } else {
                $('input[name="due_amount"]').val(due_ongoing);
            }
        }

        function storeData() {
            let form = document.getElementById('sale_store_form');
            let formData = new FormData(form);
            let url = "<?php echo e(route('exchange.store')); ?>";
            $.ajax({
                url: url,
                type: "POST",
                data: formData,
                dataType: "JSON",
                contentType: false,
                processData: false,
                cache: false,
                beforeSend: function () {
                    $('#save-btn').addClass('spinner spinner-white spinner-right');
                },
                complete: function () {
                    $('#save-btn').removeClass('spinner spinner-white spinner-right');
                },
                success: function (data) {
                    $('#sale_store_form').find('.is-invalid').removeClass('is-invalid');
                    $('#sale_store_form').find('.error').remove();
                    if (data.status == false) {
                        $.each(data.errors, function (key, value) {
                            var key = key.split('.').join('_');
                            $('#sale_store_form input#' + key).addClass('is-invalid');
                            $('#sale_store_form textarea#' + key).addClass('is-invalid');
                            $('#sale_store_form select#' + key).parent().addClass('is-invalid');
                            $('#sale_store_form #' + key).parent().append('<small class="error text-danger">' + value + '</small>');
                        });
                    } else {
                        notification(data.status, data.message);
                        if (data.status == 'success') {
                            window.location.replace("<?php echo e(route('exchange_list')); ?>");
                        }
                    }
                },
                error: function (xhr, ajaxOption, thrownError) {
                    console.log(thrownError + '\r\n' + xhr.statusText + '\r\n' + xhr.responseText);
                }
            });
        }

    </script>
    <script>
        $(document).ready(function () {
            function updateFinalTotal() {

                var subTotal = parseFloat($('#total_sum_value').val()) || 0;
                var grandTotal = parseFloat($('#grand_total').val()) || 0;
                var deliveryCharge = parseFloat($('#shipping_cost').val()) || 0;
                var finalTotal = subTotal + deliveryCharge;
                var dueTotal = subTotal + deliveryCharge;

                $('#grand_total').val(finalTotal);
                $('#due_amount').val(dueTotal);
            }

            // Call the updateFinalTotal function whenever the input values change
            $('#shipping_cost').on('input', function () {
                updateFinalTotal();
            });

            // Increment or decrement grand_total when shipping_cost changes
            $('#shipping_cost_increment').on('click', function () {
                var shippingCost = parseFloat($('#shipping_cost').val()) || 0;
                $('#shipping_cost').val(shippingCost + 1);
                updateFinalTotal();
            });

            $('#shipping_cost_decrement').on('click', function () {
                var shippingCost = parseFloat($('#shipping_cost').val()) || 0;
                if (shippingCost > 0) {
                    $('#shipping_cost').val(shippingCost - 1);
                    updateFinalTotal();
                }
            });

            // Initial update
            updateFinalTotal();
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iconshoppercom/iconshopper/Modules/Exchange/Resources/views/sale/exchange.blade.php ENDPATH**/ ?>