
<?php $__env->startSection('title', $page_title); ?>
<?php $__env->startSection('content'); ?>
    <div class="d-flex flex-column-fluid">
        <div class="container-fluid">
            <div class="card card-custom gutter-b">
                <div class="card-header flex-wrap py-5">
                    <div class="card-title">
                        <h3 class="card-label"><i class="<?php echo e($page_icon); ?> text-primary"></i> <?php echo e($sub_title); ?></h3>
                    </div>
                    <div class="card-toolbar">
                        <button type="button" class="btn btn-primary btn-sm mr-3" id="print-invoice"><i
                                class="fas fa-print"></i><?php echo e('Print'); ?></button>
                        <a href="<?php echo e(route('stock.transfer')); ?>" class="btn btn-warning btn-sm font-weight-bolder"><i
                                class="fas fa-arrow-left"></i> <?php echo e('Back'); ?></a>
                    </div>
                </div>
            </div>
            <div class="card card-custom" style="padding-bottom: 100px !important;">
                <div class="card-body" style="padding-bottom: 100px !important;">
                    <div class="col-md-12 col-lg-12" style="width: 100%;">
                        <div id="invoice">
                            <style>
                                body,
                                html {
                                    background: #fff !important;
                                    -webkit-print-color-adjust: exact !important;
                                }

                                .invoice {
                                    background: #fff !important;
                                }

                                .invoice header {
                                    padding: 10px 0;
                                    margin-bottom: 20px;
                                    border-bottom: 1px solid #036;
                                }

                                .invoice .company-details {
                                    text-align: right
                                }

                                .invoice .company-details .name {
                                    margin-top: 0;
                                    margin-bottom: 0;
                                }

                                .invoice .contacts {
                                    margin-bottom: 20px;
                                }

                                .invoice .invoice-to {
                                    text-align: left;
                                }

                                .invoice .invoice-to .to {
                                    margin-top: 0;
                                    margin-bottom: 0;
                                }

                                .invoice .invoice-details {
                                    text-align: right;
                                }

                                .invoice .invoice-details .invoice-id {
                                    margin-top: 0;
                                    color: #036;
                                }

                                .invoice main {
                                    padding-bottom: 50px
                                }

                                .invoice main .thanks {
                                    margin-top: -100px;
                                    font-size: 2em;
                                    margin-bottom: 50px;
                                }

                                .invoice main .notices {
                                    padding-left: 6px;
                                    border-left: 6px solid #036;
                                }

                                .invoice table {
                                    width: 100%;
                                    border-collapse: collapse;
                                    border-spacing: 0;
                                    margin-bottom: 20px;
                                }

                                .invoice table th {
                                    background: white;
                                    color: black;
                                    padding: 15px;
                                    border: 2px solid black;
                                }

                                .invoice table td {
                                    padding: 15px;
                                    border-bottom: 1px solid #fff
                                }

                                .invoice table th {
                                    white-space: nowrap;
                                }

                                .invoice table td h3 {
                                    margin: 0;
                                    color: #036;
                                }

                                .invoice table .qty {
                                    text-align: center;
                                }

                                .invoice table .price,
                                .invoice table .discount,
                                .invoice table .tax,
                                .invoice table .total {
                                    text-align: right;
                                }

                                .invoice table .no {
                                    color: black;
                                    background: white;
                                    border: 2px solid black !important;
                                }

                                .invoice table .total {
                                    background: white;
                                    color: black;
                                    border: 2px solid black !important;
                                }

                                .invoice table tbody tr:last-child td {
                                    border: none
                                }

                                .invoice table tfoot td {
                                    background: 0 0;
                                    border-bottom: none;
                                    white-space: nowrap;
                                    text-align: right;
                                    padding: 10px 20px;
                                    border-top: 1px solid #aaa;
                                    font-weight: bold;
                                }

                                .invoice table tfoot tr:first-child td {
                                    border-top: none
                                }

                                /* .invoice table tfoot tr:last-child td {
                                                color: #036;
                                                border-top: 1px solid #036
                                            } */
                                .invoice table tfoot tr td:first-child {
                                    border: none
                                }

                                .invoice footer {
                                    width: 100%;
                                    text-align: center;
                                    color: #777;
                                    border-top: 1px solid #aaa;
                                    padding: 8px 0
                                }

                                .invoice a {
                                    content: none !important;
                                    text-decoration: none !important;
                                    color: #036 !important;
                                }

                                .page-header,
                                .page-header-space {
                                    height: 100px;
                                }

                                .page-footer,
                                .page-footer-space {
                                    height: 20px;

                                }

                                .page-footer {
                                    position: fixed;
                                    bottom: 0;
                                    width: 100%;
                                    text-align: center;
                                    color: #777;
                                    border-top: 1px solid #aaa;
                                    padding: 8px 0
                                }

                                .page-header {
                                    position: fixed;
                                    top: 0mm;
                                    width: 100%;
                                    border-bottom: 1px solid black;
                                }

                                .page {
                                    page-break-after: always;
                                }

                                .dashed-border {
                                    width: 180px;
                                    height: 2px;
                                    margin: 0 auto;
                                    padding: 0;
                                    border-top: 1px dashed #454d55 !important;
                                }

                                @media  screen {
                                    .no_screen {
                                        display: none;
                                    }

                                    .no_print {
                                        display: block;
                                    }

                                    thead {
                                        display: table-header-group;
                                    }

                                    tfoot {
                                        display: table-footer-group;
                                    }

                                    button {
                                        display: none;
                                    }

                                    body {
                                        margin: 0;
                                    }
                                }

                                @media  print {

                                    body,
                                    html {
                                        -webkit-print-color-adjust: exact !important;
                                        font-family: sans-serif;
                                        /*margin-bottom: 100px !important;*/
                                    }

                                    .m-0 {
                                        margin: 0 !important;
                                    }

                                    h1,
                                    h2,
                                    h3,
                                    h4,
                                    h5,
                                    h6 {
                                        margin: 0 !important;
                                    }

                                    .no_screen {
                                        display: block !important;
                                    }

                                    .no_print {
                                        display: none;
                                    }

                                    a {
                                        content: none !important;
                                        text-decoration: none !important;
                                        color: #036 !important;
                                    }

                                    .text-center {
                                        text-align: center !important;
                                    }

                                    .text-left {
                                        text-align: left !important;
                                    }

                                    .text-right {
                                        text-align: right !important;
                                    }

                                    .float-left {
                                        float: left !important;
                                    }

                                    .float-right {
                                        float: right !important;
                                    }

                                    .text-bold {
                                        font-weight: bold !important;
                                    }

                                    .invoice {
                                        /* font-size: 11px!important; */
                                        overflow: hidden !important;
                                        background: #fff !important;
                                        margin-bottom: 100px !important;
                                    }

                                    .invoice footer {
                                        position: absolute;
                                        bottom: 0;
                                        left: 0;
                                    }

                                    .hidden-print {
                                        display: none !important;
                                    }

                                    .dashed-border {
                                        width: 180px;
                                        height: 2px;
                                        margin: 0 auto;
                                        padding: 0;
                                        border-top: 1px dashed #454d55 !important;
                                    }
                                }

                                @page  {
                                    margin: 5mm 5mm;
                                }
                            </style>
                            <div class="invoice overflow-auto">
                                <div>
                                    <table>
                                        <tr>
                                            <td width="20%"><img
                                                    src="<?php echo e(asset('storage/' . LOGO_PATH . config('settings.logo'))); ?>"
                                                    style="max-width: 200px;max-height:100px;" alt="Logo"/></td>
                                            <td width="80%" class="text-right">
                                                <h2 class="name m-0" style="text-transform: uppercase;">
                                                    <b><?php echo e(config('settings.title') ? config('settings.title') : env('APP_NAME')); ?></b>
                                                </h2>
                                                <?php if(config('settings.contact_no')): ?>
                                                    <p style="font-weight: normal;margin:0;"><b><?php echo e('Contact No'); ?>.:
                                                        </b><?php echo e(config('settings.contact_no')); ?>, <?php if(config('settings.email')): ?>
                                                            <b><?php echo e('Email'); ?>: </b><?php echo e(config('settings.email')); ?>

                                                        <?php endif; ?>
                                                    </p>
                                                <?php endif; ?>
                                                <p style="font-weight: normal;margin:0;"><b><?php echo e('Date'); ?>:
                                                    </b><?php echo e(date('d-M-Y')); ?></p>
                                            </td>
                                        </tr>
                                    </table>
                                    <div
                                        style="width: 100%;height:3px;border-top:1px solid #036;border-bottom:1px solid #036;">
                                    </div>
                                    <br/>
                                    <table class="invoice">
                                        <thead>
                                        <tr class="text-center">
                                            <th><?php echo e('Transfer Date'); ?></th>
                                            <th><?php echo e('Invoice No'); ?></th>
                                            <th><?php echo e('Transfer Showroom'); ?></th>
                                            <th><?php echo e('Receive Warehouse/ Showroom'); ?></th>
                                            <th><?php echo e('Total Quantity'); ?></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr class="text-center">
                                            <td class="no">
                                                <button
                                                    class="btn btn-primary btn-block"><?php echo e($details->transfer_date); ?></button>
                                            </td>
                                            <td><?php echo e($details->invoice_no); ?></td>
                                            <td><?php echo e($details->transferShowroom->name); ?></td>
                                            <td><?php echo e($details->receiveWarehouse->name ?? $details->receiveShowroom->name); ?></td>
                                            <td class="no">
                                                <button
                                                    class="btn btn-primary btn-block"><?php echo e($details->total_qty); ?></button>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                    <div
                                        style="width: 100%;height:3px;border-top:1px solid #036;border-bottom:1px solid #036;">
                                    </div>
                                    <br/>
                                    <?php if(isset($details) && !$details->stockTransferProductList->isEmpty()): ?>
                                        <table class="invoice">
                                            <thead>
                                            <tr class="text-center">
                                                <th><?php echo e('Product Name'); ?></th>
                                                <th><?php echo e('Product Code'); ?></th>
                                                <th><?php echo e('SKU'); ?></th>
                                                <th><?php echo e('Quantity'); ?></th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php $__currentLoopData = $details->stockTransferProductList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    $variationName = '';
                                                    if ($value->type == 1) {
                                                        $variationData = \Illuminate\Support\Facades\DB::table('product_variants')
                                                            ->where('product_code', $value->product_code)
                                                            ->first('product_variant_name');
                                                        $variationName = '-' . $variationData->product_variant_name;
                                                    }
                                                ?>
                                                <tr class="text-center">
                                                    <td class="no">
                                                        <?php echo e($value->product->product_name . '' . $variationName); ?></td>
                                                    <td class="no"><?php echo e($value->product_code); ?></td>
                                                    <td class="no"><?php echo e($value->product->sku); ?></td>
                                                    <td class="no"><?php echo e($value->qty); ?></td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    <?php endif; ?>
                                    <div
                                        style="width: 100%;height:3px;border-top:1px solid #036;border-bottom:1px solid #036;">
                                    </div>
                                    <table class="invoice">
                                        <tbody>
                                        <tr class="text-center">
                                            <td></td>
                                            <td class="text-right">
                                                <div class="font-size-10 float-right">
                                                    <p style="margin:0;padding:0;">
                                                        <?php echo e($details->createdBy->username); ?><br>
                                                        <?php echo e(date('d-M-Y h:i:s A', strtotime($details->transfer_date))); ?>

                                                    </p>
                                                    <p class="dashed-border"></p>
                                                    <p
                                                        style="margin:0;padding:0;text-transform: capitalize;font-weight:normal;">
                                                        Created By</p>
                                                </div>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('js/jquery.printarea.js')); ?>"></script>
    <script>
        $(document).ready(function () {
            $(document).on('click', '#print-invoice', function () {
                var mode = 'iframe'; // popup
                var close = mode == "popup";
                var options = {
                    mode: mode,
                    popClose: close
                };
                $("#invoice").printArea(options);
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iconshoppercom/iconshopper/Modules/Stock/Resources/views/showroomStockTransfer/details.blade.php ENDPATH**/ ?>