
<?php $__env->startSection('title', $page_title); ?>
<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('css/jquery-ui.css')); ?>" />
    <link href="<?php echo e(asset('css/bootstrap-datetimepicker.min.css')); ?>" rel="stylesheet" type="text/css" />
    <style>
        .small-btn {
            width: 20px !important;
            height: 20px !important;
            padding: 0 !important;
        }

        .small-btn i {
            font-size: 10px !important;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <div class="d-flex flex-column-fluid">
        <div class="container-fluid">
            <div class="card card-custom gutter-b">
                <div class="card-header flex-wrap py-5">
                    <div class="card-title">
                        <h3 class="card-label"><i class="<?php echo e($page_icon); ?> text-primary"></i> <?php echo e($sub_title); ?></h3>
                    </div>
                    <?php if(permission('sale-access')): ?>
                        <div class="card-toolbar"><a href="<?php echo e(route('wholesale.exchange.list')); ?>"
                                class="btn btn-warning btn-sm font-weight-bolder"><i class="fas fa-arrow-left"></i>
                                <?php echo e(__('Back')); ?></a></div>
                    <?php endif; ?>
                </div>
            </div>
            <div class="card card-custom">
                <div class="card-body">
                    <div id="kt_datatable_wrapper" class="dataTables_wrapper dt-bootstrap4 no-footer">
                        <form action="" id="sale_store_form" method="post" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <div class="">
                                            <table class="table table-bordered quarterSelectTable" id="saleTable">
                                                <thead class="bg-primary text-center">
                                                    <th width="10%"><?php echo e(__('Carton')); ?></th>
                                                    <th width="10%"><?php echo e(__('Stock Qty')); ?></th>
                                                    <th width="10%" style="width: 8%;"><?php echo e(__('Price')); ?></th>
                                                    <th width="10%" style="width: 5%;"><?php echo e(__('Break Qty')); ?></th>
                                                    <th width="10%"><?php echo e(__('Action')); ?></th>
                                                </thead>
                                                <tbody>
                                                    <tr class="text-center">
                                                        <td width="20%">
                                                            <select
                                                                class="form-control selectpicker cartonProductDetails" data-product_id="new_sale_1_product_id" data-product_code="new_sale_1_product_code" data-price="new_sale_1_price" data-price="new_sale_1_price" data-stock_qty="new_sale_1_stock_qty" name="new_sale[1][sp_product_id]"  data-live-search="true">
                                                                <option value="" selected>Select Product</option>
                                                                    <?php $__currentLoopData = $carton_product; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $wp_product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <option value="<?php echo e($wp_product->barcode); ?>"><?php echo e($wp_product->barcode ? (\Str::slug($wp_product->name)) : ''); ?> - <?php echo e($wp_product->sku); ?> - <?php echo e($wp_product->barcode); ?></option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>
                                                            <input type="hidden" class="form-control"
                                                                id="new_sale_1_product_id" name="new_sale[1][product_id]"
                                                                readonly />
                                                            <input type="hidden" class="form-control"
                                                                id="new_sale_1_product_code"
                                                                name="new_sale[1][product_code]" readonly />
                                                        </td>

                                                        <td><input type="text"
                                                                class="form-control bg-primary text-white"
                                                                id="new_sale_1_stock_qty" name="new_sale[1][stock_qty]"
                                                                readonly /></td>
                                                        <td><input type="number" class="form-control price"
                                                                id="new_sale_1_price" name="new_sale[1][price]" /></td>
                                                        <td><input type="number" class="form-control break_qty"
                                                                id="new_sale_1_break_qty"
                                                                name="new_sale[1][break_qty]" /></td>
                                                        <td>
                                                            <button type="button"
                                                                class="btn btn-primary btn-sm addRaw"><i
                                                                    class="fas fa-plus-circle"></i></button>
                                                        </td>
                                                    </tr>
                                                </tbody>

                                            </table>
                                        </div>
                                    </div>
                                </div>


                                <div class="form-group col-md-12 text-center pt-5">
                                    <a class="btn btn-danger btn-sm mr-3" href="<?php echo e(route('sale.add')); ?>"><i
                                            class="fas fa-sync-alt"></i><?php echo e(__('Reset')); ?></a>
                                    <button type="button" class="btn btn-primary btn-sm mr-3" id="save-btn"
                                        onclick="storeData()"><i class="fas fa-save"></i><?php echo e(__('Save')); ?></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('js/jquery-ui.js')); ?>"></script>
    <script src="<?php echo e(asset('js/bootstrap-datetimepicker.min.js')); ?>"></script>
    <script>
        let i = 2;
        var item = [];

        function _(x) {
            return document.getElementById(x);
        }
        $(document).on('click', '.addRaw', function(){
            let html;
            html = `<tr>
                   <td width="20%">
                     <select class="form-control selectpicker cartonProductDetails" id="new_sale_` + i +
                `_sp_product_id" data-product_id = "new_sale_` + i + `_product_id" data-product_code = "new_sale_` +
                i + `_product_code" data-price = "new_sale_` + i + `_price" data-stock_qty = "new_sale_` + i + `_stock_qty" name="new_sale[` + i + `][product_id]" data-live-search="true">
                        <option value="" selected>Select Product</option>
                        <?php $__currentLoopData = $carton_product; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $wp_product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($wp_product->barcode); ?>"><?php echo e($wp_product->barcode ? (\Str::slug($wp_product->name)) : ''); ?> - <?php echo e($wp_product->sku); ?> - <?php echo e($wp_product->barcode); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                     </select>
                    <input type="hidden" class="form-control" id="new_sale_` + i + `_product_id" name="new_sale[` + i + `][product_id]" readonly/>
                    <input type="hidden" class="form-control" id="new_sale_` + i + `_product_code" name="new_sale[` +
                i + `][product_code]" readonly/>
                  </td>
                <td><input type="text" class="form-control bg-primary text-white" id="new_sale_` + i +
                `_stock_qty" name="new_sale[` + i + `][stock_qty]" readonly/></td>
                 <td><input type="number" class="form-control price" id="new_sale_` + i +
                `_price" data-qty = "new_sale_` + i + `_qty" data-sub_total = "new_sale_` + i +
                `_sub_total" name="new_sale[` + i + `][price]"/></td>
                 <td><input type="number" class="form-control break_qty" id="new_sale_` + i +
                `_break_qty"  name="new_sale[` + i + `][break_qty]"/></td>
                 <td class = "text-center"><button type = "button" class = "btn btn-danger btn-sm deleteRaw"><i class = "fas fa-minus-circle"></i></button></td>
               </tr>`;
            $('#saleTable tbody').append(html);
            $('.selectpicker').selectpicker('refresh');
            i++;
        });

        $(document).on('click', '.deleteRaw', function(){
            $(this).parent().parent().remove();
            calculateTotal();
            $('.selectpicker').selectpicker('refresh');
        });

        $('#saleTable').on('click', '.deleteRaw', function(){
            rowindex = $(this).closest('tr').index();
            item.splice(rowindex, 1);
            $(this).closest('tr').remove();
            notification('success', ' Removed Successfully');
        });

        $(document).on('change', '.cartonProductDetails', function(){
            parseFloat($('#shipping_cost').val(0))
            let productId       = $(this).find('option:selected').val();
            let product_code    = $(this).data('product_code');
            let price           = $(this).data('price');
            let stockQty        = $(this).data('stock_qty');
            if (productId != '') {
                $.ajax({
                    url: "<?php echo e(url('carton-wise-details')); ?>/" + productId,
                    type: "GET",
                    success: function(data) {
                        if (data != '') {
                            _(price).value          = data.price;
                            _(stockQty).value       = data.stockQty;
                            _(product_code).value   = data.product_code;
                        }
                    }
                });
            }
        });


        let table_row = 0;

        function removeRow(element, idx) {
            $('#' + element + idx).closest('div').remove();
            table_row--;
        }
        function storeData() {
            let form = document.getElementById('sale_store_form');
            let formData = new FormData(form);
            let url = "<?php echo e(route('carton.break.store')); ?>";
            $.ajax({
                url: url,
                type: "POST",
                data: formData,
                dataType: "JSON",
                contentType: false,
                processData: false,
                cache: false,
                beforeSend: function() {
                    $('#save-btn').addClass('spinner spinner-white spinner-right');
                },
                complete: function() {
                    $('#save-btn').removeClass('spinner spinner-white spinner-right');
                },
                success: function(data) {
                    $('#sale_store_form').find('.is-invalid').removeClass('is-invalid');
                    $('#sale_store_form').find('.error').remove();
                    if (data.status == false) {
                        $.each(data.errors, function(key, value) {
                            var key = key.split('.').join('_');
                            $('#sale_store_form input#' + key).addClass('is-invalid');
                            $('#sale_store_form textarea#' + key).addClass('is-invalid');
                            $('#sale_store_form select#' + key).parent().addClass('is-invalid');
                            $('#sale_store_form #' + key).parent().append(
                                '<small class="error text-danger">' + value + '</small>');
                        });
                    } else {
                        notification(data.status, data.message);
                        if (data.status == 'success') {
                            window.location.replace("<?php echo e(route('carton')); ?>");
                        }
                    }
                },
                error: function(xhr, ajaxOption, thrownError) {
                    console.log(thrownError + '\r\n' + xhr.statusText + '\r\n' + xhr.responseText);
                }
            });
        }
    </script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iconshoppercom/iconshopper/Modules/Carton/Resources/views/carton-break/index.blade.php ENDPATH**/ ?>