
<?php $__env->startSection('title', $page_title); ?>
<?php $__env->startPush('styles'); ?>
    <link href="<?php echo e(asset('plugins/custom/datatables/datatables.bundle.css')); ?>" rel="stylesheet" type="text/css"/>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <div class="d-flex flex-column-fluid">
        <div class="container-fluid">
            <div class="card card-custom gutter-b">
                <div class="card-header flex-wrap py-5">
                    <div class="card-title"><h3 class="card-label"><i class="<?php echo e($page_icon); ?> text-primary"></i> <?php echo e($sub_title); ?></h3></div>
                    <div class="card-toolbar">
                            <a href="javascript:void(0);" onclick="showFormModal('Add New Target Category','Save')" class="btn btn-primary btn-sm font-weight-bolder"><i class="fas fa-plus-circle"></i> Add
                                New</a>
                    </div>
                </div>
            </div>
            <div class="card card-custom">
                <div class="card-header flex-wrap py-5">

                </div>
                <div class="card-body">
                    <div id="kt_datatable_wrapper" class="dataTables_wrapper dt-bootstrap4 no-footer">
                        <div class="row">
                            <div class="col-sm-12">
                                <table id="dataTable" class="table table-bordered table-hover">
                                    <thead class="bg-primary">
                                    <tr>
                                        <th>Sl</th>
                                        <th>Target Category Name</th>
                                        <th>Target Category Percentage</th>
                                        <th>Action</th>
                                    </tr>
                                    </thead>
                                    <tbody></tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php echo $__env->make('reseller::target-category.modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('plugins/custom/datatables/datatables.bundle.js')); ?>" type="text/javascript"></script>
    <script>
        var table;
        $(document).ready(function () {
            table = $('#dataTable').DataTable({
                "processing": true, //Feature control the processing indicator
                "serverSide": true, //Feature control DataTable server side processing mode
                "order": [], //Initial no order
                "responsive": true, //Make table responsive in mobile device
                "bInfo": true, //TO show the total number of data
                "bFilter": false, //For datatable default search box show/hide
                "lengthMenu": [
                    [5, 10, 15, 25, 50, 100, 1000, 10000, -1],
                    [5, 10, 15, 25, 50, 100, 1000, 10000, "All"]
                ],
                "pageLength": 25, //number of data show per page
                "language": {
                    processing: `<i class="fas fa-spinner fa-spin fa-3x fa-fw text-primary"></i> `,
                    emptyTable: '<strong class="text-danger">No Data Found</strong>',
                    infoEmpty: '',
                    zeroRecords: '<strong class="text-danger">No Data Found</strong>'
                },
                "ajax": {
                    "url": "<?php echo e(route('target.category.datatable.data')); ?>",
                    "type": "POST",
                    "data": function (data) {
                        data.name = $("#form-filter #name").val();
                        data.phone = $("#form-filter #phone").val();
                        data.status = $("#form-filter #status").val();
                        data._token = _token;
                    }
                },

                "dom": "<'row'<'col-sm-12 col-md-6'l><'col-sm-12 col-md-6' <'float-right'B>>>" + "<'row'<'col-sm-12'tr>>" + "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'<'float-right'p>>>",
                "buttons": [
                    {
                        'extend': 'colvis', 'className': 'btn btn-secondary btn-sm text-white', 'text': 'Column', 'columns': ':gt(0)'
                    }, {
                        "extend": 'print',
                        'text': 'Print',
                        'className': 'btn btn-secondary btn-sm text-white',
                        "title": "<?php echo e($page_title); ?> List",
                        "orientation": "landscape", //portrait
                        "pageSize": "A4", //A3,A5,A6,legal,letter
                        "exportOptions": {
                            <?php if(permission('customer-bulk-delete')): ?>
                                <?php if(empty(Auth::user()->warehouse_id)): ?>
                            columns: ':visible:not(:eq(0),:eq(7))'
                            <?php else: ?>
                            columns: ':visible:not(:eq(0),:eq(6))'
                            <?php endif; ?>
                                <?php else: ?>
                                <?php if(empty(Auth::user()->warehouse_id)): ?>
                            columns: ':visible:not(:eq(6))'
                            <?php else: ?>
                            columns: ':visible:not(:eq(5))'
                            <?php endif; ?>
                            <?php endif; ?>

                        },
                        customize: function (win) {
                            $(win.document.body).addClass('bg-white');
                            $(win.document.body).find('table thead').css({'background': '#034d97'});
                            $(win.document.body).find('table tfoot tr').css({'background-color': '#034d97'});
                            $(win.document.body).find('h1').css('text-align', 'center');
                            $(win.document.body).find('h1').css('font-size', '15px');
                            $(win.document.body).find('table').css('font-size', 'inherit');
                        },
                    }, {
                        "extend": 'csv',
                        'text': 'CSV',
                        'className': 'btn btn-secondary btn-sm text-white',
                        "title": "<?php echo e($page_title); ?> List",
                        "filename": "<?php echo e(strtolower(str_replace(' ','-',$page_title))); ?>-list",
                        "exportOptions": {
                            <?php if(permission('customer-bulk-delete')): ?>
                                <?php if(empty(Auth::user()->warehouse_id)): ?>
                            columns: ':visible:not(:eq(0),:eq(7))'
                            <?php else: ?>
                            columns: ':visible:not(:eq(0),:eq(6))'
                            <?php endif; ?>
                                <?php else: ?>
                                <?php if(empty(Auth::user()->warehouse_id)): ?>
                            columns: ':visible:not(:eq(6))'
                            <?php else: ?>
                            columns: ':visible:not(:eq(5))'
                            <?php endif; ?>
                            <?php endif; ?>
                        }
                    }, {
                        "extend": 'excel',
                        'text': 'Excel',
                        'className': 'btn btn-secondary btn-sm text-white',
                        "title": "<?php echo e($page_title); ?> List",
                        "filename": "<?php echo e(strtolower(str_replace(' ','-',$page_title))); ?>-list",
                        "exportOptions": {
                            <?php if(permission('customer-bulk-delete')): ?>
                                <?php if(empty(Auth::user()->warehouse_id)): ?>
                            columns: ':visible:not(:eq(0),:eq(7))'
                            <?php else: ?>
                            columns: ':visible:not(:eq(0),:eq(6))'
                            <?php endif; ?>
                                <?php else: ?>
                                <?php if(empty(Auth::user()->warehouse_id)): ?>
                            columns: ':visible:not(:eq(6))'
                            <?php else: ?>
                            columns: ':visible:not(:eq(5))'
                            <?php endif; ?>
                            <?php endif; ?>
                        }
                    }, {
                        "extend": 'pdf',
                        'text': 'PDF',
                        'className': 'btn btn-secondary btn-sm text-white',
                        "title": "<?php echo e($page_title); ?> List",
                        "filename": "<?php echo e(strtolower(str_replace(' ','-',$page_title))); ?>-list",
                        "orientation": "landscape", //portrait
                        "pageSize": "A4", //A3,A5,A6,legal,letter
                        "exportOptions": {
                            <?php if(permission('customer-bulk-delete')): ?>
                                <?php if(empty(Auth::user()->warehouse_id)): ?>
                            columns: ':visible:not(:eq(0),:eq(7))'
                            <?php else: ?>
                            columns: ':visible:not(:eq(0),:eq(6))'
                            <?php endif; ?>
                                <?php else: ?>
                                <?php if(empty(Auth::user()->warehouse_id)): ?>
                            columns: ':visible:not(:eq(6))'
                            <?php else: ?>
                            columns: ':visible:not(:eq(5))'
                            <?php endif; ?>
                            <?php endif; ?>
                        },
                        customize: function (doc) {
                            doc.defaultStyle.fontSize = 7; //<-- set fontsize to 16 instead of 10
                            doc.styles.tableHeader.fontSize = 7;
                            doc.pageMargins = [5, 5, 5, 5];
                        }
                    },
                        <?php if(permission('customer-bulk-delete')): ?>
                    {
                        'className': 'btn btn-danger btn-sm delete_btn d-none text-white',
                        'text': 'Delete',
                        action: function (e, dt, node, config) {
                            multi_delete();
                        }
                    }
                    <?php endif; ?>
                ],
            });
            $('#btn-filter').click(function () {
                table.ajax.reload();
            });
            $('#btn-reset').click(function () {
                $('#form-filter')[0].reset();
                $('#form-filter .selectpicker').selectpicker('refresh');
                table.ajax.reload();
            });

            $(document).on('click', '#save-btn', function () {
                let form = document.getElementById('store_or_update_form');
                let formData = new FormData(form);
                let url = "<?php echo e(route('target.category.store.or.update')); ?>";
                let id = $('#update_id').val();
                let method;
                if (id) {
                    method = 'update';
                } else {
                    method = 'add';
                }
                store_or_update_data(table, method, url, formData);
            });

            $(document).on('click', '.edit_data', function () {
                let id = $(this).data('id');
                $('#store_or_update_form')[0].reset();
                $('#store_or_update_form').find('.is-invalid').removeClass('is-invalid');
                $('#store_or_update_form').find('.error').remove();
                if (id) {
                    $.ajax({
                        url: "<?php echo e(route('target.category.edit')); ?>",
                        type: "POST",
                        data: {id: id, _token: _token},
                        dataType: "JSON",
                        success: function (data) {
                            if (data.status == 'error') {
                                notification(data.status, data.message)
                            } else {
                                $('#store_or_update_form #update_id').val(data.id);
                                $('#store_or_update_form #name').val(data.name);
                                $('#store_or_update_form #target_category_percentage').val(data.target_category_percentage);
                                $('#store_or_update_form .selectpicker').selectpicker('refresh');
                                $('#store_or_update_modal').modal({
                                    keyboard: false,
                                    backdrop: 'static',
                                });
                                $('#store_or_update_modal .modal-title').html(
                                    '<i class="fas fa-edit text-white"></i> <span>Edit ' + data.name + '</span>');
                                $('#store_or_update_modal #save-btn').text('Update');
                            }

                        },
                        error: function (xhr, ajaxOption, thrownError) {
                            console.log(thrownError + '\r\n' + xhr.statusText + '\r\n' + xhr.responseText);
                        }
                    });
                }
            });

        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iconshoppercom/iconshopper/Modules/Reseller/Resources/views/target-category/index.blade.php ENDPATH**/ ?>