

<?php $__env->startSection('title', $page_title); ?>

<?php $__env->startPush('styles'); ?>
    <style>
        body, html {
            background: #fff !important;
            -webkit-print-color-adjust: exact !important;
        }

        .invoice {
            /* position: relative; */
            background: #fff !important;
            /* min-height: 680px; */
        }

        .invoice header {
            padding: 10px 0;
            margin-bottom: 20px;
            border-bottom: 1px solid #036;
        }

        .invoice .company-details {
            text-align: right
        }

        .invoice .company-details .name {
            margin-top: 0;
            margin-bottom: 0;
        }

        .invoice .contacts {
            margin-bottom: 20px;
        }

        .invoice .invoice-to {
            text-align: left;
        }

        .invoice .invoice-to .to {
            margin-top: 0;
            margin-bottom: 0;
        }

        .invoice .invoice-details {
            text-align: right;
        }

        .invoice .invoice-details .invoice-id {
            margin-top: 0;
            color: #036;
        }

        .invoice main {
            padding-bottom: 50px
        }

        .invoice main .thanks {
            margin-top: -100px;
            font-size: 2em;
            margin-bottom: 50px;
        }

        .invoice main .notices {
            padding-left: 6px;
            border-left: 6px solid #036;
        }

        .invoice table {
            width: 100%;
            border-collapse: collapse;
            border-spacing: 0;
            margin-bottom: 20px;
        }

        .invoice table th {
            background: #036;
            color: #fff;
            padding: 15px;
            border-bottom: 1px solid #fff
        }

        .invoice table td {
            padding: 15px;
            border-bottom: 1px solid #fff
        }

        .invoice table th {
            white-space: nowrap;
        }

        .invoice table td h3 {
            margin: 0;
            color: #036;
        }

        .invoice table .qty {
            text-align: center;
        }

        .invoice table .price,
        .invoice table .discount,
        .invoice table .tax,
        .invoice table .total {
            text-align: right;
        }

        .invoice table .no {
            color: #fff;
            background: #036
        }

        .invoice table .total {
            background: #036;
            color: #fff
        }

        .invoice table tbody tr:last-child td {
            border: none
        }

        .invoice table tfoot td {
            background: 0 0;
            border-bottom: none;
            white-space: nowrap;
            text-align: right;
            padding: 10px 20px;
            border-top: 1px solid #aaa;
            font-weight: bold;
        }

        .invoice table tfoot tr:first-child td {
            border-top: none
        }

        /* .invoice table tfoot tr:last-child td {
            color: #036;
            border-top: 1px solid #036
        } */

        /* .invoice table tfoot tr td:first-child {
            border: none
        } */

        .invoice footer {
            width: 100%;
            text-align: center;
            color: #777;
            border-top: 1px solid #aaa;
            padding: 8px 0
        }

        .invoice a {
            content: none !important;
            text-decoration: none !important;
            color: #036 !important;
        }

        .page-header,
        .page-header-space {
            height: 100px;
        }

        .page-footer,
        .page-footer-space {
            height: 20px;

        }

        .page-footer {
            position: fixed;
            bottom: 0;
            width: 100%;
            text-align: center;
            color: #777;
            border-top: 1px solid #aaa;
            padding: 8px 0
        }

        .page-header {
            position: fixed;
            top: 0mm;
            width: 100%;
            border-bottom: 1px solid black;
        }

        .page {
            page-break-after: always;
        }

        .dashed-border {
            width: 180px;
            height: 2px;
            margin: 0 auto;
            padding: 0;
            border-top: 1px dashed #454d55 !important;
        }

        @media  screen {
            .no_screen {
                display: none;
            }

            .no_print {
                display: block;
            }

            thead {
                display: table-header-group;
            }

            tfoot {
                display: table-footer-group;
            }

            button {
                display: none;
            }

            body {
                margin: 0;
            }
        }

        @media  print {

            body,
            html {
                /* background: #fff !important; */
                -webkit-print-color-adjust: exact !important;
                font-family: sans-serif;
                /* font-size: 12px !important; */
                margin-bottom: 100px !important;
            }

            .m-0 {
                margin: 0 !important;
            }

            h1,
            h2,
            h3,
            h4,
            h5,
            h6 {
                margin: 0 !important;
            }

            .no_screen {
                display: block !important;
            }

            .no_print {
                display: none;
            }

            a {
                content: none !important;
                text-decoration: none !important;
                color: #036 !important;
            }

            .text-center {
                text-align: center !important;
            }

            .text-left {
                text-align: left !important;
            }

            .text-right {
                text-align: right !important;
            }

            .float-left {
                float: left !important;
            }

            .float-right {
                float: right !important;
            }

            .text-bold {
                font-weight: bold !important;
            }

            .invoice {
                /* font-size: 11px!important; */
                overflow: hidden !important;
                background: #fff !important;
                margin-bottom: 100px !important;
            }

            .invoice footer {
                position: absolute;
                bottom: 0;
                left: 0;
                /* page-break-after: always */
            }

            /* .invoice>div:last-child {
                page-break-before: always
            } */
            .hidden-print {
                display: none !important;
            }

            .dashed-border {
                width: 180px;
                height: 2px;
                margin: 0 auto;
                padding: 0;
                border-top: 1px dashed #454d55 !important;
            }
        }

        @page  {
            /* size: auto; */
            margin: 5mm 5mm;

        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="d-flex flex-column-fluid">
        <div class="container-fluid">
            <!--begin::Notice-->
            <div class="card card-custom gutter-b">
                <div class="card-header flex-wrap py-5">
                    <div class="card-title">
                        <h3 class="card-label"><i class="<?php echo e($page_icon); ?> text-primary"></i> <?php echo e($sub_title); ?></h3>
                    </div>
                    <div class="card-toolbar">
                        <!--begin::Button-->
                        <button type="button" class="btn btn-primary btn-sm mr-3" id="print-invoice"><i class="fas fa-print"></i> Print</button>

                        <a href="<?php echo e(route('stock.return.list')); ?>" class="btn btn-warning btn-sm font-weight-bolder">
                            <i class="fas fa-arrow-left"></i> Back</a>
                        <!--end::Button-->
                    </div>
                </div>
            </div>
            <!--end::Notice-->
            <!--begin::Card-->
            <div class="card card-custom" style="padding-bottom: 100px !important;">
                <div class="card-body" style="padding-bottom: 100px !important;">
                    <div class="col-md-12 col-lg-12" style="width: 100%;">
                        <div id="invoice">
                            <div class="invoice overflow-auto">
                                <div>
                                    <table>
                                        <tr>
                                            <td class="text-center">
                                                <h2 class="name m-0" style="text-transform: uppercase;">
                                                    <b><?php echo e(config('settings.title') ? config('settings.title') : env('APP_NAME')); ?></b></h2>
                                                <?php if(config('settings.contact_no')): ?>
                                                    <p style="font-weight: normal;margin:0;"><b>Contact No.: </b><?php echo e(config('settings.contact_no')); ?>, <?php if(config('settings.email')): ?>
                                                            <b>Email: </b><?php echo e(config('settings.email')); ?>

                                                        <?php endif; ?></p>
                                                <?php endif; ?>
                                                <?php if(config('settings.address')): ?>
                                                    <p style="font-weight: normal;margin:0;"><?php echo e(config('settings.address')); ?></p>
                                                <?php endif; ?>
                                                <p style="font-weight: normal;margin:0;"><b>Date: </b><?php echo e(date('d-M-Y')); ?></p>
                                            </td>
                                        </tr>
                                    </table>
                                    <div style="width: 100%;height:3px;border-top:1px solid #036;border-bottom:1px solid #036;"></div>
                                    <table>
                                        <tr>
                                            <td width="50%" class="text-left">
                                                <h4 class="name m-0">Exchange</h4>
                                                <div class="m-0 date"><b>Exchange No.: <?php echo e($sale->return_no); ?></b></div>
                                                <div class="m-0 date"><b>Invoice No.: </b><?php echo e($sale->invoice_no); ?></div>
                                                <div class="m-0 date"><b>Date:</b><?php echo e(date('d-M-Y',strtotime($sale->sale_date))); ?></div>
                                            </td>

                                        </tr>
                                    </table>
                                    <table border="0" cellspacing="0" cellpadding="0">
                                        <thead>
                                        <tr>
                                            <th class="text-center">SL</th>
                                            <th class="text-left"> PRODUCT</th>
                                            <th class="text-center"> QUANTITY</th>
                                            <th class="text-center"> PRICE</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php if(!$sale->exchange_products->isEmpty()): ?>
                                            <?php $__currentLoopData = $sale->exchange_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    $unit_name = '';
                                                    if($item->unit_id)
                                                    {
                                                        $unit_name = \Illuminate\Support\Facades\DB::table('units')->where('id',$item->unit_id)->value('unit_name');
                                                    }
                                                    $g_t = 0;

                                                ?>
                                                <tr>
                                                    <td class="text-center no"><?php echo e($key+1); ?></td>
                                                    <td class="text-left">
                                                        <?php echo e($item->product->product_name . ' - ' . ($item->product_variant ? '(' . $item->product_variant->product_variant_name . ')' : '') . ($item->product->brand_id ? ' - [' . $item->product->brand->name . ']' : '') . ($item->product->sku ? ' - [' . $item->product->sku . ']' : '')); ?>

                                                    </td>
                                                    <td class="text-center qty"><?php echo e($item->old_exchange_qty.' '.$unit_name); ?></td>
                                                    <td class="text-center price"><?php echo e(number_format($item->old_price,2)); ?>

                                                        <?php
                                                            $g_t += $item->old_price
                                                        ?>
                                                    </td>

                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                        </tbody>
                                        <tfoot>

                                        <tr>
                                            <td colspan="3" class="text-right">NET EXCHANGE AMOUNT</td>
                                            <td class="text-center">
                                                <?php if(config('settings.currency_position') == 2): ?>
                                                    <?php echo e(number_format($g_t,2)); ?> <?php echo e(config('settings.currency_symbol')); ?>

                                                <?php else: ?>
                                                    <?php echo e(config('settings.currency_symbol')); ?> <?php echo e(number_format($g_t,2)); ?>

                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                        </tfoot>
                                    </table>
                                    <table style="width: 100%;">
                                        <tr>
                                            <td class="text-center">
                                                <div class="font-size-10" style="width:250px;float:left;">
                                                    <p style="margin:0;padding:0;"></p>
                                                    <p class="dashed-border"></p>
                                                    <p style="margin:0;padding:0;">Received By</p>
                                                </div>
                                            </td>
                                            <td class="text-center">
                                                <div class="font-size-10" style="width:250px;float:right;">
                                                    <p style="margin:35px 0 0 0;padding:0;"><b
                                                            class="text-uppercase"><?php echo e($sale->created_by); ?></b><br> <?php echo e(date('d-M-Y h:i:s A',strtotime($sale->created_at))); ?></p>
                                                    <p class="dashed-border"></p>
                                                    <p style="margin:0;padding:0;">Generated By</p>
                                                </div>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>

                            <!--***********************-->
                        </div>
                    </div>
                </div>
            </div>
            <!--end::Card-->
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="js/jquery.printarea.js"></script>
    <script>
        $(document).ready(function () {
            //QR Code Print
            $(document).on('click', '#print-invoice', function () {
                var mode = 'iframe'; // popup
                var close = mode == "popup";
                var options = {
                    mode: mode,
                    popClose: close
                };
                $("#invoice").printArea(options);
            });
        });

    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iconshoppercom/iconshopper/Modules/Exchange/Resources/views/sale/details.blade.php ENDPATH**/ ?>