
<?php $__env->startSection('title', $page_title); ?>
<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('css/jquery-ui.css')); ?>" />
    <link href="<?php echo e(asset('css/bootstrap-datetimepicker.min.css')); ?>" rel="stylesheet" type="text/css" />
    <style>
        .small-btn{
            width: 20px !important;
            height: 20px !important;
            padding: 0 !important;
        }
        .small-btn i{font-size: 10px !important;}
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <div class="d-flex flex-column-fluid">
        <div class="container-fluid">
            <div class="card card-custom gutter-b">
                <div class="card-header flex-wrap py-5">
                    <div class="card-title">
                        <h3 class="card-label"><i class="<?php echo e($page_icon); ?> text-primary"></i> <?php echo e($sub_title); ?></h3>
                    </div>
                    <div class="card-toolbar">
                        <a href="<?php echo e(route('exchange_list')); ?>" class="btn btn-warning btn-sm font-weight-bolder"><i class="fas fa-arrow-left"></i> <?php echo e(__('Back')); ?></a>
                    </div>
                </div>
            </div>
            <div class="card card-custom">
                <div class="card-body">
                    <div id="kt_datatable_wrapper" class="dataTables_wrapper dt-bootstrap4 no-footer">
                        <form action="" id="sale_delivery_form" method="post" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <input type = "hidden" id = "update_id" name="sale_id" value="<?php echo e($sale->id); ?>"/>
                            <div class="row">
                                <div class="form-group col-md-3 required">
                                    <label for="memo_no"><?php echo e(__('Invoice No')); ?>.</label>
                                    <input type="text" class="form-control bg-primary text-white" id="invoice_no" name="invoice_no" value="<?php echo e($invoiceNo); ?>" readonly/>
                                </div>
                                <div class="form-group col-md-3 required">
                                    <label for="sale_date"><?php echo e(__('Sale Date')); ?></label>
                                    <input type="date" class="form-control date bg-primary text-white" id="sale_date" name="sale_date" value="<?php echo e($sale->sale_date); ?>" readonly/>
                                </div>
                                <div class="form-group col-md-3 required">
                                    <label for="delivery_date"><?php echo e(__('Delivery Date')); ?></label>
                                    <input type="date" class="form-control date bg-primary text-white" id="receive_date" name="receive_date" value="<?php echo e(date('Y-m-d')); ?>" readonly/>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <div class="">
                                            <table class="table table-bordered quarterSelectTable" id="saleTable">
                                                <thead class="bg-primary text-center">
                                                <th width="20%" ><?php echo e(__('Product')); ?></th>
                                                <th width="5%" ><?php echo e(__('Unit')); ?></th>
                                                <th width="10%" ><?php echo e(__('Price')); ?></th>

                                                <th width="10%" ><?php echo e(__('Exchange Qty')); ?></th>
                                                <th width="10%" ><?php echo e(__('Received Qty')); ?></th>
                                                <th width="10%" ><?php echo e(__('Receive Qty')); ?></th>
                                                <th width="10%" ><?php echo e(__('Total Price')); ?></th>
                                                </thead>
                                                <tbody>
                                                <?php $__currentLoopData = $sale->exchange_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php
                                                        $varient = \Modules\Product\Entities\ProductVariant::where('product_code',$item->old_product_code)->first('product_variant_name')
                                                    ?>

                                                    <tr class="text-center">
                                                        <td>
                                                            <select class="form-control productDetails bg-primary text-white" id="sale_<?php echo e($key); ?>_product_id" name="sale[<?php echo e($key); ?>][product_id]">
                                                                <option value="<?php echo e($item->product->id); ?>"><?php echo e($item->product->product_name); ?>-<?php echo e($varient->product_variant_name); ?>-<?php echo e($item->old_product_code); ?>- <?php echo e($item->product->sku); ?></option>
                                                            </select>
                                                        </td>
                                                        <td>
                                                            <input type="hidden" class="form-control bg-primary text-white" id="sale_<?php echo e($key); ?>_product_code" name="sale[<?php echo e($key); ?>][product_code]" value="<?php echo e($item->old_product_code); ?>" readonly/>
                                                            <input type="text" class="form-control bg-primary text-white" id="sale_<?php echo e($key); ?>_unit_name" name="sale[<?php echo e($key); ?>][unit_name]" value="<?php echo e($item->product->unit->unit_code); ?>" readonly/>
                                                        </td>
                                                        <td><input type="text" class="form-control price bg-primary text-white" id="sale_<?php echo e($key); ?>_price" name="sale[<?php echo e($key); ?>][price]" value="<?php echo e($item->old_price); ?>" readonly/></td>
                                                        <td style="display: none"><input type="text" class="form-control bg-primary text-white " id="sale_<?php echo e($key); ?>_stock_qty" name="sale[<?php echo e($key); ?>][stock_qty]" value="<?php echo e($item->old_exchange_qty); ?>" readonly/></td>
                                                        <td><input type="text" class="form-control bg-primary text-white" id="sale_<?php echo e($key); ?>_qty" name="sale[<?php echo e($key); ?>][qty]" value="<?php echo e($item->old_exchange_qty); ?>" readonly/></td>
                                                        <td><input type="text" class="form-control bg-primary text-white" id="sale_<?php echo e($key); ?>_delivered_qty" value="<?php echo e($item->received_qty); ?>" readonly/></td>
                                                        <?php if($item->old_exchange_qty == $item->received_qty): ?>
                                                            <td>All Received <input type="hidden" class="form-control delivery_qty " id="sale_<?php echo e($key); ?>_delivery_qty" data-price = "sale_<?php echo e($key); ?>_price" data-stock_qty = "sale_<?php echo e($key); ?>_stock_qty" data-qty = "sale_<?php echo e($key); ?>_qty" data-delivered_qty = "sale_<?php echo e($key); ?>_delivered_qty" data-sub_total = "sale_<?php echo e($key); ?>_sub_total" name="sale[<?php echo e($key); ?>][receive_qty]"  readonly/></td>
                                                        <?php else: ?>
                                                            <td><input type="text" class="form-control delivery_qty" id="sale_<?php echo e($key); ?>_delivery_qty" data-price = "sale_<?php echo e($key); ?>_price" data-stock_qty = "sale_<?php echo e($key); ?>_stock_qty" data-qty = "sale_<?php echo e($key); ?>_qty" data-delivered_qty = "sale_<?php echo e($key); ?>_delivered_qty" data-sub_total = "sale_<?php echo e($key); ?>_sub_total" name="sale[<?php echo e($key); ?>][receive_qty]"/></td>

                                                        <?php endif; ?>

                                                        <td><input type="text" class="form-control sub_total bg-primary text-white" id="sale_<?php echo e($key); ?>_sub_total" name="sale[<?php echo e($key); ?>][sub_total]" readonly/></td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                                <tfoot class="bg-primary text-white text-center">
                                                <th colspan="5"></th>
                                                <th id="total_delivery_qty_view">0</th>
                                                <th id="total_delivery_sub_total_view">0</th>
                                                <input type="hidden" id="total_delivery_qty" name="total_receive_qty"/>
                                                <input type="hidden" id="total_delivery_sub_total" name="total_delivery_sub_total"/>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group col-md-12 text-center pt-5">
                                    <button type="button" class="btn btn-primary btn-sm mr-3" id="save-btn" onclick="deliveryData()"><i class="fas fa-save"></i><?php echo e(__('Received')); ?></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('js/jquery-ui.js')); ?>"></script>
    <script src="<?php echo e(asset('js/bootstrap-datetimepicker.min.js')); ?>"></script>
    <script>
        function _(x){
            return document.getElementById(x);
        }
        $(document).on('input','.delivery_qty',function(){
            let price         = parseFloat(_($(this).data('price')).value);
            let stockQty      = parseFloat(_($(this).data('stock_qty')).value);
            let saleQty       = parseFloat(_($(this).data('qty')).value);
            let deliveredQty  = parseFloat(_($(this).data('delivered_qty')).value);
            let value         = $(this).val();
            if(saleQty >= + value){
                _($(this).data('sub_total')).value = price * value;
            }else{
                $(this).val('');
                _($(this).data('sub_total')).value = '';
                notification('error','Quantity Can\'t Be Greater Then Exchange Quantity');
            }

            calculation();
        });
        function calculation(){
            let subTotal      = 0;
            let deliveryQty   = 0;
            $('.sub_total').each(function(){
                if($(this).val() == ''){
                    subTotal += + 0;
                }else{
                    subTotal += + $(this).val();
                }
            });
            $('.delivery_qty').each(function(){
                if($(this).val() == ''){
                    deliveryQty += + 0;
                }else{
                    deliveryQty += + $(this).val();
                }
            });
            _('total_delivery_qty_view').innerText          = deliveryQty;
            _('total_delivery_sub_total_view').innerText    = subTotal;
            _('total_delivery_qty').value                   = deliveryQty;
            _('total_delivery_sub_total').value             = subTotal;
        }
        function deliveryData(){
            let form     = document.getElementById('sale_delivery_form');
            let formData = new FormData(form);
            let url      = "<?php echo e(route('exchange.receive.store')); ?>";
            $.ajax({
                url           : url,
                type          : "POST",
                data          : formData,
                dataType      : "JSON",
                contentType   : false,
                processData   : false,
                cache         : false,
                beforeSend    : function(){
                    $('#save-btn').addClass('spinner spinner-white spinner-right');
                },
                complete      : function(){
                    $('#save-btn').removeClass('spinner spinner-white spinner-right');
                },
                success       : function (data) {
                    $('#sale_delivery_form').find('.is-invalid').removeClass('is-invalid');
                    $('#sale_delivery_form').find('.error').remove();
                    if (data.status == false) {
                        $.each(data.errors, function (key, value) {
                            var key = key.split('.').join('_');
                            $('#sale_delivery_form input#' + key).addClass('is-invalid');
                            $('#sale_delivery_form textarea#' + key).addClass('is-invalid');
                            $('#sale_delivery_form select#' + key).parent().addClass('is-invalid');
                            $('#sale_delivery_form #' + key).parent().append('<small class="error text-danger">' + value + '</small>');
                        });
                    } else {
                        notification(data.status, data.message);
                        if (data.status == 'success') { window.location.replace("<?php echo e(route('exchange_list')); ?>"); }
                    }
                },
                error        : function (xhr, ajaxOption, thrownError) { console.log(thrownError + '\r\n' + xhr.statusText + '\r\n' + xhr.responseText); }
            });
        }
    </script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iconshoppercom/iconshopper/Modules/Exchange/Resources/views/sale/delivery.blade.php ENDPATH**/ ?>