<?php $__env->startSection('title', $page_title); ?>

<?php $__env->startPush('styles'); ?>
    <link href="plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css"/>
    <link href="css/daterangepicker.min.css" rel="stylesheet" type="text/css"/>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="d-flex flex-column-fluid">
        <div class="container-fluid">
            <!--begin::Notice-->
            <div class="card card-custom gutter-b">
                <div class="card-header flex-wrap py-5">
                    <div class="card-title">
                        <h3 class="card-label"><i class="<?php echo e($page_icon); ?> text-primary"></i> <?php echo e($sub_title); ?></h3>
                    </div>
                    <div class="card-toolbar">
                    </div>
                </div>
                <!--end::Notice-->
                <!--begin::Card-->
                <div class="card card-custom">
                    <div class="card-header flex-wrap py-5">
                        <div class="filter-toggle btn-group float-right" style="margin-bottom: 1rem;margin-left: auto;">
                            <div class="btn btn-primary btn-sm today-btn data-btn mr-1" data-start_date="<?php echo e(date('Y-m-d')); ?>" data-end_date="<?php echo e(date('Y-m-d')); ?>">Today</div>
                            <div class="btn btn-primary btn-sm yesterday-btn data-btn mr-1" data-start_date="<?php echo e(date('Y-m-d', strtotime('yesterday'))); ?>"
                                 data-end_date="<?php echo e(date('Y-m-d', strtotime('yesterday'))); ?>">Yesterday
                            </div>
                            <div class="btn btn-primary btn-sm week-btn data-btn mr-1" data-start_date="<?php echo e(date('Y-m-d',strtotime('-7 day'))); ?>" data-end_date="<?php echo e(date('Y-m-d')); ?>">
                                This Week
                            </div>
                            <div class="btn btn-primary btn-sm month-btn data-btn mr-1" data-start_date="<?php echo e(date('Y-m').'-01'); ?>" data-end_date="<?php echo e(date('Y-m-d')); ?>">This Month</div>
                            <div class="btn btn-primary btn-sm year-btn data-btn mr-1" data-start_date="<?php echo e(date('Y').'-01-01'); ?>" data-end_date="<?php echo e(date('Y').'-12-31'); ?>">This Year
                            </div>
                        </div>
                        <form method="POST" id="form-filter" class="col-md-12 px-0">
                            <div class="row">
                                <div class="form-group col-md-3">
                                    <label for="name">Choose Your Date</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control daterangepicker-filed">
                                        <input type="hidden" id="start_date" name="start_date">
                                        <input type="hidden" id="end_date" name="end_date">
                                    </div>
                                </div>
                                <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.form.selectbox','data' => ['labelName' => 'User','name' => 'created_by','col' => 'col-md-3','class' => 'selectpicker']]); ?>
<?php $component->withName('form.selectbox'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes(['labelName' => 'User','name' => 'created_by','col' => 'col-md-3','class' => 'selectpicker']); ?>
                                    <?php $__currentLoopData = $created_by; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($value->created_by); ?>"><?php echo e($value->user_name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>

                                <div class="col-md-3">
                                    <div style="margin-top:28px;">
                                        <button id="btn-reset" class="btn btn-danger btn-sm btn-elevate btn-icon mr-2 float-left"
                                                type="button" data-toggle="tooltip" data-theme="dark" title="Reset">
                                            <i class="fas fa-undo-alt"></i></button>

                                        <button id="btn-filter"
                                                class="btn btn-primary btn-sm btn-elevate btn-icon float-left" type="button"
                                                data-toggle="tooltip" data-theme="dark" title="Search">
                                            <i class="fas fa-search"></i></button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="card-body">
                        <!--begin: Datatable-->
                        <div id="kt_datatable_wrapper" class="dataTables_wrapper dt-bootstrap4 no-footer">
                            <div class="row">
                                <div class="col-sm-12 table-responsive">
                                    <table id="dataTable" class="table table-bordered table-hover">
                                        <thead class="bg-primary">
                                        <tr>
                                            <th>Sl</th>
                                            <th>User</th>
                                            <th>Confirm</th>
                                            <th>Delivered</th>
                                            <th>Return</th>
                                        </tr>
                                        </thead>
                                        <tbody></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <!--end: Datatable-->
                    </div>
                </div>
                <!--end::Card-->
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="plugins/custom/datatables/datatables.bundle.js" type="text/javascript"></script>
    <script src="js/moment.js"></script>
    <script src="js/knockout-3.4.2.js"></script>
    <script src="js/daterangepicker.min.js"></script>
    <script>
        $('.daterangepicker-filed').daterangepicker({
            callback: function (startDate, endDate, period) {
                var start_date = startDate.format('YYYY-MM-DD');
                var end_date = endDate.format('YYYY-MM-DD');
                var title = start_date + ' To ' + end_date;
                $(this).val(title);
                $('input[name="start_date"]').val(start_date);
                $('input[name="end_date"]').val(end_date);
            }
        });
        var table;
        $(document).ready(function () {
            $('.data-btn').removeClass('active');
            table = $('#dataTable').DataTable({
                "processing": true, //Feature control the processing indicator
                "serverSide": true, //Feature control DataTable server side processing mode
                "order": [], //Initial no order
                'ordering': false,
                "responsive": false, //Make table responsive in mobile device
                "bInfo": true, //TO show the total number of data
                "bFilter": false, //For datatable default search box show/hide
                "lengthMenu": [
                    [5, 10, 15, 25, 50, 100, 1000, 10000, -1],
                    [5, 10, 15, 25, 50, 100, 1000, 10000, "All"]
                ],
                "pageLength": 25, //number of data show per page
                "language": {
                    processing: `<i class="fas fa-spinner fa-spin fa-3x fa-fw text-primary"></i> `,
                    emptyTable: '<strong class="text-danger">No Data Found</strong>',
                    infoEmpty: '',
                    zeroRecords: '<strong class="text-danger">No Data Found</strong>'
                },
                "ajax": {
                    "url": "<?php echo e(route('ecom-report.get.datatable.data')); ?>",
                    "type": "POST",
                    "data": function (data) {
                        data.start_date = $("#form-filter #start_date").val();
                        data.end_date = $("#form-filter #end_date").val();
                        data.created_by = $("#form-filter #created_by").val();
                        data._token = _token;
                    }
                },
                "columnDefs": [{
                    "targets": [0,1,2,3,4],
                    "orderable": false,
                    "className": "text-center"
                },],
                "dom": "<'row'<'col-sm-12 col-md-6'l><'col-sm-12 col-md-6' <'float-right'B>>>" +
                    "<'row'<'col-sm-12'tr>>" + "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'<'float-right'p>>>",

                "buttons": [],
            });

            $('.data-btn').on('click', function () {
                $('.data-btn').removeClass('active');
                $(this).addClass('active');
                var start_date = $(this).data('start_date');
                var end_date = $(this).data('end_date');
                $("#form-filter #start_date").val(start_date);
                $("#form-filter #end_date").val(end_date);
                table.ajax.reload();
            });

            $(document).on('click', '#btn-filter', function () {
                var start_date = $("#form-filter #start_date").val();
                var end_date = $("#form-filter #end_date").val();
                table.ajax.reload();
            });

            $('#btn-reset').click(function () {
                $('#form-filter')[0].reset();
                $('#form-filter .selectpicker').selectpicker('refresh');
                $('.data-btn').removeClass('active');
                $("#form-filter #start_date").val('');
                $("#form-filter #end_date").val('');
                table.ajax.reload();
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iconshoppercom/iconshopper/Modules/Sale/Resources/views/sales_report/ecom-report.blade.php ENDPATH**/ ?>