

<?php $__env->startSection('title', $page_title); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex flex-column-fluid">
    <div class="container-fluid">
        <!--begin::Notice-->
        <div class="card card-custom gutter-b">
            <div class="card-header flex-wrap py-5">
                <div class="card-title">
                    <h3 class="card-label"><i class="<?php echo e($page_icon); ?> text-primary"></i> <?php echo e($sub_title); ?></h3>
                </div>
                <div class="card-toolbar">
                    <!--begin::Button-->
                    <a href="<?php echo e(route('adjustment')); ?>" class="btn btn-warning btn-sm font-weight-bolder">
                        <i class="fas fa-arrow-left"></i> Back</a>
                    <!--end::Button-->
                </div>
            </div>
        </div>
        <!--end::Notice-->
        <!--begin::Card-->
        <div class="card card-custom">
            <div class="card-body">
                <!--begin: Datatable-->
                <div id="kt_datatable_wrapper" class="dataTables_wrapper dt-bootstrap4 no-footer">
                    <div class="row">
                        <input type="hidden" name="adjustment_id" value="<?php echo e($adjustment->id); ?>">

                        <div class="col-md-12 text-center">
                            <h6>Adjustment No.: <?php echo e($adjustment->adjustment_no); ?></h6>
                        </div>

                        <div class="col-md-12">
                            <table class="table table-bordered" id="product_table">
                                <thead class="bg-primary">
                                    <th width="40%">Name</th>
                                    <th  width="15%" class="text-center">SKU</th>
                                    <th  width="15%" class="text-center">Code</th>
                                    <th width="10%" class="text-center">Unit</th>
                                    <th width="10%" class="text-center">Quantity</th>
                                    <th width="15%" class="text-center">Action</th>
                                </thead>
                                <tbody>
                                    <?php
                                        $temp_unit_name = [];
                                    ?>
                                    <?php if(!$adjustment->products->isEmpty()): ?>
                                        <?php $__currentLoopData = $adjustment->products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $adjustment_product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e(!empty($adjustment_product->product_variant_id) ? $adjustment_product->product->product_name.' - ('.$adjustment_product->product_variant->product_variant_name.')' : $adjustment_product->product->product_name); ?></td>
                                                <td class="text-center"><?php echo e($adjustment_product->product->sku); ?></td>
                                                <td class="text-center"><?php echo e(!empty($adjustment_product->product_variant_id) ? $adjustment_product->product_variant->product_code :  $adjustment_product->product->product_code); ?></td>
                                                <td class="unit-name text-center"><?php echo e($adjustment_product->product->unit->unit_name); ?></td>
                                                <td class="text-center"><?php echo e($adjustment_product->qty); ?></td>

                                                <td class="text-center"> <?php echo e($adjustment_product->action == '+' ? 'Addition' : 'Subtraction'); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </tbody>
                                <tfoot class="bg-primary">
                                    <th colspan="4" class="font-weight-bolder">Total</th>
                                    <th id="total-qty" class="text-center font-weight-bolder"><?php echo e($adjustment->total_qty); ?></th>
                                    <th></th>
                                </tfoot>
                            </table>
                        </div>

                        <div class="form-group col-md-12">
                            <label for="shipping_cost">Note</label>
                            <p><?php echo e($adjustment->note); ?></p>
                        </div>
                    </div>
                </div>
                <!--end: Datatable-->
            </div>
        </div>
        <!--end::Card-->
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iconshoppercom/iconshopper/Modules/Product/Resources/views/adjustment/details.blade.php ENDPATH**/ ?>