
<?php $__env->startSection('title', $page_title); ?>
<?php $__env->startPush('styles'); ?>
<link href="<?php echo e(asset('css/daterangepicker.min.css')); ?>" rel="stylesheet" type="text/css" />
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
<div class="d-flex flex-column-fluid">
    <div class="container-fluid">
        <div class="card card-custom gutter-b">
            <div class="card-header flex-wrap py-5">
                <div class="card-title">
                    <h3 class="card-label"><i class="<?php echo e($page_icon); ?> text-primary"></i> <?php echo e($sub_title); ?></h3>
                </div>
                <div class="card-toolbar">
                    <?php if(permission('supplier-access')): ?>
                    <a href="<?php echo e(route('supplier')); ?>" class="btn btn-primary btn-sm font-weight-bolder mr-3"><i class="fas fa-user-tie"></i> <?php echo e(__('file.Manage Supplier')); ?></a>
                    <?php endif; ?>
                    <?php if(permission('supplier-advance-access')): ?>
                    <a href="<?php echo e(route('supplier.advance')); ?>" class="btn btn-primary btn-sm font-weight-bolder"><i class="fas fa-hand-holding-usd"></i> <?php echo e(__('file.Supplier Advance')); ?></a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="card card-custom">
            <div class="card-header flex-wrap py-5">
                <form method="POST" id="form-filter" class="col-md-12 px-0">
                    <div class="row justify-content-center">
                        <div class="col-md-3">
                            <label for="supplier_id"><?php echo e(__('Supplier')); ?></label>
                            <select class="form-control" id="supplier_id" name="supplier_id">
                                <option value=""><?php echo e(__('Select Please')); ?></option>
                                <?php if(!$suppliers->isEmpty()): ?>
                                    <?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <option value="<?php echo e($supplier->id); ?>"><?php echo e($supplier->name.'('.$supplier->company_name.')'); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </select>
                        </div>
                        <div class="form-group col-md-3">
                            <label for="name"><?php echo e(__('Choose Your Date')); ?></label>
                            <div class="input-group">
                                <input type="text" class="form-control daterangepicker-filed">
                                <input type="hidden" id="from_date" name="from_date" >
                                <input type="hidden" id="to_date" name="to_date" >
                            </div>
                        </div>
                        <div class="col-md-1">
                            <div style="margin-top:28px;">
                                <div style="margin-top:28px;">
                                    <button id="btn-reset" class="btn btn-danger btn-sm btn-elevate btn-icon float-right" type="button" data-toggle="tooltip" data-theme="dark" title="<?php echo e(__('file.Reset')); ?>"><i class="fas fa-undo-alt"></i></button>
                                    <button id="btn-filter" class="btn btn-primary btn-sm btn-elevate btn-icon mr-2 float-right" type="button" data-toggle="tooltip" data-theme="dark" title="<?php echo e(__('file.Search')); ?>"><i class="fas fa-search"></i></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="card-body">
                <div id="kt_datatable_wrapper" class="dataTables_wrapper dt-bootstrap4 no-footer">
                    <div class="row">
                        <div class="col-sm-12">
                            <table id="dataTable" class="table table-bordered table-hover">
                                <thead class="bg-primary">
                                    <tr>
                                        <th><?php echo e(__('Date')); ?></th>
                                        <th><?php echo e(__('Narration')); ?></th>
                                        <th><?php echo e(__('Voucher No')); ?></th>
                                        <th><?php echo e(__('Debit')); ?></th>
                                        <th><?php echo e(__('Credit')); ?></th>
                                        <th><?php echo e(__('Balance')); ?></th>
                                    </tr>
                                </thead>
                                <tbody></tbody>
                                <tfoot>
                                    <tr class="bg-primary">
                                        <th></th>
                                        <th></th>
                                        <th style="text-align: right !important;font-weight:bold;"><?php echo e(__('Total')); ?></th>
                                        <th style="text-align: right !important;font-weight:bold;"></th>
                                        <th style="text-align: right !important;font-weight:bold;"></th>
                                        <th style="text-align: right !important;font-weight:bold;"></th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script src="plugins/custom/datatables/datatables.bundle.js" type="text/javascript"></script>
    <script src="js/moment.js"></script>
    <script src="js/knockout-3.4.2.js"></script>
    <script src="js/daterangepicker.min.js"></script>
    <script>
        $('.daterangepicker-filed').daterangepicker({
            callback: function(startDate, endDate, period){
                var start_date = startDate.format('YYYY-MM-DD');
                var end_date   = endDate.format('YYYY-MM-DD');
                var title = start_date + ' To ' + end_date;
                $(this).val(title);
                $('input[name="start_date"]').val(start_date);
                $('input[name="end_date"]').val(end_date);
            }
        });
    function _(x){
        return document.getElementById(x);
    }
    $(document).on('change','#supplier_id',function (){
        _('supplier_name').innerText =  $( "#supplier_id option:selected" ).text();
    })
    $(document).ready(function(){
        table = $('#dataTable').DataTable({
            "processing": true,
            "serverSide": true,
            "order"     : [],
            "responsive": true,
            "bInfo"     : true,
            "bFilter"   : false,
            "lengthMenu": [
                [5, 10, 15, 25, 50, 100, 1000, 10000, -1],
                [5, 10, 15, 25, 50, 100, 1000, 10000, "All"]
            ],
            "pageLength": 25,
            "language"  : {
                processing : `<i class="fas fa-spinner fa-spin fa-3x fa-fw text-primary"></i> `,
                emptyTable : '<strong class="text-danger"><?php echo e(__('file.No Data Found')); ?></strong>',
                infoEmpty  : '',
                zeroRecords: '<strong class="text-danger"><?php echo e(__('file.No Data Found')); ?></strong>'
            },
            "ajax": {
                "url" : "<?php echo e(route('supplier.ledger.datatable.data')); ?>",
                "type": "POST",
                "data": function (data) {
                    data.supplier_id = $("#form-filter #supplier_id option:selected").val();
                    data.from_date   = $("#form-filter #from_date").val();
                    data.to_date     = $("#form-filter #to_date").val();
                    data._token      = _token;
                }
            },
            "columnDefs": [{
                    "targets": [0,1,2,3,4,5],
                    "className": "text-center"
                }
            ],
            "dom": "<'row'<'col-sm-12 col-md-6'l><'col-sm-12 col-md-6' <'float-right'B>>>" + "<'row'<'col-sm-12'tr>>" + "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'<'float-right'p>>>",
            "buttons": [{
                    'extend':'colvis','className':'btn btn-secondary btn-sm text-white','text':'<?php echo e(__('file.Column')); ?>','columns': ':gt(0)'
                }, {
                    "extend"       : 'print',
                    'text'         :'<?php echo e(__('file.Print')); ?>',
                    'className'    :'btn btn-secondary btn-sm text-white',
                "title"        : "<?php echo e($page_title); ?> List",
                    "orientation"  : "landscape",
                    "pageSize"     : "A4",
                    "exportOptions": {
                        columns    : function (index, data, node) {
                            return table.column(index).visible();
                        }
                    },
                    customize: function (win) {
                    $(win.document.body).addClass('bg-white');
                    $(win.document.body).find('table thead').css({'background':'#034d97'});
                    $(win.document.body).find('table tfoot tr').css({'background-color':'#034d97'});
                    $(win.document.body).find('h1').css('text-align', 'center');
                    $(win.document.body).find('h1').css('font-size', '15px');
                    $(win.document.body).find('table').css( 'font-size', 'inherit' );
                    },
                    footer:true
                },
                {
                    "extend"       : 'csv',
                    'text'         :'<?php echo e(__('file.CSV')); ?>',
                    'className'    :'btn btn-secondary btn-sm text-white',
                    "title"        : "<?php echo e($page_title); ?> List",
                    "filename"     : "<?php echo e(strtolower(str_replace(' ','-',$page_title))); ?>-list",
                    "exportOptions": {
                        columns    : function (index, data, node) {
                            return table.column(index).visible();
                        }
                    },
                    footer:true
                },
                {
                    "extend": 'excel',
                    'text':'<?php echo e(__('file.Excel')); ?>',
                    'className':'btn btn-secondary btn-sm text-white',
                    "title": "<?php echo e($page_title); ?> List",
                    "filename": "<?php echo e(strtolower(str_replace(' ','-',$page_title))); ?>-list",
                    "exportOptions": {
                        columns: function (index, data, node) {
                            return table.column(index).visible();
                        }
                    },
                    footer:true
                },
                {
                    "extend": 'pdf',
                    'text':'<?php echo e(__('file.PDF')); ?>',
                    'className':'btn btn-secondary btn-sm text-white',
                    "title": "<?php echo e($page_title); ?> List",
                    "filename": "<?php echo e(strtolower(str_replace(' ','-',$page_title))); ?>-list",
                    "orientation": "landscape", //portrait
                    "pageSize": "A4", //A3,A5,A6,legal,letter
                    "exportOptions": {
                        columns: function (index, data, node) {
                            return table.column(index).visible();
                        }
                    },
                    footer:true,
                    customize: function(doc) {
                        doc.defaultStyle.fontSize = 7; //<-- set fontsize to 16 instead of 10
                        doc.styles.tableHeader.fontSize = 7;
                        doc.styles.tableFooter.fontSize = 7;
                        doc.pageMargins = [5,5,5,5];
                    }
                },
            ],
            "footerCallback": function ( row, data, start, end, display ) {
                var api = this.api(), data;
                var intVal = function ( i ) {
                    return typeof i === 'string' ?
                        i.replace(/[\$,]/g, '')*1 :
                        typeof i === 'number' ?
                            i : 0;
                };
                var debit             = 0;
                var credit            = 0;
                var balance           = 0;
                var currency_symbol   = "<?php echo e(config('settings.currency_symbol')); ?>";
                var currency_position = "<?php echo e(config('settings.currency_position')); ?>";
                for (let index = 3; index <= 4; index++) {
                    pageTotal = api
                        .column( index, { page: 'current'} )
                        .data()
                        .reduce( function (a, b) {
                            return intVal(a) + intVal(b);
                        }, 0 );
                        if(index == 3){
                            debit = pageTotal;
                        }else{
                            credit = pageTotal;
                        }
                    var total = (currency_position == 1) ? currency_symbol+' '+number_format(pageTotal) : number_format(pageTotal)+' '+currency_symbol;
                    $(api.column( index ).footer()).html(total);
                }
                balance = (currency_position == 1) ? currency_symbol+' '+number_format((debit - credit)) : number_format((debit - credit))+' '+currency_symbol;
                $(api.column(5).footer()).html(balance);
            }
        });
        $('#btn-filter').click(function () {table.ajax.reload();});
        $('#btn-reset').click(function () {
            $('#form-filter')[0].reset();
            $('#form-filter #from_date').val("");
            $('#form-filter #to_date').val("");
            $('#form-filter .selectpicker').selectpicker('refresh');
            table.ajax.reload();
        });
    });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iconshoppercom/iconshopper/Modules/Supplier/Resources/views/ledger/index.blade.php ENDPATH**/ ?>