<?php if(count($combinations[0]) > 0): ?>
    <table class="table table-bordered table" id="variantTableContainer">
        <thead>
            <tr class="bg-primary" style="color: white;">

                <td class="text-center">
                    <?php echo e('Variant'); ?>

                </td>
                <td class="text-center">
                    <?php echo e('Code'); ?>

                </td>
                <td class="text-center" data-breakpoints="lg">
                    <?php echo e('Quantity'); ?>

                </td>
                <td class="text-center">
                    <?php echo e('Unit P.'); ?>

                    <label class="aiz-switch aiz-switch-success mb-0">
                        <input type="checkbox" value="1" id="unit_price_apply_for_all">
                        <span></span>
                    </label>
                </td>
                <td class="text-center">
                    <?php echo e('Regular P.'); ?>

                </td>
                <td class="text-center">
                    <?php echo e('Discount A.'); ?>

                </td>
                <td class="text-center">
                    <?php echo e('Discount T.'); ?>

                </td>
                <td class="text-center">
                    <?php echo e('Sale Price'); ?>

                </td>
                <td class="text-center" data-breakpoints="lg">
                    <?php echo e('WholeSale Price'); ?>

                    <label class="aiz-switch aiz-switch-success mb-0">
                        <input type="checkbox" value="1" id="whole_sale_apply_for_all">
                        <span></span>
                    </label>
                </td>

                <td></td>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $combinations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key1 => $combination): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $sku = '';
                    $idx = 0;
                    foreach (explode(' ', $product_name) as $key => $value) {
                        $sku .= substr($value, 0, 1);
                    }

                    $str = '';
                    $str_name = '';
                    $str_id = '';
                    $c_id = '';
                    $attr_id = '';

                    foreach ($combination as $key => $item) {
                        if ($key > 0) {
                            $str .= '-' . str_replace(' ', '', $item->name);
                            $str_name .= '-' . str_replace(' ', '', $item->name);
                            $str_id .= '-' . str_replace(' ', '', $item->id);
                            $attr_id .= str_replace(' ', '', $item->id) . '-';

                            $sku .= '-' . str_replace(' ', '', $item->name);
                        } else {
                            if ($colors_active == 1 && $key == 0) {
                                // dd($combination);

                                $color = \Modules\Product\Entities\Color::where('code', $item)->first();
                                $color_name = $color->name;
                                $color_id = $color->id;
                                $str .= $color_name;
                                $str_name .= $color_name;
                                $str_id .= $color_id;

                                $sku .= '-' . $color_name;
                                $c_id .= $color_id;
                            } else {
                                $str .= str_replace(' ', '', $item->name);
                                $str_name .= str_replace(' ', '', $item->name);
                                $str_id .= str_replace(' ', '', $item->id);
                                $attr_id .= str_replace(' ', '', $item->id);
                                $sku .= '-' . str_replace(' ', '', $item->name);
                            }
                        }
                    }
                ?>
                <?php if(strlen($str) > 0): ?>
                    <tr class="variant" id="MyTable">

                        <td>
                            <input type="hidden" name="product_attribute[<?php echo e($str_id); ?>][color_id]"
                                value="<?php echo e($c_id); ?>">
                            <input type="hidden" name="product_attribute[<?php echo e($str_id); ?>][attribute_id]"
                                value="<?php echo e($str_id); ?>">
                            <input type="hidden" name="product_attribute[<?php echo e($str_id); ?>][variant_id]"
                                value="<?php echo e($attr_id); ?>">

                            <label for="" class="control-label"><?php echo e($str); ?></label>
                            <input type="hidden" name="product_attribute[<?php echo e($str_id); ?>][product_variant_name]"
                                id="product_attribute_<?php echo e($str_id); ?>_product_variant_name"
                                value="<?php echo e($str); ?>">
                        </td>
                        <td>
                            <div class="form-group mb-0">
                                <div class="input-group" id="code_section">
                                    <input type="text" class="form-control text-center"
                                        name="product_attribute[<?php echo e($str_id); ?>][product_code]"
                                        id="product_attribute_<?php echo e($str_id); ?>_product_code"
                                        data-row="<?php echo e($str_id); ?>">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text bg-primary"
                                            id="generate-<?php echo e($str_id); ?>-code"
                                            onclick="generate_variants_code('<?php echo e($str_id); ?>')"
                                            data-toggle="tooltip" data-theme="dark" title="Generate Code"
                                            style="border-top-right-radius: 0.42rem;border-bottom-right-radius: 0.42rem;border:0;cursor: pointer;width: 0px;">
                                            <i class="fas fa-retweet text-white" style="margin-left: -10px;"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </td>
                        <td>
                            <input type="number" lang="en" name="product_attribute[<?php echo e($str_id); ?>][qty]"
                                id="product_attribute_<?php echo e($str_id); ?>_qty" value="1" min="0"
                                step="0" class="form-control" required>
                        </td>
                        <td>
                            <input type="number" lang="en"
                                name="product_attribute[<?php echo e($str_id); ?>][unit_price]"
                                id="product_attribute_<?php echo e($str_id); ?>_unit_price" value="0" min="0"
                                step="0.01" class="form-control unit_price_picker"
                                required>
                        </td>
                        <td>
                            <input type="number" lang="en"
                                name="product_attribute[<?php echo e($str_id); ?>][regular_price]"
                                id="product_attribute_<?php echo e($str_id); ?>_regular_price"
                                oninput="calculateSalePrice1('<?php echo e(json_encode($str_id)); ?>')" value="0"
                                min="0" step="0.01" class="form-control" required>

                        </td>
                        <td>
                            <input type="number" lang="en"
                                name="product_attribute[<?php echo e($str_id); ?>][discount]"
                                oninput="calculateSalePrice1('<?php echo e(json_encode($str_id)); ?>')"
                                id="product_attribute_<?php echo e($str_id); ?>_discount" value="0" min="0"
                                step="1" class="form-control">
                        </td>
                        <td>
                            <select class="form-control selectpicker"
                                name="product_attribute[<?php echo e($str_id); ?>][discount_type]"
                                onchange="calculateSalePrice1('<?php echo e(json_encode($str_id)); ?>')"
                                id="product_attribute_<?php echo e($str_id); ?>_discount_type">
                                <option value="amount"><?php echo e('Flat'); ?></option>
                                <option value="percent"><?php echo e('Percent'); ?></option>
                            </select>
                        </td>

                        <td>
                            <input type="number" lang="en"
                                name="product_attribute[<?php echo e($str_id); ?>][sale_price]"
                                id="product_attribute_<?php echo e($str_id); ?>_sale_price" value="0" min="0"
                                step="0.01" class="form-control" id="salePrice-<?php echo e($key1); ?>" required>
                        </td>
                        <td>
                            <input type="number" lang="en"
                                name="product_attribute[<?php echo e($str_id); ?>][whole_sale_price]"
                                id="product_attribute_<?php echo e($str_id); ?>_wholeSale_price" value="0"
                                min="0" step="0.01" class="form-control whole_sale_price_picker" required>
                        </td>

                        <td class="text-center">
                            <i class="fas fa-trash remove-product text-danger trash-button"
                                style="cursor:pointer;"></i>
                        </td>
                    </tr>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

<?php if($colors_active): ?>
    <div class="card color_image_card">
        <div class="card-header">
            <h5 class="mb-0 h6"><?php echo e('Color Images'); ?></h5>
        </div>
        <div class="card-body">
            <div class="form-group row">
                
                <div class="col-md-12">
                    <div class="row">
                        <div class="form-group col-md-12 mb-0 text-center">
                            <div class="col-md-12 row px-0 text-center">
                                <?php $__currentLoopData = $colors_only; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key_color => $color_item_code): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php

                                        $colorCode = $color_item_code; // Your color code

                                        // Remove the "#" symbol
                                        $colorCodeWithoutHash = str_replace('#', '', $colorCode);

//                                    ?>



                                        <div id="color_image_<?php echo e($colorCodeWithoutHash); ?>_1" class="col-md-3 row"></div>

                                        <style>
                                            .color_code_bg_<?php echo e($colorCodeWithoutHash); ?> {
                                                background: #<?php echo e($colorCodeWithoutHash); ?>;

                                            }
                                        </style>

                                        <script>
                                            $('#color_image_<?= $colorCodeWithoutHash ?>_1').spartanMultiImagePicker({
                                                fieldName: 'color_image[<?= $colorCodeWithoutHash ?>][]',
                                                maxCount: 1,
                                                rowHeight: '100px',
                                                groupClassName: 'col-md-4 col-sm-6 col-xs-4 color_code_bg_<?= $colorCodeWithoutHash ?>',
                                                maxFileSize: '',
                                                dropFileLabel: "Drop Here",
                                                allowedExt: '',
                                                // onExtensionErr : function(index, file){
                                                //     Swal.fire({icon: 'error',title: 'Oops...',text: 'Only png,jpg,jpeg file format allowed!'});
                                                // },
                                            });


                                            

                                        </script>

                                    <div id="color_image_<?php echo e($colorCodeWithoutHash); ?>_2" class="col-md-3 row"></div>



                                    <script>
                                        $('#color_image_<?= $colorCodeWithoutHash ?>_2').spartanMultiImagePicker({
                                            fieldName: 'color_image[<?= $colorCodeWithoutHash ?>][]',
                                            maxCount: 1,
                                            rowHeight: '100px',
                                            groupClassName: 'col-md-4 col-sm-6 col-xs-4 color_code_bg_<?= $colorCodeWithoutHash ?>',
                                            maxFileSize: '',
                                            dropFileLabel: "Drop Here",
                                            allowedExt: '',
                                            // onExtensionErr : function(index, file){
                                            //     Swal.fire({icon: 'error',title: 'Oops...',text: 'Only png,jpg,jpeg file format allowed!'});
                                            // },
                                        });


                                        

                                    </script>


                                    <div id="color_image_<?php echo e($colorCodeWithoutHash); ?>_3" class="col-md-3 row"></div>



                                    <script>
                                        $('#color_image_<?= $colorCodeWithoutHash ?>_3').spartanMultiImagePicker({
                                            fieldName: 'color_image[<?= $colorCodeWithoutHash ?>][]',
                                            maxCount: 1,
                                            rowHeight: '100px',
                                            groupClassName: 'col-md-4 col-sm-6 col-xs-4 color_code_bg_<?= $colorCodeWithoutHash ?>',
                                            maxFileSize: '',
                                            dropFileLabel: "Drop Here",
                                            allowedExt: '',
                                            // onExtensionErr : function(index, file){
                                            //     Swal.fire({icon: 'error',title: 'Oops...',text: 'Only png,jpg,jpeg file format allowed!'});
                                            // },
                                        });


                                        

                                    </script>


                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>


<?php else: ?>
    <p>No combinations available.</p>
<?php endif; ?>




<script src="js/spartan-multi-image-picker.min.js"></script>

<script>
    $(document).ready(function() {






        $('body').on('keyup', 'input[name^="product_attribute[regular_price]"]', function() {
            var inputId = $(this).attr('id');
            let row = inputId.split('-')[1];
            calculateSalePrice1(row);
        });


        $('body').on('keyup', 'input[name^="product_attribute[discount]"]', function() {
            var inputId = $(this).attr('id');
            let row = inputId.split('-')[1];
            calculateSalePrice1(row);
        });


        $('body').on('change', 'select[name^="product_attribute[discount_type]"]', function() {
            var inputId = $(this).attr('id');
            var row = inputId.split('-')[1];
            $('#discountValue-' + row).val(0);
            calculateSalePrice1(row);
        });


        $('.selectpicker').selectpicker('refresh');

    });


    function setUnitPrice(unitPrice) {

$('.unit_price_picker').val(unitPrice);

}

function setWholeSalePrice(unitPrice) {

$('.whole_sale_price_picker').val(unitPrice);

}


    function calculateSalePrice1(item) {

        let row = JSON.parse(item);
        console.log(row, 'inside function');

        var regular_price = parseFloat($('#product_attribute_' + row + '_regular_price').val());
        var discountType = ($('#product_attribute_' + row + '_discount_type').val());
        var discountValue = parseFloat($('#product_attribute_' + row + '_discount').val());



        if (isNaN(regular_price) || isNaN(discountValue)) {
            // $('#result').text("Please enter valid numbers.");
            return;
        }

        var salePrice = regular_price; // Initialize sale price with unit price

        if (discountType === 'percent') {
            salePrice = regular_price - (regular_price * (discountValue / 100));
        } else if (discountType === 'amount') {
            salePrice = regular_price - discountValue;
        }

        $('#product_attribute_' + row + '_sale_price').val(salePrice.toFixed(2));
    }



    $("#unit_price_apply_for_all").on("change", function() {
            if ($(this).is(":checked")) {
                $(".unit_price_picker").attr("oninput", "setUnitPrice(this.value)");

            } else {
                $(".unit_price_picker").removeAttr("oninput");


            }
        });


    $("#whole_sale_apply_for_all").on("change", function() {
            if ($(this).is(":checked")) {
                $(".whole_sale_price_picker").attr("oninput", "setWholeSalePrice(this.value)");

            } else {

                $(".whole_sale_price_picker").removeAttr("oninput");


            }
        });


</script>
<?php /**PATH /home/iconshoppercom/iconshopper/Modules/Product/Resources/views/sku_combinations.blade.php ENDPATH**/ ?>