<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="style.bundle.css">
    <title>Icon shopper</title>
    <style>
        * {
            font-size: 12px;
            font-family: 'Times New Roman';
        }

        td,
        th,
        tr,
        table {
            border-top: 1px solid black;
            border-collapse: collapse;
            text-align: center;
            width: 250px;
        }

        td.description,
        th.description {
            width: 75px;
            max-width: 75px;
        }

        td.quantity,
        th.quantity {
            width: 40px;
            max-width: 40px;
            word-break: break-all;
        }

        td.price,
        th.price {
            width: 40px;
            max-width: 40px;
            word-break: break-all;
        }

        .centered {
            text-align: center;
            align-content: center;
        }

        .ticket {
            width: 250px;
            max-width: 250px;
        }

        img {
            max-width: inherit;
            width: inherit;
        }

        .dashed-border {
            width: 100px;
            height: 2px;
            margin: 0 auto;
            padding: 0;
            border-top: 1px dashed #454d55 !important;
        }

        @media  print {

            .hidden-print,
            .hidden-print * {
                display: none !important;
            }
        }
    </style>
</head>

<body style="margin: 0% 0%;">
<button id="btnBack" class="hidden-print float-left"
        style="padding: 6px 20px; margin-left: 44%; background: #d90000;color: white;">Back To Pos
</button><button id="btnPrint" class="hidden-print float-right"
        style="padding: 6px 20px; margin-left: 1%; background: #034d97;color: white;">Print
</button>
<div>
    <?php
        date_default_timezone_set('Asia/Dhaka');
        $date = date('Y-m-d');
        $reference = date('Ymd');
        $date_time = date('Y-m-d h:i:s A');
    ?>
    <div class="ticket" style="margin: 0 auto;">
        <p class="centered" style="font-size: 18px;font-weight: 700;font-family: serif;">
            <?php echo e(config('settings.title') ? config('settings.title') : env('APP_NAME')); ?><br>
        <p class="centered" style="font-size: 15px;font-weight: 700;font-family: serif;">
            <?php if(Auth::user()->user_type == 1): ?>
                <?php echo e(config('settings.address')); ?>

            <?php else: ?>
                <?php
                    $showroom = DB::table('showrooms')->where('id', $sale->showroom_id)->first();
                ?>
                <?php echo e($showroom->address); ?>

            <?php endif; ?>
        </p>
        <p class="centered" style="font-size: 15px;font-weight: 700;font-family: serif;">Phone -
            <?php echo e(config('settings.contact_no')); ?></p>
        <p class="centered" style="font-size: 15px;font-weight: 700;font-family: serif;">Email -
            <?php echo e(config('settings.email')); ?></p>
        <div style="width: 100%;height:1px;border-top:1px solid rgb(0, 0, 0)"></div>

    </div>

    <div class="ticket" style="margin: 0 auto">
        <p style="text-align: center;font-size: 15px;margin:8px"><?php echo e($sale->invoice_no); ?>

            <b>Date:</b><?php echo e(date('d-M-Y', strtotime($sale->sale_date))); ?>

        </p>
        <div style="width: 95%;text-align:end;margin-bottom:2px">
            <img src="data:image/png;base64, <?php echo DNS1D::getBarcodePNG($sale->invoice_no, 'C128'); ?>" alt="<?php echo e($sale->invoice_no); ?>">
        </div>
        <div style="width: 100%;height:1px;border-top:1px solid rgb(0, 0, 0)"></div>
        <?php if(isset($sale->customer->name)): ?>
            <p style="text-align: center;font-size: 15px;margin:8px">Billed To - <?php echo e($sale->customer->name); ?></p>
        <?php endif; ?>
        <?php if(isset($sale->customer->mobile)): ?>
            <p style="text-align: center;font-size: 15px;margin:8px">Phone - <?php echo e($sale->customer->mobile); ?></p>
        <?php endif; ?>

        <?php if(isset($sale->customer->address)): ?>
            <p style="text-align: center;font-size: 15px;margin:8px">Address - <?php echo e($sale->customer->address); ?></p>
        <?php endif; ?>
    </div>

    <div class="ticket" style="margin: 0 auto;">
        <table class="table">
            <thead>
                <tr>
                    <th scope="col">Product</th>
                    <th scope="col">Price</th>
                    <th scope="col">Qty</th>
                    <th scope="col">Discount</th>
                    <th scope="col">Amount</th>
                </tr>
            </thead>
            <tbody>
            <?php if(!$sale->products->isEmpty()): ?>
                <?php $__currentLoopData = $sale->products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $unit_name = '';
                        if ($item->sale_unit_id) {
                            $unit_name = DB::table('units')
                                ->where('id', $item->pivot->sale_unit_id)
                                ->value('unit_name');
                        }
                    ?>
                    <?php
                        $productCode = '';
                        if (!empty($item->pivot->variant_id)) {
                            $variant = DB::table('product_variants as pv')
                                ->where('pv.product_id', $item->id)
                                ->where('pv.product_code', $item->pivot->product_code)
                                ->first();

                            $color = '';
                            if (!empty($variant->color_id)) {
                                $colorObj = DB::table('colors')
                                    ->where('id', $variant->color_id)
                                    ->first('name');
                                $color = $colorObj->name . '-';
                            }

                            $attributes = '';
                            if (!empty($variant->variant_id)) {
                                $attributeArr = array_filter(explode('-', $variant->variant_id));

                                foreach ($attributeArr as $attributeKey => $attributeValue) {
                                    $variantValue = DB::table('attribute_values')
                                        ->where('id', $attributeValue)
                                        ->first('value');
                                    if ($variantValue) {
                                        if ($attributeKey != 0) {
                                            $attributes .= '-' . $variantValue->value;
                                        } else {
                                            $attributes = $variantValue->value;
                                        }
                                    }
                                }
                            }
                            $productCode = $color . '' . $attributes;
                        } else {
                            $productCode = $item->product_code;
                        }
                    ?>
                    <tr>
                        <td style="font-size: 10px"><?php echo e($item->product_name); ?>, <?php echo e($item->pivot->product_code); ?> ,<?php echo e($productCode); ?></td>
                        <td><?php echo e(number_format($item->pivot->net_unit_price, 2)); ?></td>
                        <td><?php echo e($item->pivot->qty . ' ' . $unit_name); ?></td>
                        <td><?php echo e(number_format($item->pivot->discount, 2)); ?></td>
                        <td><?php echo e(number_format($item->pivot->total, 2)); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
            </tbody>
        </table>
    </div>

    <div class="ticket" style="margin: 0 auto;">
        <p style="text-align: end;font-size: 15px;"> Total -
            <?php if(config('settings.currency_position') == 2): ?>
                <?php echo e(number_format($sale->total_price, 2, '.', ',')); ?>

                <?php echo e(config('settings.currency_symbol')); ?>

            <?php else: ?>
                <?php echo e(config('settings.currency_symbol')); ?>

                <?php echo e(number_format($sale->total_price, 2, '.', ',')); ?>

            <?php endif; ?>
        </p>
        <p style="text-align: end;font-size: 15px;margin:4px">
            Discount - <?php if($sale->order_discount_per == 2): ?>
                <?php echo e($sale->order_discount ? $sale->order_discount : '0'); ?>%
            <?php else: ?>
                <?php echo e($sale->order_discount ? $sale->order_discount : '00'); ?> TK
            <?php endif; ?>
        </p>
        <p style="text-align: end;font-size: 15px;margin:4px"> Tax -
            <?php if(config('settings.currency_position') == 2): ?>
                <?php if($sale->order_discount_per == 1): ?>
                    <?php echo e(config('settings.currency_symbol')); ?>

                <?php endif; ?>
                <?php echo e(number_format($sale->order_tax, 2, '.', ',')); ?>

            <?php else: ?>
                <?php if($sale->order_discount_per == 1): ?>
                    <?php echo e(config('settings.currency_symbol')); ?>

                <?php endif; ?>
                <?php echo e(number_format($sale->order_tax, 2, '.', ',')); ?>

            <?php endif; ?>
        </p>
        <p style="text-align: end;font-size: 15px;margin:4px">Use Point - <?php echo e($sale->use_point ?? 0); ?></p>
        <p style="text-align: end;font-size: 15px;margin:4px">Point Amount -
            <?php if(config('settings.currency_position') == 2): ?>
                <?php echo e(number_format($sale->point_amount, 2, '.', ',')); ?>

                <?php echo e(config('settings.currency_symbol')); ?>

            <?php else: ?>
                <?php echo e(config('settings.currency_symbol')); ?>

                <?php echo e(number_format($sale->point_amount, 2, '.', ',')); ?>

            <?php endif; ?>
        </p>

        <?php if(!empty($sale->card_number)): ?>
        <p style="text-align: end;font-size: 15px;margin:4px">Gift Card Amount -
            <?php if(config('settings.currency_position') == 2): ?>
                <?php echo e(number_format($sale->use_balance, 2, '.', ',')); ?>

                <?php echo e(config('settings.currency_symbol')); ?>

            <?php else: ?>
                <?php echo e(config('settings.currency_symbol')); ?>

                <?php echo e(number_format($sale->use_balance, 2, '.', ',')); ?>

            <?php endif; ?>
        </p>
        <?php endif; ?>
        <p style="text-align: end;font-size: 15px;margin-bottom:2px">Grand Total -
            <?php if(config('settings.currency_position') == 2): ?>
                <?php echo e(number_format($sale->grand_total, 2, '.', ',')); ?>

                <?php echo e(config('settings.currency_symbol')); ?>

            <?php else: ?>
                <?php echo e(config('settings.currency_symbol')); ?>

                <?php echo e(number_format($sale->grand_total, 2, '.', ',')); ?>

            <?php endif; ?>
        </p>

        <div style="width: 100%;height:1px;border-top:2px solid rgb(0, 0, 0)"></div>

        <p style="text-align: end;font-size: 15px;margin:2px"> Net Total -
            <?php if(config('settings.currency_position') == 2): ?>
                <?php echo e(number_format($sale->net_total, 2, '.', ',')); ?>

                <?php echo e(config('settings.currency_symbol')); ?>

            <?php else: ?>
                <?php echo e(config('settings.currency_symbol')); ?>

                <?php echo e(number_format($sale->net_total, 2, '.', ',')); ?>

            <?php endif; ?>
        </p>
        <p style="text-align: end;font-size: 15px;margin:4px"> Paid Amount -
            <?php if(config('settings.currency_position') == 2): ?>
                <?php echo e(number_format($sale->paid_amount, 2, '.', ',')); ?>

                <?php echo e(config('settings.currency_symbol')); ?>

            <?php else: ?>
                <?php echo e(config('settings.currency_symbol')); ?>

                <?php echo e(number_format($sale->paid_amount, 2, '.', ',')); ?>

            <?php endif; ?>
        </p>
        <p style="text-align: end;font-size: 15px;margin:4px"> Due Amount -
            <?php if(config('settings.currency_position') == 2): ?>
                <?php echo e(number_format($sale->due_amount, 2, '.', ',')); ?>

                <?php echo e(config('settings.currency_symbol')); ?>

            <?php else: ?>
                <?php echo e(config('settings.currency_symbol')); ?>

                <?php echo e(number_format($sale->due_amount, 2, '.', ',')); ?>

            <?php endif; ?>
        </p>
        <p style="text-align: end;font-size: 15px;margin:4px">Payment Status -
            <?php echo e(PAYMENT_STATUS[$sale->payment_status]); ?></p>
        <div style="width: 100%;height:3px;border-top:1px solid rgb(0, 0, 0)"></div>

        <?php if(isset($sale->payments)): ?>
            <?php $__currentLoopData = $sale->payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <p style="text-align: end;font-size: 15px;margin:4px">
                    <?php echo e(SALE_PAYMENT_METHOD[$payment->payment_method]); ?>

                    (<?php echo e($payment->coa->name); ?>)
                    - <?php echo e($payment->paid_amount); ?> Tk
                </p>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
        <div style="width: 100%;height:1px;border-top:1px solid rgb(0, 0, 0)"></div>
        <?php if(isset($sale->notes)): ?>
            <p style="text-align: end;font-size: 15px;"> Note -
                <?php echo e($sale->notes); ?>

            </p>
        <?php endif; ?>

        <p style="text-align: center;font-size: 15px;">Item sold will not be returned. <br> Exchange will be executed Between 7 days with good
            condition of product with Money receipt. <br> Thanks for allowing us to serve you.</p>
        <div style="width: 100%;height:1px;border-top:1px solid rgb(0, 0, 0)"></div>
        <p style="text-align: center;font-size: 15px;">For more information please visit -
            <a href="https://www.iconshopper.com/" target="_blank"> www.iconshopper.com</a>
        </p>
    </div>

    <div class="ticket" style="margin: 0 auto;">
        <table class="table" style="width: 104%">
            <tr>
                <td>
                    <div>
                        <p><b class="text-uppercase"><?php echo e($sale->user ? $sale->user->name : ''); ?></b><br>
                            <?php echo e(date('d-M-Y h:i:s A', strtotime($sale->created_at))); ?></p>
                        <p class="dashed-border"></p>
                        <p style="margin:0;padding:0;">Generated By</p>
                    </div>
                </td>
                <td class="float-right">
                    <div style="margin-top: 44%">
                        <p><b><?php echo e($sale->salesman ? $sale->salesman->name : ''); ?></b></p>
                        <p class="dashed-border"></p>
                        <p style="margin:0;padding:0;">Served By</p>
                    </div>
                </td>
            </tr>
        </table>
    </div>
</div>

<script src="script.js"></script>
<script>
    const $btnPrint = document.querySelector("#btnPrint");
    $btnPrint.addEventListener("click", () => {
        window.print();
    });

    const $btnBack = document.querySelector("#btnBack");
    $btnBack.addEventListener("click", () => {
        window.location.href = "<?php echo e(route('pos')); ?>";
    });
</script>
</body>

</html>
<?php /**PATH /home/iconshoppercom/iconshopper/Modules/Sale/Resources/views/pos-invoice.blade.php ENDPATH**/ ?>