
<?php $__env->startSection('title', $page_title); ?>
<?php $__env->startPush('styles'); ?>
    <link href="<?php echo e(asset('css/bootstrap-datetimepicker.min.css')); ?>" rel="stylesheet" type="text/css"/>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <div class="d-flex flex-column-fluid">
        <div class="container-fluid">
            <div class="card card-custom gutter-b">
                <div class="card-header flex-wrap py-5">
                    <div class="card-title">
                        <h3 class="card-label"><i class="<?php echo e($page_icon); ?> text-primary"></i> <?php echo e($sub_title); ?></h3>
                    </div>
                    <div class="card-toolbar"><a href="<?php echo e(route('stock.transfer')); ?>"
                                                 class="btn btn-warning btn-sm font-weight-bolder"><i
                                class="fas fa-arrow-left"></i><?php echo e('Back'); ?></a></div>
                </div>
            </div>
            <div class="card card-custom" style="padding-bottom: 100px !important;">
                <div class="card-body">
                    <form id="transfer_form" method="post" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <input type="hidden" name="transfer_id" value="<?php echo e($edit->id); ?>"/>
                            <div class="col-md-4 form-group">
                                <label for="transfer_date"><?php echo e('Return Date'); ?></label>
                                <input type="date" class="form-control" id="transfer_date" name="transfer_date"
                                       value="<?php echo e($edit->sale_date); ?>"/>
                            </div>

                            <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.form.selectbox','data' => ['labelName' => 'Receive Showroom','name' => 'receive_showroom_id','id' => 'receive_showroom_id','required' => 'required','col' => 'col-md-4','class' => 'selectpicker']]); ?>
<?php $component->withName('form.selectbox'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes(['labelName' => 'Receive Showroom','name' => 'receive_showroom_id','id' => 'receive_showroom_id','required' => 'required','col' => 'col-md-4','class' => 'selectpicker']); ?>
                                <?php if(!$showrooms->isEmpty()): ?>
                                    <?php $__currentLoopData = $showrooms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($value->id); ?>" ><?php echo e($value->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>

                            <div class="col-md-4 form-group">
                                <label for="transfer_warehouse_id "><?php echo e('Franchises Showroom'); ?></label>
                                <select class="form-control transfer_warehouse_id" id="transfer_warehouse_view">
                                    <option value=""><?php echo e('Please Select'); ?></option>
                                    <?php $__currentLoopData = $showrooms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($value->id); ?>" <?php if($value->id == $edit->transfer_warehouse_id): ?> selected="selected" <?php endif; ?>><?php echo e($value->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <input type="hidden" id="transfer_warehouse_id" name="transfer_warehouse_id"
                                       value="<?php echo e($edit->transfer_warehouse_id); ?>"/>
                            </div>

                        </div>
                        <div class="row">
                            <div class="col-md-12 pb-5">
                                <table class="table table-bordered" id="stock-transfer-table">
                                    <thead class="bg-primary">
                                    <tr class="text-center">
                                        <th width="20%"><?php echo e('Name'); ?></th>
                                        <th width="20%"><?php echo e('SKU'); ?></th>
                                        <th width="20%"><?php echo e('Stock Qty'); ?></th>
                                        <th width="20%"><?php echo e('Return Qty'); ?></th>
                                        <th width="20%"><?php echo e('Receive Qty'); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php if(isset($edit) && !$edit->stockTransferWarehouseProductList->isEmpty()): ?>
                                        <?php $__currentLoopData = $edit->stockTransferWarehouseProductList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $qty = \Modules\ShowroomProduct\Entities\ShowroomProduct::where(['Showroom_id' => $edit->transfer_warehouse_id, 'product_id' => $value->product_id, 'product_code' => $value->product_code])->firstOrFail();

                                                $variationName = '';
                                                if ($value->type == 1) {
                                                    $variationData = \Illuminate\Support\Facades\DB::table('product_variants')
                                                        ->where('product_code', $value->product_code)
                                                        ->first('product_variant_name');
                                                    $variationName = '-' . $variationData->product_variant_name;
                                                }
                                            ?>
                                            <tr class="text-center">
                                                <td>
                                                    <input type="hidden"
                                                           id="transfer_<?php echo e($key); ?>_product_code"
                                                           name="transfer[<?php echo e($key); ?>][product_code]"
                                                           value="<?php echo e($value->product_code); ?>"/>

                                                    <input type="hidden" id="transfer_<?php echo e($key); ?>_type"
                                                           name="transfer[<?php echo e($key); ?>][type]"
                                                           value="<?php echo e($value->type); ?>"/>

                                                    <input type="text" class="form-control bg-primary text-white"
                                                           id="transfer_<?php echo e($key); ?>_product_name"
                                                           value="<?php echo e($value->product->product_name . '' . $variationName); ?>"
                                                           readonly/>

                                                    <input type="hidden"
                                                           id="transfer_<?php echo e($key); ?>_product_id"
                                                           name="transfer[<?php echo e($key); ?>][product_id]"
                                                           value="<?php echo e($value->product_id); ?>"/>
                                                </td>

                                                <td><input type="text" class="form-control bg-primary text-white" id="transfer_<?php echo e($key); ?>_unit_name" value="<?php echo e($value->product->sku); ?>" readonly/></td>
                                                <input type="text" class="form-control bg-primary text-white d-none" id="transfer_<?php echo e($key); ?>_unit_name" value="<?php echo e($value->product->unit->unit_code); ?>" readonly/>

                                                <td><input type="text" class="form-control bg-primary text-white"
                                                           id="transfer_<?php echo e($key); ?>_stock_qty"
                                                           value="<?php echo e($qty->qty); ?>" readonly/></td>

                                                <td><input type="text" class="form-control qty"
                                                           id="transfer_<?php echo e($key); ?>_qty"
                                                           data-stock_qty="transfer_<?php echo e($key); ?>_stock_qty"
                                                           value="<?php echo e($value->qty - $value->receive_qty); ?>"/></td>

                                                <td><input type="text" class="form-control receive_qty"
                                                           id="transfer_<?php echo e($key); ?>_receive_qty"
                                                           data-stock_qty="transfer_<?php echo e($key); ?>_stock_qty" data-qty="transfer_<?php echo e($key); ?>_qty"
                                                           name="transfer[<?php echo e($key); ?>][receive_qty]"
                                                           value="<?php echo e($value->qty - $value->receive_qty); ?>"/></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                    </tbody>
                                    <tfoot>
                                    <tr>
                                        <td></td>
                                        <td colspan="3">
                                            <button type="button"
                                                    class="text-right btn btn-primary btn-block"><b><?php echo e('Total Quantity'); ?></b></button>
                                        </td>
                                        <td>
                                            <button type="button" class="text-left btn btn-primary btn-block"><input
                                                    type="hidden" id="total_qty" name=""
                                                    value="<?php echo e($edit->total_qty); ?>"/> <b><span
                                                        id="total_qty_show"><?php echo e($edit->total_qty); ?></span></b></button>
                                        </td>
                                    </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                        <div class="row pt-5">
                            <div class="form-group col-md-12 text-center px-0">
                                <button type="button" class="btn btn-primary btn-sm mr-3" id="save-btn"
                                        onclick="transferUpdateData()"><i
                                        class="fas fa-save"></i><?php echo e('Submit'); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('js/bootstrap-datetimepicker.min.js')); ?>"></script>
    <script type="text/javascript">
        <?php if(!empty($edit)): ?>
        transferItem();
        <?php endif; ?>
        function _(x) {
            return document.getElementById(x);
        }

        function transferItem() {
            $('#transfer_item_view').addClass('bg-primary text-white');
            $('#transfer_item_view').prop("disabled", true);
            $('#transfer_warehouse_view').addClass('bg-primary text-white');
            $('#transfer_warehouse_view').prop("disabled", true);
        }

        $(document).on('input', '.receive_qty', function () {
            let stockQty = parseFloat(_($(this).data('stock_qty')).value);
            let qty = parseFloat(_($(this).data('qty')).value);
            let value = $(this).val();
            if (qty < value) {
                $(this).val('');
                notification('error', 'Receive Quantity Can\'t Be Greater Then Availabe Receive Quantity');
            }
            if (stockQty < value) {
                $(this).val('');
                notification('error', 'Receive Quantity Can\'t Be Greater Then Stock Quantity');
            }
            calculation();
        })

        function calculation() {
            let qty = 0;
            $('.receive_qty').each(function () {
                if ($(this).val() == '') {
                    qty += +0;
                } else {
                    qty += +$(this).val();
                }
            });
            _('total_qty').value = qty;
            _('total_qty_show').innerText = qty;
        }

        function transferUpdateData() {
            let form = _('transfer_form');
            let formData = new FormData(form);
            let url = "<?php echo e(route('franchises.receive.return.stock.receiveStock')); ?>";
            $.ajax({
                url: url,
                type: "POST",
                data: formData,
                dataType: "JSON",
                contentType: false,
                processData: false,
                cache: false,
                beforeSend: function () {
                    $('#save-btn').addClass('spinner spinner-white spinner-right');
                },
                complete: function () {
                    $('#save-btn').removeClass('spinner spinner-white spinner-right');
                },
                success: function (data) {
                    $('#transfer_form').find('.is-invalid').removeClass('is-invalid');
                    $('#transfer_form').find('.error').remove();
                    if (data.status == false) {
                        $.each(data.errors, function (key, value) {
                            var key = key.split('.').join('_');
                            $('#transfer_form input#' + key).addClass('is-invalid');
                            $('#transfer_form textarea#' + key).addClass('is-invalid');
                            $('#transfer_form select#' + key).parent().addClass('is-invalid');
                            $('#transfer_form #' + key).parent().append(
                                '<small class="error text-danger">' + value + '</small>');
                        });
                    } else {
                        notification(data.status, data.message);
                        if (data.status == 'success') {
                            window.location.replace("<?php echo e(route('franchises.return.receive')); ?>");
                        }
                    }
                },
                error: function (xhr, ajaxOption, thrownError) {
                    console.log(thrownError + '\r\n' + xhr.statusText + '\r\n' + xhr.responseText);
                }
            });
        }

        $(document).ready(function () {
        });


    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iconshoppercom/iconshopper/Modules/Franchises/Resources/views/return-receive/create.blade.php ENDPATH**/ ?>