<?php
    use Illuminate\Support\Facades\DB;
?>
<?php if(!$products->isEmpty()): ?>

    <?php for($i = 0; $i < ceil(count($products) / 2); $i++): ?>
        <tr>
            <td width="50%" style="cursor: pointer;" class="product-img sound-btn text-center"
                title="<?php echo e($products[0 + $i * 2]->product_name); ?>"
                data-product="<?php echo e($products[0 + $i * 2]->product_code . ' (' . $products[0 + $i * 2]->product_name . ')'); ?>">
                <?php
                    $thisProductImage = $products[0 + $i * 2]->image;
                    $thisProductPrice = $products[0 + $i * 2]->sale_price;
                    $thisProductSku = $products[0 + $i * 2]->sku;
                    $thisProductQty = $products[0 + $i * 2]->product_variation_status == 0 ? $products[0 + $i * 2]->qty : $products[0 + $i * 2]->total_stock;

                    $thisProductCode = $products[0 + $i * 2]->product_code;
                    $hasVariant = 0;
                    $firstVariantId = null;
                    if ($products[0 + $i * 2]->product_variation_status == 1) {
                        $hasVariant = 1;
                        $firstVariant = DB::table('product_variants as pv')
                            ->where('pv.product_id', $products[0 + $i * 2]->id)
                            ->orderBy('id', 'asc')
                            ->first();
                        $thisProductPrice = $firstVariant->sale_price;
                        $thisProductCode = $firstVariant->product_code;
                        $firstVariantId = $firstVariant->id;
                    }
                ?>
                <?php if($thisProductImage[0]): ?>
                    <img src="<?php echo e(asset('storage/' . PRODUCT_IMAGE_PATH . $thisProductImage[0])); ?>"
                        style="width:100%;height:200px;" />
                <?php else: ?>
                    <img src="<?php echo e(asset('images/product.svg')); ?>" style="width:100%;height:200px;">
                <?php endif; ?>
                <br>
                <br>
                <p style="font-size:10px; font-weight: 600; "><?php echo $products[0 + $i * 2]->product_name; ?></p>
                <span class="text-primary font-weight-bold"><?php echo e($products[0 + $i * 2]->product_code ?? '-'); ?></span>
                <br>
                <br>
                <table align="center">
                    <tr>
                        <td>Price</td>
                        <td>:</td>
                        <td><?php echo e($thisProductPrice); ?>

                            <input type="hidden" readonly name=""
                                id="cart_<?php echo e($products[0 + $i * 2]->id); ?>_price" class="form-control"
                                value="<?php echo e($thisProductPrice); ?>"></td>
                    </tr>
                    <tr>
                        <td>Stock</td>
                        <td>:</td>
                        <td><?php echo e($thisProductQty); ?>

                            <input type="hidden" readonly name=""
                                id="cart_<?php echo e($products[0 + $i * 2]->id); ?>_stock" class="form-control"
                                value="<?php echo e($thisProductQty); ?>"></td>
                    </tr>
                </table>
                <br>
                <?php if($products[0 + $i * 2]->product_variation_status == 1): ?>
                    <?php


                        $variants = $products[0 + $i * 2]->variations;

                        foreach ($variants as $key => $value) {
                            $attributes = '';
                            $color = '';

                            if (!empty($value->color_id)) {
                                $colorData = DB::table('colors')
                                    ->where(['id' => $value->color_id])
                                    ->first('name');
                                if ($colorData) {
                                    $color = $colorData->name;
                                }
                            }

                            $variant = '';
                            if ($value->variant_id) {
                                $attributeArray = array_filter(explode('-', $value->variant_id));

                                foreach ($attributeArray as $attributeKey => $attributeValue) {
                                    $variantValue = DB::table('attribute_values')
                                        ->where('id', $attributeValue)
                                        ->first('value');
                                    if ($variantValue) {
                                        if ($attributeKey != 0) {
                                            $variant .= '-' . $variantValue->value;
                                        } else {
                                            $variant = $variantValue->value;
                                        }
                                    }
                                }
                            }

                            $attributes = $color . '-' . $variant;
                            $value->variantBatch = $attributes;
                        }
                    ?>

                    <p style="font-size:10px; font-weight: 600; margin-bottom: 0px; ">SKU</p>
                    <button class=" btn btn-secondary btn-sm rounded " type="button" style="padding : 2px; margin: 1px;" >
                        <?php echo e($thisProductSku); ?>

                    </button>

                    <br>



                    <?php if(isset($variants)): ?>
                        <p style="font-size:10px; font-weight: 600; margin-bottom: 0px;">Stocks</p>

                        <?php $__currentLoopData = $variants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <button type="button" class="btn btn-secondary btn-sm rounded"
                                    style="padding: 2px; margin: 1px; "><?php echo e($v_item->variantBatch); ?>:<?php echo e($v_item->qty); ?>

                            </button>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>

                    <br>
                    <br>

                    <select name="" id="cart_<?php echo e($products[0 + $i * 2]->id); ?>_variation"
                            class="form-control selectpicker" data-live-search="true"
                            data-product_id="<?php echo e($products[0 + $i * 2]->id); ?>"
                            onchange="setProductPriceStock(<?php echo e($products[0 + $i * 2]->id); ?>, this);">
                        <?php $__currentLoopData = $variants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($item->attribute_id); ?>"
                                    data-stock="<?php echo e($item->qty); ?>"
                                    data-price="<?php echo e($item->sale_price); ?>"
                                    data-product_code="<?php echo e($item->product_code); ?>"
                            ><?php echo e($item->variantBatch); ?> &nbsp; <span
                                    style="background-color:red">৳</span>
                                <?php echo e($item->sale_price); ?>/= &nbsp; st(<?php echo e($item->qty); ?>)
                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <br>
                    <br>
                <?php else: ?>
                    <div style="padding: 70px;"></div>
                <?php endif; ?>
                <button align="center" type="button" class="btn <?php if($thisProductQty > 0): ?> btn-primary <?php else: ?> btn-danger <?php endif; ?> btn-sm rounded"
                        id="cart_<?php echo e($products[0 + $i * 2]->id); ?>_btn" onclick="product_search_click(this)"
                        data-product_qty="<?php echo e($thisProductQty); ?>"
                        data-product_code="<?php echo e($thisProductCode); ?>" data-variant="<?php echo e($hasVariant); ?>"
                        data-product_id="<?php echo e($products[0 + $i * 2]->id); ?>" data-variant_id="<?php echo e($firstVariantId); ?>"><i
                        class="fas fa-cart-plus"></i></button>
                <br>
                <br>

            </td>
            <?php if(!empty($products[1 + $i * 2])): ?>
                <td width="50%" style="cursor: pointer;" class="product-img sound-btn text-center"
                    title="<?php echo e($products[1 + $i * 2]->product_name); ?>"
                    data-product="<?php echo e($products[1 + $i * 2]->product_code . ' (' . $products[1 + $i * 2]->product_name . ')'); ?>">
                    <?php
                        $thisProductImage = $products[1 + $i * 2]->image;
                        $thisProductPrice = $products[1 + $i * 2]->sale_price;
                        $thisProductSku = $products[1 + $i * 2]->sku;
                        $thisProductQty = $products[1 + $i * 2]->product_variation_status == 0 ? $products[1 + $i * 2]->qty : $products[1 + $i * 2]->total_stock;

                        $thisProductCode = $products[1 + $i * 2]->product_code;
                        $hasVariant = 0;
                        $firstVariantId = null;
                        if ($products[1 + $i * 2]->product_variation_status == 1) {
                            $hasVariant = 1;
                            $firstVariant = DB::table('product_variants as pv')
                                ->where('pv.product_id', $products[1 + $i * 2]->id)
                                ->orderBy('id', 'asc')
                                ->first();
                            $thisProductPrice = $firstVariant->sale_price;
                            $thisProductCode = $firstVariant->product_code;
                            $firstVariantId = $firstVariant->id;
                        }
                    ?>
                    <?php if($thisProductImage[0]): ?>
                        <img src="<?php echo e(asset('storage/' . PRODUCT_IMAGE_PATH . $thisProductImage[0])); ?>"
                            style="width:100%;height:200px;" />
                    <?php else: ?>
                        <img src="<?php echo e(asset('images/product.svg')); ?>" style="width:100%;height:200px;">
                    <?php endif; ?>
                    <br>
                    <br>

                    <p style="font-size:10px ; font-weight: 600;"><?php echo $products[1 + $i * 2]->product_name; ?></p>
                    <span class="text-primary font-weight-bold"><?php echo e($products[1 + $i * 2]->product_code ?? '-'); ?></span>
                    <br>
                    <br>
                    <table align="center">
                        <tr>
                            <td>Price</td>
                            <td>:</td>
                            <td><?php echo e($thisProductPrice); ?>

                                <input type="hidden" readonly name=""
                                    id="cart_<?php echo e($products[1 + $i * 2]->id); ?>_price" class="form-control"
                                    value="<?php echo e($thisProductPrice); ?>"></td>
                        </tr>
                        <tr>
                            <td>Stock</td>
                            <td>:</td>
                            <td><?php echo e($thisProductQty); ?>

                                <input type="hidden" readonly name=""
                                    id="cart_<?php echo e($products[1 + $i * 2]->id); ?>_stock" class="form-control"
                                    value="<?php echo e($thisProductQty); ?>"></td>
                        </tr>
                    </table>
                    <br>
                    <?php if($products[1 + $i * 2]->product_variation_status == 1): ?>
                        <?php


                           $variants = $products[1 + $i * 2]->variations;

                            foreach ($variants as $key => $value) {
                                $attributes = '';
                                $color = '';

                                if (!empty($value->color_id)) {
                                    $colorData = DB::table('colors')
                                        ->where(['id' => $value->color_id])
                                        ->first('name');
                                    if ($colorData) {
                                        $color = $colorData->name;
                                    }
                                }

                                $variant = '';
                                if ($value->variant_id) {
                                    $attributeArray = array_filter(explode('-', $value->variant_id));

                                    foreach ($attributeArray as $attributeKey => $attributeValue) {
                                        $variantValue = DB::table('attribute_values')
                                            ->where('id', $attributeValue)
                                            ->first('value');
                                        if ($variantValue) {
                                            if ($attributeKey != 0) {
                                                $variant .= '-' . $variantValue->value;
                                            } else {
                                                $variant = $variantValue->value;
                                            }
                                        }
                                    }
                                }

                                $attributes = $color . '-' . $variant;
                                $value->variantBatch = $attributes;
                            }
                        ?>


                        <p style="font-size:10px; font-weight: 600; margin-bottom: 0px; ">SKU</p>
                        <button class=" btn btn-secondary btn-sm rounded " type="button" style="padding : 2px; margin: 1px;" >
                            <?php echo e($thisProductSku); ?>

                        </button>

                        <br>


                    <?php if(isset($variants)): ?>
                            <p style="font-size:10px; font-weight: 600; margin-bottom: 0px;">Stocks</p>

                            <?php $__currentLoopData = $variants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <button type="button" class="btn btn-secondary btn-sm rounded"
                                        style="padding: 2px; margin: 1px; "><?php echo e($v_item->variantBatch); ?>

                                    :<?php echo e($v_item->qty); ?>

                                </button>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                        <br>
                        <br>

                        <select name="" id="cart_<?php echo e($products[1 + $i * 2]->id); ?>_variation"
                                class="form-control selectpicker" data-live-search="true"
                                data-product_id="<?php echo e($products[1 + $i * 2]->id); ?>"
                                onchange="setProductPriceStock(<?php echo e($products[1 + $i * 2]->id); ?>, this);">
                            <?php $__currentLoopData = $variants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($item->attribute_id); ?>"
                                        data-stock="<?php echo e($item->qty); ?>"
                                        data-price="<?php echo e($item->sale_price); ?>"
                                        data-product_code="<?php echo e($item->product_code); ?>"

                                ><?php echo e($item->variantBatch); ?> &nbsp; [ <span
                                        style="color:red">৳</span>
                                    <?php echo e($item->sale_price); ?>/= &nbsp; st(<?php echo e($item->qty); ?>) ]
                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <br>
                        <br>
                    <?php else: ?>
                        <div style="padding: 70px;"></div>
                    <?php endif; ?>
                    <button align="center" type="button" class="btn <?php if($thisProductQty > 0): ?> btn-primary <?php else: ?> btn-danger <?php endif; ?> btn-sm rounded"
                    id="cart_<?php echo e($products[1 + $i * 2]->id); ?>_btn" onclick="product_search_click(this)"
                            data-product_qty="<?php echo e($thisProductQty); ?>"
                        data-product_code="<?php echo e($thisProductCode); ?>" data-variant="<?php echo e($hasVariant); ?>"
                        data-product_id="<?php echo e($products[1 + $i * 2]->id); ?>" data-variant_id="<?php echo e($firstVariantId); ?>"><i
                            class="fas fa-cart-plus"></i></button>
                    <br>
                    <br>

                </td>
            <?php else: ?>
                <td style="border:none;"></td>
            <?php endif; ?>

        </tr>
    <?php endfor; ?>
         <tr>
            <td colspan="2" class="text-center">
                <div class="col-md-12 d-flex justify-content-center pt-5">
                    <?php echo e($products->onEachSide(2)->links()); ?>

                    <input type="hidden" product_name="hidden_page" class="form-control" id="hidden_page"
                        value="1" />
                </div>
            </td>
        </tr>
 <?php endif; ?>
<?php /**PATH /home/iconshoppercom/iconshopper/Modules/Sale/Resources/views/pos-product-list.blade.php ENDPATH**/ ?>