

<?php $__env->startSection('title', $page_title); ?>

<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-tagsinput/0.8.0/bootstrap-tagsinput.css" crossorigin="anonymous">
    <style>
        .tagsinput {
            height: calc(1.5em + 1.3rem + 2px) !important;
        }

        .bootstrap-tagsinput .tag {
            margin-right: 2px;
            margin-top: 0px;
            padding: 3px 6px;
            color: white;
            font-size: 12px;
            font-weight: 700;
            border-radius: 0.375rem;
        }

        .bootstrap-tagsinput {
            width: 100%;
        }

        .label {
            height: auto;
            width: auto;
        }

        select {
            width: 100%;
            min-height: 100px;
            border-radius: 3px;
            border: 1px solid #444;
            padding: 10px;
            color: #444444;
            font-size: 14px;
        }

        .select2-container--bootstrap4 .select2-selection--multiple .select2-search__field {
            color: #495057;
            height: 25px;
        }

        .select2-container--bootstrap4 .select2-selection--multiple .select2-selection__choice {
            background: #8950FC;
            padding: 3px 3px !important;
            color: white !important;
        }

        .bootstrap-tagsinput {
            height: 36px !important;
        }
    </style>

    <!-- select2 -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/css/select2.min.css" rel="stylesheet"/>

    <!-- select2-bootstrap4-theme -->
    <link href="https://raw.githack.com/ttskch/select2-bootstrap4-theme/master/dist/select2-bootstrap4.css" rel="stylesheet"> <!-- for live demo page -->
    <link href="select2-bootstrap4.css" rel="stylesheet"> <!-- for local development env -->
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="d-flex flex-column-fluid">
        <div class="container-fluid">
            <!--begin::Notice-->
            <div class="card card-custom gutter-b">
                <div class="card-header flex-wrap py-5">
                    <div class="card-title">
                        <h3 class="card-label"><i class="<?php echo e($page_icon); ?> text-primary"></i> <?php echo e($sub_title); ?></h3>
                    </div>
                    <div class="card-toolbar">
                        <!--begin::Button-->
                        <a href="<?php echo e(route('product')); ?>" class="btn btn-warning btn-sm font-weight-bolder">
                            <i class="fas fa-arrow-left"></i> Back</a>
                        <!--end::Button-->
                    </div>
                </div>
            </div>
            <!--end::Notice-->

            <!--begin::Card-->
            <form class="form form-horizontal mar-top" action="" method="POST" enctype="multipart/form-data" id="store_or_update_form">
                <?php echo csrf_field(); ?>
                <div class="row gutters-5">
                    <div class="col-lg-9">
                        <input type="hidden" name="added_by" value="admin">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="mb-0 h6">Product Information</h5>
                            </div>
                            <div class="card-body">
                                <div class="form-group row">
                                    <label class="col-md-3 col-from-label">Product Name<span class="text-danger">*</span></label>
                                    <div class="col-md-8">
                                        <input type="text" class="form-control" name="product_name" id="product_name" placeholder="Product Name" onchange="update_sku()" required>
                                    </div>
                                </div>
                                <div class="form-group row" id="brand">
                                    <label class="col-md-3 col-from-label"><?php echo e(('Barcode Symbology')); ?> <span class="text-danger">*</span></label>
                                    <div class="col-md-8">
                                        <select class="form-control selectpicker" name="barcode_symbol" id="barcode_symbology" data-live-search="true">
                                            <option value=""><?php echo e(('Barcode Symbology')); ?></option>
                                            <?php $__currentLoopData = BARCODE_SYMBOL; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($key); ?>" <?php echo e(($key == 1) ? 'selected' : ''); ?>><?php echo e($value); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group row" id="category">
                                    <label class="col-md-3 col-from-label">Category<span class="text-danger">*</span></label>
                                    <div class="col-md-8">
                                        <select class="form-control js-example-basic-multiple" name="category_id[]" id="category_id" data-live-search="true" required multiple>
                                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($category->slug); ?>"><?php echo e($category->name); ?></option>
                                                <?php $__currentLoopData = $category->subcategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $childCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php echo $__env->make('category.child_category', ['child_category' => $childCategory], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group row" id="brand">
                                    <label class="col-md-3 col-from-label"><?php echo e(('Brand')); ?> <span class="text-danger">*</span></label>
                                    <div class="col-md-8">
                                        <select class="form-control js-example-basic-multiple" name="brand_id[]" id="brand_id" data-live-search="true" multiple>
                                            <option value=""><?php echo e(('Select Brand')); ?></option>
                                            <?php $__currentLoopData = \App\Models\Brand::where('status',1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($brand->id); ?>"><?php echo e($brand->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="col-md-3 col-from-label"><?php echo e(('Unit')); ?> <span class="text-danger">*</span></label>
                                    <div class="col-md-8">
                                        <select class="form-control selectpicker" name="unit_id" id="unit_id" data-live-search="true">
                                            <option value=""><?php echo e(('Select Unit')); ?></option>
                                            <?php $__currentLoopData = \App\Models\Unit::where('status',1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($brand->id); ?>"><?php echo e($brand->unit_name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="col-md-3 col-from-label"><?php echo e(('Minimum Purchase Qty')); ?> <span class="text-danger">*</span></label>
                                    <div class="col-md-8">
                                        <input type="number" lang="en" class="form-control" name="minimum_purchase_qty" id="minimum_purchase_qty" value="1" min="1" required>
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="col-md-3 col-from-label">
                                        <?php echo e(('SKU')); ?> <span class="text-danger">*</span>
                                    </label>
                                    <div class="col-md-8">
                                        <input type="text" placeholder="<?php echo e(('SKU')); ?>" name="sku" id="sku" class="form-control">
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="col-md-3 col-form-label"><?php echo e(('Tags')); ?></label>
                                    <div class="col-md-8">
                                        <input type="text" class="form-control col-sm-12" name="tags" data-role="tagsinput" id="tags">

                                        <div id="tag-container" class="mt-2"></div>
                                        <small class="text-muted"><?php echo e(('This is used for search. Input those words by which customers can find this product.')); ?></small>
                                    </div>
                                </div>
                            </div>
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="mb-0 h6"><?php echo e(('Product Images')); ?></h5>
                                </div>
                                <div class="card-body">
                                    <div class="form-group row">
                                        
                                        <div class="col-md-12">
                                            <div class="row">
                                                <div class="form-group col-md-12 mb-0 text-center">
                                                    
                                                    <div class="col-md-12 px-0  text-center">
                                                        <div id="image" class="row">

                                                        </div>
                                                    </div>
                                                    <div class="text-center"><span class="text-muted">Height and Width ( 700 X 940 )and Format (png,jpg,jpeg,svg,webp)</span></div>
                                                    <input type="hidden" name="old_image" id="old_image" multiple>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="mb-0 h6">
                                    <?php echo e(('Shipping Configuration')); ?>

                                </h5>
                            </div>

                            <div class="card-body">
                                <div class="form-group row">
                                    <label class="col-md-9 col-from-label"><?php echo e('Free Shipping'); ?></label>
                                    <div class="col-md-3">
                                        <label class="aiz-switch aiz-switch-success mb-0">
                                            <input type="checkbox" name="shipping_type" value="free">
                                            <span></span>
                                        </label>
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="col-md-9 col-from-label"><?php echo e('Flat Rate'); ?></label>
                                    <div class="col-md-3">
                                        <label class="aiz-switch aiz-switch-success mb-0">
                                            <input type="checkbox" name="flat_rate" value="flat_rate">
                                            <span></span>
                                        </label>
                                    </div>
                                </div>

                                <div class="flat_rate_shipping_div" style="display: none">
                                    <div class="form-group row">
                                        <label class="col-md-9 col-from-label"><?php echo e(('Delivery/Service Charge')); ?></label>
                                        <div class="col-md-3">
                                            <input type="number" lang="en" min="0" value="0" step="0.01" placeholder="<?php echo e(('Shipping cost')); ?>" name="shipping_cost"
                                                   class="form-control" required>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group mb-3">
                                    <label for="name">
                                        <?php echo e(('Estimate Shipping Time')); ?>

                                    </label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" name="estimate_shipping_time" min="1" step="1" placeholder="<?php echo e(('Shipping Days')); ?>">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text" id="inputGroupPrepend"><?php echo e(('Days')); ?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card">
                            <div class="card-header">
                                <h5 class="mb-0 h6">
                                    <?php echo e(('Stock Visibility State')); ?>

                                </h5>
                            </div>

                            <div class="card-body">
                                <div class="form-group row">
                                    <label class="col-md-9 col-from-label"><?php echo e(('Show Stock Quantity')); ?></label>
                                    <div class="col-md-3">
                                        <label class="aiz-switch aiz-switch-success mb-0">
                                            <input type="checkbox" name="stock_visibility_state" value="1">
                                            <span></span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card">
                            <div class="card-header">
                                <h5 class="mb-0 h6 "> <?php echo e(('Others')); ?></h5>
                            </div>
                            <div class="card-body">
                                <div class="form-group row">
                                    <label class="col-md-9 col-from-label"><?php echo e(('Reseller Product')); ?></label>
                                    <div class="col-md-3">
                                        <label class="aiz-switch aiz-switch-success mb-0">
                                            <input type="checkbox" name="reseller_product" value="1">
                                            <span></span>
                                        </label>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="col-md-9 col-from-label"><?php echo e(('Landing Product')); ?></label>
                                    <div class="col-md-3">
                                        <label class="aiz-switch aiz-switch-success mb-0">
                                            <input type="checkbox" name="landing_product" value="1">
                                            <span></span>
                                        </label>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="col-md-9 col-from-label"><?php echo e(('New Arrival')); ?></label>
                                    <div class="col-md-3">
                                        <label class="aiz-switch aiz-switch-success mb-0">
                                            <input type="checkbox" name="new_arrival_status" value="1">
                                            <span></span>
                                        </label>
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="col-md-9 col-from-label"><?php echo e(('Featured')); ?></label>
                                    <div class="col-md-3">
                                        <label class="aiz-switch aiz-switch-success mb-0">
                                            <input type="checkbox" name="featured_status" value="1">
                                            <span></span>
                                        </label>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="col-md-9 col-from-label"> <?php echo e(('Ecommerce')); ?></label>
                                    <div class="col-md-3">
                                        <label class="aiz-switch aiz-switch-success mb-0">
                                            <input type="checkbox" name="hot_product_status" value="1">
                                            <span></span>
                                        </label>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="col-md-9 col-from-label"><?php echo e(('Publish/Unpublish')); ?></label>
                                    <div class="col-md-3">
                                        <label class="aiz-switch aiz-switch-success mb-0">
                                            <input type="checkbox" name="status" value="1" checked="">
                                            <span></span>
                                        </label>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="col-md-9 col-from-label"><?php echo e(('Whole Sell Product')); ?></label>
                                    <div class="col-md-3">
                                        <label class="aiz-switch aiz-switch-success mb-0">
                                            <input type="checkbox" name="whole_sell_product_status" value="1" checked="">
                                            <span></span>
                                        </label>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="col-md-9 col-from-label"><?php echo e(('Cash On Delivery')); ?></label>
                                    <div class="col-md-3">
                                        <label class="aiz-switch aiz-switch-success mb-0">
                                            <input type="checkbox" name="cash_on_delivery" value="1" checked="">
                                            <span></span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card">
                            <div class="card-header">
                                <h5 class="mb-0 h6"><?php echo e(('VAT & Tax')); ?></h5>
                            </div>
                            <div class="card-body">
                                <select name="tax_id" id="tax_id" required="required" class="form-control selectpicker">
                                    <option value="0" selected>No Tax</option>
                                    <?php if(!$taxes->isEmpty()): ?>
                                        <?php $__currentLoopData = $taxes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option
                                                value="<?php echo e($tax->id); ?>" <?php echo e(isset($product) ? (($product->tax_id == $tax->id) ? 'selected' : '')  : ''); ?>><?php echo e($tax->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </select>
                            </div>
                            <br><br><br><br>
                        </div>
                    </div>

                    <div class="col-lg-12">
                        <div class="card">
                            <div class="form-group row mt-6">
                                <div class="col-md-8"></div>
                                <label class="col-md-3 col-from-label"><h5 class="mb-0 h6"><?php echo e(('Product Variation')); ?></h5></label>
                                <div class="col-md-1">
                                    <label class="aiz-switch aiz-switch-success mb-0">
                                        <input type="checkbox" checked id="product_variation_status" name="product_variation_status" value="1">
                                        <span></span>
                                    </label>
                                </div>
                            </div>
                        </div>
                        <div class="card single_product" id="single_product_attr">
                            <div class="card-header">
                                <h5 class="mb-0 h6"><?php echo e(('Product Details')); ?></h5>
                            </div>
                            <div class="card-body">
                                <div class="form-group row">
                                    <label class="col-md-3 col-from-label">Product Code<span class="text-danger">*</span></label>
                                    <div class="col-md-8   form-group required code" style="margin-bottom: 0px;">
                                        <div class="input-group ">
                                            <input type="text" class="form-control" name="product_code" id="product_code">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text bg-primary" id="generate-code" data-toggle="tooltip" data-theme="dark" title="Generate Code"
                                                      style="border-top-right-radius: 0.42rem; border-bottom-right-radius: 0.42rem; border: 0; cursor: pointer;">
                                                    <i class="fas fa-retweet text-white"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="col-md-3 col-from-label"><?php echo e(('Stock Alert')); ?> <span class="text-danger"></span></label>
                                    <div class="col-md-8">
                                        <input type="number" lang="en" min="0" value="0" step="0.01" placeholder="<?php echo e(('Stock Alert Qty')); ?>" name="low_stock_quantity"
                                               id="low_stock_quantity" class="form-control" required>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="col-md-3 col-from-label"><?php echo e(('Unit price')); ?> <span class="text-danger"></span></label>
                                    <div class="col-md-8">
                                        <input type="number" lang="en" min="0" value="0" step="0.01" placeholder="<?php echo e(('Unit price')); ?>" name="unit_price" id="unit_price"
                                               class="form-control" required>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="col-md-3 col-from-label"><?php echo e(('Regular Price')); ?> <span class="text-danger">*</span></label>
                                    <div class="col-md-8">
                                        <input type="number" lang="en" min="0" value="0" step="0.01" placeholder="<?php echo e(('Regular Price')); ?>" name="regular_price" id="regular_price"
                                               class="form-control" required>
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="col-md-3 col-from-label"><?php echo e(('Discount')); ?> <span class="text-danger">*</span></label>
                                    <div class="col-md-6">
                                        <input type="number" lang="en" min="0" value="0" step="0.01" placeholder="<?php echo e(('Discount')); ?>" name="discount" id="discountValue"
                                               class="form-control" id="discountValue"
                                        >
                                    </div>
                                    <div class="col-md-2">
                                        <select class="form-control selectpicker" name="discount_type" id="discountType">
                                            <option value="amount"><?php echo e(('Flat')); ?></option>
                                            <option value="percent"><?php echo e(('Percent')); ?></option>
                                        </select>
                                    </div>
                                </div>
                                <div id="result"></div>
                                <div class="form-group row">
                                    <label class="col-md-3 col-from-label"><?php echo e(('Sale Price')); ?> <span class="text-danger">*</span></label>
                                    <div class="col-md-8">
                                        <input type="number" lang="en" min="0" value="0" step="0.01" placeholder="<?php echo e(('Sale Price')); ?>" name="sale_price" id="sale_price"
                                               class="form-control" required>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="col-md-3 col-from-label"><?php echo e(('WholeSale Price')); ?> <span class="text-danger"></span></label>
                                    <div class="col-md-8">
                                        <input type="number" lang="en" min="0" value="0" step="0.01" placeholder="<?php echo e(('WholeSale Price')); ?>" name="whole_sale_price"
                                               id="whole_sale_price" class="form-control">
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="col-md-3 col-from-label"><?php echo e(('Quantity')); ?> <span class="text-danger">*</span></label>
                                    <div class="col-md-8">
                                        <input type="number" lang="en" min="0" value="0" step="1" placeholder="<?php echo e(('Quantity')); ?>" name="qty" id="qty" class="form-control"
                                               required>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card variant_product" id="variant_product_attr" style="display: none">
                            <div class="card-header">
                                <h5 class="mb-0 h6"><?php echo e(('Product Variation')); ?></h5>
                            </div>
                            <div class="card-body">
                                <div class="form-group row gutters-5">
                                    <div class="col-md-3">
                                        <input type="text" readonly class="form-control" id="color_attr" value="<?php echo e(('Colors')); ?>">
                                    </div>
                                    <div class="col-md-8">
                                        <select class="form-control js-example-basic-multiple" multiple="multiple" style="width: 100%" name="colors[]" id="colors" disabled>
                                            <?php $__currentLoopData = \Modules\Product\Entities\Color::orderBy('name', 'asc')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                
                                                <option value="<?php echo e($color->code); ?>"
                                                        data-content="<span><span class='size-15px d-inline-block mr-2 rounded border' style='background:<?php echo e($color->code); ?>'></span><span><?php echo e($color->name); ?></span></span>"><?php echo e($color->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="col-md-1">
                                        <label class="aiz-switch aiz-switch-success mb-0">
                                            <input value="1" type="checkbox" name="colors_active">
                                            <span></span>
                                        </label>
                                    </div>
                                </div>

                                <div class="form-group row gutters-5">
                                    <div class="col-md-3">
                                        <input type="text" class="form-control" value="<?php echo e(('Attributes')); ?>" disabled>
                                    </div>
                                    <div class="col-md-8">
                                        <select name="attributes[]" id="attributes" class="form-control js-example-basic-multiple" data-count-selected-text="text"
                                                data-live-search="true" multiple data-placeholder="<?php echo e(('Choose Attributes')); ?>">
                                            <?php $__currentLoopData = \Modules\Product\Entities\Attribute::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $attribute): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($attribute->id); ?>"><?php echo e($attribute->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <div>
                                    <p><?php echo e(('Choose the attributes of this product and then input values of each attribute')); ?></p>
                                    <br>
                                </div>

                                <div class="customer_choice_options" id="customer_choice_options">

                                </div>
                                <br>
                                <div class="sku_combination" id="sku_combination">

                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-header">
                                <h5 class="mb-0 h6"><?php echo e(('Product Description')); ?></h5>
                            </div>
                            <div class="card-body">
                                <div class="form-group row">
                                    <label class="col-md-3 col-from-label"><?php echo e(('Description')); ?></label>
                                    <div class="col-md-8">
                                        <textarea class="summernote" name="description"></textarea>
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="col-md-3 col-from-label"><?php echo e(('Guide Line')); ?></label>
                                    <div class="col-md-8">
                                        <textarea class="summernote" name="guide_line"></textarea>
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="col-md-3 col-from-label"><?php echo e(('Size Chart')); ?></label>
                                    <div class="col-md-8">
                                        <textarea class="summernote" name="size_chart"></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-header">
                                <h5 class="mb-0 h6"><?php echo e(('PDF Specification')); ?></h5>
                            </div>
                            <div class="card-body">
                                <div class="form-group row">
                                    <label class="col-md-3 col-form-label" for="signinSrEmail"><?php echo e(('PDF Specification')); ?></label>
                                    <div class="col-md-8">
                                        <input type="file" name="pdf_file" id="pdf_file">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-header">
                                <h5 class="mb-0 h6"><?php echo e(('SEO Meta Tags')); ?></h5>
                            </div>
                            <div class="card-body">
                                <div class="form-group row">
                                    <label class="col-md-3 col-from-label"><?php echo e(('Meta Title')); ?></label>
                                    <div class="col-md-8">
                                        <input type="text" class="form-control col-sm-12" name="meta_tag" id="meta_tag" value="" data-role="tagsinput" id=""
                                               placeholder="<?php echo e(('Meta Title')); ?>">

                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="col-md-3 col-from-label"><?php echo e(('Description')); ?></label>
                                    <div class="col-md-8">
                                        <textarea name="meta_description" rows="8" class="form-control"></textarea>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="col-md-3 col-form-label" for="signinSrEmail"><?php echo e(('Meta Image')); ?></label>
                                    <div class="col-md-8">
                                        <input type="file" name="meta_image" id="meta_image">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-header">
                                <h5 class="mb-0 h6"><?php echo e(('Showrooms')); ?></h5>
                            </div>
                            <div class="card-body">
                                <div class="form-group row">
                                    <?php $__currentLoopData = \Modules\Setting\Entities\Showroom::where('status',1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <label class="col-md-4 col-from-label"><?php echo e($row->name); ?></label>
                                        <div class="col-md-2">
                                            <label class="aiz-switch aiz-switch-success mb-0">
                                                <input type="checkbox" name="showroom_id[]" value="<?php echo e($row->id); ?>" checked="">
                                                <span></span>
                                            </label><br>
                                        </div>
                                        <div class="col-md-6"></div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group col-md-12 pt-5 text-center ">
                        <button type="button" class="btn btn-primary btn-sm rounded" id="save-btn-1" onclick="storeData(1)">Save</button>
                    </div>
                </div>
            </form>
            <!--end::Card-->
        </div>

    </div>
    
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="js/spartan-multi-image-picker.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.9/summernote-bs4.js"></script>
    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js" integrity="sha384-UO2eT0CpHqdSJQ6hJty5KVphtPhzWj9WO1clHTMGa3JDZwrnQq4sF86dIHNDz0W1"
            crossorigin="anonymous"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/js/select2.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-tagsinput/0.8.0/bootstrap-tagsinput.min.js" crossorigin="anonymous"></script>
    <script>
        $(document).ready(function () {

            $('#regular_price').on('keyup', function () {
                calculateSalePrice();
            });
            $('#discountType').on('change', function () {
                $('#discountValue').val('0'); // Reset discount value to 0 when discount type changes
                calculateSalePrice();
            });
            $('#discountType, #discountValue').on('change keyup', function () {
                calculateSalePrice();
            });

            function calculateSalePrice() {
                var regular_price = parseFloat($('#regular_price').val());
                var discountType = $('#discountType').val();
                var discountValue = parseFloat($('#discountValue').val());

                if (isNaN(regular_price) || isNaN(discountValue)) {
                    // $('#result').text("Please enter valid numbers.");
                    return;
                }

                var sale_price = regular_price; // Initialize sale price with unit price

                if (discountType === 'percent') {
                    sale_price = regular_price - (regular_price * (discountValue / 100));
                } else if (discountType === 'amount') {
                    sale_price = regular_price - discountValue;
                }

                $('#sale_price').val(sale_price.toFixed(2));
            }
        });
    </script>
    <script>
        $(document).ready(function () {

            $("#product_variation_status").change(function () {
                if ($(this).is(":checked")) {
                    $("#single_product_attr").hide();
                    $("#variant_product_attr").show();
                } else {
                    $("#single_product_attr").show();
                    $("#variant_product_attr").hide();
                }
            });
            $('#product_variation_status').change();


            // Function to update the sale price based on discount
            function updateSalePrice(rowId) {
                var regularPrice = parseFloat($('#regular_price-' + rowId).val());
                var discountValue = parseFloat($('#discountValue-' + rowId).val());
                var discountType = $('#discountType-' + rowId).val();
                var sale_price;

                if (discountType === 'amount') {
                    sale_price = regularPrice - discountValue;
                } else if (discountType === 'percent') {
                    var discountAmount = (discountValue / 100) * regularPrice;
                    sale_price = regularPrice - discountAmount;
                }

                $('#sale_price-' + rowId).val(sale_price.toFixed(2));
            }

            // Attach change event handlers to discount fields
            $('[id^=discountValue-]').on('change', function () {
                var rowId = $(this).data('row');
                updateSalePrice(rowId);
            });

            $('[id^=discountType-]').on('change', function () {
                var rowId = $(this).data('row');
                updateSalePrice(rowId);
            });

            $('[id^=regular_price-]').on('change', function () {
                var rowId = $(this).data('row');
                updateSalePrice(rowId);
            });

            // Initial calculation on page load
            $('[id^=regular_price-]').each(function () {
                var rowId = $(this).data('row');
                updateSalePrice(rowId);
            });
        });
    </script>

    <script>
        $('.js-example-basic-multiple').each(function () {
            $(this).select2({
                placeholder: " Select ",
                theme: 'bootstrap4',
                width: 'style',
                allowClear: Boolean($(this).data('allow-clear')),
            });
        });
        $('#pieces').select2({
            tags: true
        });
        $('#show').on('click', function (e) {
            alert($('#pieces').val());
        });

        $(document).ready(function () {
            // Capture click event on trash button
            $(document).on('click', '.trash-button', function () {
                // Find the closest parent <tr> element
                var row = $(this).closest('tr');

                // Remove the row
                row.remove();
            });
        });
    </script>
    <script>
        $(function () {
            $("#product_variation_status").click(function () {
                if ($(this).is(":checked")) {
                    $("#single_product_attr").hide();
                    $("#variant_product_attr").show();
                } else {
                    $("#single_product_attr").show();
                    $("#variant_product_attr").hide();
                }
            });
        });

    </script>

    <script>
        $(document).ready(function () {
            $('.summernote').summernote({
                placeholder: '',
                tabsize: 2,
                height: 250
            });

            /** Start :: Product Image **/
            $("#image").spartanMultiImagePicker({
                fieldName: 'image[]',
                maxCount: 10,
                rowWeight: '350px',
                rowHeight: '470px',
                groupClassName: 'col-md-6 col-sm-12 col-xs-6',
                maxFileSize: '',
                dropFileLabel: "Drop Here",
                allowedExt: '',
                // onExtensionErr : function(index, file){
                //     Swal.fire({icon: 'error',title: 'Oops...',text: 'Only png,jpg,jpeg file format allowed!'});
                // },

            });

            // var inputElement = $("input[name='image[0]']");

            // inputElement.attr("id", "image_0");


            // $("#image_second").spartanMultiImagePicker({
            //     fieldName:        'image[1]',
            //     maxCount: 1,
            //     rowWeight:        '350px',
            //     rowHeight:        '470px',
            //     groupClassName:   'col-md-12 col-sm-12 col-xs-12',
            //     maxFileSize:      '',
            //     dropFileLabel : "Drop Here",
            //     allowedExt: '',
            //     // onExtensionErr : function(index, file){
            //     //     Swal.fire({icon: 'error',title: 'Oops...',text: 'Only png,jpg,jpeg file format allowed!'});
            //     // },

            // });

//             var inputElement_2 = $("input[name='image[1]']");

// // Set the id attribute for the input element
// inputElement_2.attr("id", "image_1");

            // $("input[name='image']").prop('required',true);

            $('.remove-files').on('click', function () {
                $(this).parents(".col-md-12").remove();
            });
            /** End :: Product Image **/

            //Generate Code
            $(document).on('click', '#generate-code', function () {
                $.ajax({
                    url: "<?php echo e(route('product.generate.code')); ?>",
                    type: "GET",
                    dataType: "JSON",
                    beforeSend: function () {
                        $('#generate-code').addClass('spinner spinner-white spinner-right');
                    },
                    complete: function () {
                        $('#generate-code').removeClass('spinner spinner-white spinner-right');
                    },
                    success: function (data) {
                        data ? $('#store_or_update_form #product_code').val(data) : $('#store_or_update_form #product_code').val('');
                    },
                    error: function (xhr, ajaxOption, thrownError) {
                        console.log(thrownError + '\r\n' + xhr.statusText + '\r\n' + xhr.responseText);
                    }
                });
            });
        });
    </script>

    <script type="text/javascript">
        $("[name=flat_rate]").on("change", function () {
            if ($(this).is(":checked")) {
                $(".flat_rate_shipping_div").show();
            } else {
                $(".flat_rate_shipping_div").hide();
            }
        });

        function add_more_customer_choice_option(i, name) {
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                type: "POST",
                url: '<?php echo e(route('products.more.choice.option')); ?>',
                data: {
                    attribute_id: i
                },
                success: function (data) {
                    var obj = JSON.parse(data);

                    $('#customer_choice_options').append('\
                <div class="form-group row">\
                    <div class="col-md-3">\
                        <input type="hidden" name="choice_no[]" value="' + i + '">\
                        <input type="hidden" name="attr_id[]" id="attr_options_' + i + '" >\
                        <input type="text" class="form-control" name="choice[]" value="' + name + '" placeholder="<?php echo e('Choice Title'); ?>" readonly>\
                    </div>\
                    <div class="col-md-8">\
                        <select class="form-control selectpicker attribute_choice"\
                         onchange="AttributeCheck(this, ' + i + ')"  data-live-search="true" name="choice_options_' + i + '[]" multiple>\
                            ' + obj + '\
                        </select>\
                    </div>\
                </div>');
                    // AIZ.plugins.bootstrapSelect('refresh');
                    $('.selectpicker').selectpicker('refresh');
                }
            });


        }

        function AttributeCheck(selectElement, index) {
            var selectedIds = Array.from(selectElement.selectedOptions).map(option => option.value);
            var resultArray = {};
            resultArray[index] = selectedIds;
            // Now you can work with the resultArray
            console.log("Result array:", resultArray);
            let new_value = JSON.stringify(resultArray);

            $(`#attr_options_${index}`).val(new_value);

            // Now you can work with the selectedIds array, for example, send it to the server or perform other actions
        }

        $('input[name="colors_active"]').on('change', function () {
            if (!$('input[name="colors_active"]').is(':checked')) {
                $('#colors').prop('disabled', true);
                $('.selectpicker').selectpicker('refresh');
                // AIZ.plugins.bootstrapSelect('refresh');
            } else {
                $('#colors').prop('disabled', false);

                $('.selectpicker').selectpicker('refresh');
                // AIZ.plugins.bootstrapSelect('refresh');
            }
            update_sku();
        });

        $(document).on("change", ".attribute_choice", function () {
            update_sku();
        });

        $('#colors').on('change', function () {
            update_sku();
        });

        $('input[name="unit_price"]').on('keyup', function () {
            update_sku();
        });

        $('input[name="name"]').on('keyup', function () {
            update_sku();
        });

        function delete_row(em) {
            $(em).closest('.form-group row').remove();
            update_sku();
        }

        function delete_variant(em) {
            $(em).closest('.variant').remove();
        }

        function update_sku() {
            $.ajax({
                type: "POST",
                url: '<?php echo e(route('products.sku_combination')); ?>',
                data: $('#store_or_update_form').serialize(),
                cache: false,
                success: function (data) {
                    console.log(data);
                    $('#sku_combination').html(data);
                    if (data.length > 1) {

                        $('#show-hide-div').hide();
                    } else {

                        $('#show-hide-div').show();
                    }
                }
            });
        }

        $('#attributes').on('change', function () {
            $('#customer_choice_options').html(null);
            $.each($("#attributes option:selected"), function () {
                add_more_customer_choice_option($(this).val(), $(this).text());
            });

            update_sku();
        });

        function storeData(btn) {
            let form = document.getElementById('store_or_update_form');
            let formData = new FormData(form);


            $.ajax({
                url: "<?php echo e(route('product.store')); ?>",
                type: "POST",
                data: formData,
                dataType: "JSON",
                contentType: false,
                processData: false,
                cache: false,
                beforeSend: function () {
                    $('#save-btn-' + btn).addClass('spinner spinner-white spinner-right');
                },
                complete: function () {
                    $('#save-btn-' + btn).removeClass('spinner spinner-white spinner-right');
                },
                success: function (data) {
                    $('#store_or_update_form').find('.is-invalid').removeClass('is-invalid');
                    $('#store_or_update_form').find('.error').remove();
                    if (data.status == false) {
                        $.each(data.errors, function (key, value) {

                            console.log(key, value);
                            var key = key.split('.').join('_');
                            $('#store_or_update_form input#' + key).addClass('is-invalid');
                            $('#store_or_update_form textarea#' + key).addClass('is-invalid');
                            $('#store_or_update_form select#' + key).parent().addClass('is-invalid');
                            if (key == 'code') {
                                $('#store_or_update_form #' + key).parents('.form-group').append(
                                    '<small class="error text-danger">' + value + '</small>');
                            } else {
                                $('#store_or_update_form #' + key).parent().append(
                                    '<small class="error text-danger">' + value + '</small>');
                            }
                        });

                        $('html, body').animate({
                            scrollTop: ($('.is-invalid').offset().top - 300)
                        }, 1000);

                    } else {
                        notification(data.status, data.message);
                        if (data.status == 'success') {
                            if (btn == 1) {
                                window.location.replace("<?php echo e(route('product')); ?>");
                            } else {
                                window.location.replace("<?php echo e(route('product.add')); ?>");
                            }
                        }
                    }
                },
                error: function (xhr, ajaxOption, thrownError) {
                    console.log(thrownError + '\r\n' + xhr.statusText + '\r\n' + xhr.responseText);
                }
            });
        }

        function generate_variants_code(row) {
            $.ajax({
                url: "<?php echo e(route('product.variant.generate.code')); ?>",
                type: "GET",
                dataType: "JSON",
                beforeSend: function () {
                    $('#generate-' + row + '-code').addClass('spinner spinner-white spinner-right');
                },
                complete: function () {
                    $('#generate-' + row + '-code').removeClass('spinner spinner-white spinner-right');
                },
                success: function (data) {
                    data ? $('#product_attribute_' + row + '_product_code').val(data) : $('#product_attribute_' + row + '_product_code').val('');
                },
                error: function (xhr, ajaxOption, thrownError) {
                    console.log(thrownError + '\r\n' + xhr.statusText + '\r\n' + xhr.responseText);
                }
            });
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iconshoppercom/iconshopper/Modules/Product/Resources/views/create.blade.php ENDPATH**/ ?>