
<?php $__env->startSection('title','Dashboard'); ?>
<?php $__env->startPush('styles'); ?>
    <link href="plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css"/>
    <link href="css/daterangepicker.min.css" rel="stylesheet" type="text/css"/>
    <style>
        .today-btn {
            border-radius: 5px 0 0 5px !important;
        }

        .week-btn, .month-btn {
            border-radius: 0 !important;
        }

        .year-btn {
            border-radius: 0 5px 5px 0 !important;
        }

        .icon {
            width: 40px;
            height: 40px;
        }

        .business-analytics {
            max-width: 24%;
            background-color: #fff;
            margin-bottom: 10px;
            border-radius: 10px;
            padding: 40px 30px 20px;
            position: relative;
            border: 1px solid rgba(180, 208, 224, 0.5);
            box-shadow: 0px 5px 10px rgba(0, 0, 0, 0.05);
            height: 100%;
            transition: all 0.3s ease;
        }

        .business-analytics__subtitle {
            font-size: 17px;
            margin-bottom: 10px;
            font-weight: 600;
        }

        .business-analytics__title {
            font-weight: 500;
            font-size: 24px;
        }

        .business-analytics__img {
            position: absolute;
            inset-block-start: 16px;
            inset-inline-end: 16px;
        }

        .order-stats {
            font-family: 'Font Awesome 5 Free';
            background-color: #dfdfe6;
            border-radius: 10px;
            padding: 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            /*gap: 10px;*/
            /*height: 100%;*/
            transition: all 0.3s ease;
        }

        .order-stats2 {
            max-width: 23%;
            background-color: #efedeb;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 15px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            transition: all 0.3s ease;
        }

        .order-stats__content {
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .order-stats__title {
            /*color: #0661cb;*/
            font-size: 18px;
            font-weight: 700;
        }

        .order-stats__subtitle {
            font-weight: 600;
            font-size: 15px;
            color: #334257;
            margin-bottom: 0;
        }
    </style>
    <style>
        .alert {
            padding: 7px;
            background-color: #f44336;
            color: white;
        }

        .closebtn {
            margin-left: 15px;
            color: white;
            font-weight: bold;
            float: right;
            font-size: 22px;
            line-height: 20px;
            cursor: pointer;
            transition: 0.3s;
        }

        .closebtn:hover {
            color: black;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <?php if(\Illuminate\Support\Facades\Auth::user()->role_id == 1): ?>
        <div class="d-flex flex-column-fluid">
            <div class="container-fluid">
                <div class="row">
                    <div class="form-group col-md-6">
                        <div class="mx-auto">
                            <form method="POST" id="form-filter">
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label for="name">Choose Your Date</label>
                                        <div class="input-group">
                                            <input type="text" class="form-control daterangepicker-filed">
                                            <input type="hidden" id="start_date" name="start_date">
                                            <input type="hidden" id="end_date" name="end_date">
                                        </div>
                                    </div>
                                    <div style="margin-top:28px;">
                                        <button id="btn-reset" class="btn btn-danger btn-sm btn-elevate btn-icon float-right" type="button"
                                                data-toggle="tooltip" data-theme="dark" title="Reset"><i class="fas fa-undo-alt"></i></button>

                                        <button id="btn-filter" class="btn btn-primary btn-sm btn-elevate btn-icon mr-2 float-right" type="button"
                                                data-toggle="tooltip" data-theme="dark" title="Search"><i class="fas fa-search"></i></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <h5>Notice Board</h5>
                            <?php
                                $notice = \Modules\Setting\Entities\NoticeBoard::latest()->first();
                            ?>

                        <a href="<?php echo e(route('manage-notice')); ?>">
                            <div class="alert">
                                <span class="closebtn" onclick="this.parentElement.style.display='none';">&times;</span>
                                <?php if($notice): ?>
                                    <?php echo Str::words($notice->details, 12, ' ...'); ?>

                                <?php else: ?>
                                    No notice available.
                                <?php endif; ?>
                            </div>
                        </a>
                    </div>
                </div>
                <div class="row order-stats">
                    <div class="col-md-3 business-analytics">
                        <div class="text-primary">
                            <h3 class="business-analytics__subtitle">Total Customer</h3>
                            <h3 class="business-analytics__title" id="customer"><?php echo e(0); ?></h3>
                        </div>
                    </div>
                    <div class="col-md-3 business-analytics">
                        <div class="text-primary">
                            <h3 class="business-analytics__subtitle">Total Supplier</h3>
                            <h3 class="business-analytics__title" id="supplier"><?php echo e(0); ?></h3>
                        </div>
                    </div>
                    <div class="col-md-3 business-analytics">
                        <div class="text-primary">
                            <h3 class="business-analytics__subtitle">Total User</h3>
                            <h3 class="business-analytics__title" id="user"><?php echo e(0); ?></h3>
                        </div>
                    </div>
                    <div class="col-md-3 business-analytics">
                        <div class="text-primary">
                            <h3 class="business-analytics__subtitle">Total Purchase</h3>
                            <h3 class="business-analytics__title" id="purchase"><?php echo e(0); ?> ৳</h3>
                        </div>
                    </div>

                    <div class="col-md-3 business-analytics">
                        <div class="text-primary">
                            <h3 class="business-analytics__subtitle">Total Sale</h3>
                            <h3 class="business-analytics__title" id="sale"><?php echo e(0); ?> ৳</h3>
                        </div>
                    </div>
                    <div class="col-md-3 business-analytics">
                        <div class="text-primary">
                            <h3 class="business-analytics__subtitle">Total Collection</h3>
                            <h3 class="business-analytics__title" id="income"><?php echo e(0); ?> ৳</h3>
                        </div>
                    </div>
                    <div class="col-md-3 business-analytics">
                        <div class="text-primary">
                            <h5 class="business-analytics__subtitle">Bank</h5>
                            <h6 class="business-analytics__title" id="bank"><?php echo e(0); ?> ৳</h6>
                        </div>
                    </div>
                    <div class="col-md-3 business-analytics">
                        <div class="text-primary">
                            <h3 class="business-analytics__subtitle">Mobile Bank</h3>
                            <h3 class="business-analytics__title" id="mobile_bank"><?php echo e(0); ?> ৳</h3>
                        </div>
                    </div>

                    <div class="col-md-3 business-analytics">
                        <div class="text-primary">
                            <h6 class="business-analytics__subtitle">Total Cash</h6>
                            <h6 class="business-analytics__title" id="cash"><?php echo e(0); ?> ৳</h6>
                        </div>
                    </div>
                    <div class="col-md-3 business-analytics">
                        <div class="text-primary">
                            <h3 class="business-analytics__subtitle">Total Product</h3>
                            <?php
                                $product = \Illuminate\Support\Facades\DB::table('products')->where('status', 1)->count('id');
                            ?>
                            <h3 class="business-analytics__title" id="product"><?php echo e($product); ?></h3>
                        </div>
                    </div>
                    <div class="col-md-3 business-analytics">
                        <div class="text-primary">
                            <h3 class="business-analytics__subtitle">Total Showroom</h3>
                            <?php
                                $showroom = \Illuminate\Support\Facades\DB::table('showrooms')->where('status', 1)->count('id');
                            ?>
                            <h3 class="business-analytics__title" id="showroom"><?php echo e($showroom); ?></h3>
                        </div>
                    </div>
                    <div class="col-md-3 business-analytics">
                        <div class="text-primary">
                            <h3 class="business-analytics__subtitle">Total Expense</h3>
                            <h3 class="business-analytics__title" id="expense"><?php echo e(0); ?> ৳</h3>
                        </div>
                    </div>
                    <?php if(permission('net-profit-access')): ?>
                        <div class="col-md-3 business-analytics">
                            <div class="text-primary">
                                <h3 class="business-analytics__subtitle">Net Profit</h3>
                                <h3 class="business-analytics__title" id="net_profit"><?php echo e(0); ?> ৳</h3>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        
        <div class="d-flex flex-column-fluid">
            <div class="container-fluid">
                <h2 class="text-left mt-12 display-4 text-primary"><strong>Cash</strong></h2>
                <div class="row order-stats">
                    <?php $__currentLoopData = $cash_in_hands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cash_in_hand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $coa = \Modules\Account\Entities\ChartOfAccount::where('cash_id', $cash_in_hand->id)->first();

                            if ($coa) {
                                $balance = \Modules\Account\Entities\Transaction::where('chart_of_account_id', $coa->id)->groupBy('chart_of_account_id')->sum('debit');
                            } else {
                                $balance = 0;
                            }
                        ?>
                        <div class="col-md-4 business-analytics">
                            <div class="text-primary">
                                <h3 class="business-analytics__subtitle"><?php echo e($cash_in_hand->bank_name); ?></h3>
                                <h3 class="business-analytics__title" id=""><?php echo e($balance); ?> ৳</h3>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>

        
        <div class="d-flex flex-column-fluid">
            <div class="container-fluid">
                <h2 class="text-left mt-12 display-4 text-primary"><strong>Banks</strong></h2>
                <div class="row order-stats">
                    <?php $__currentLoopData = $banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $coa = \Modules\Account\Entities\ChartOfAccount::where('bank_id', $bank->id)->first();

                            if ($coa) {
                                $balance = \Modules\Account\Entities\Transaction::where('chart_of_account_id', $coa->id)->groupBy('chart_of_account_id')->sum('debit');
                            } else {
                                $balance = 0;
                            }
                        ?>
                        <div class="col-md-4 business-analytics">
                            <div class="bg-white text-center py-3 text-primary bold">
                                <h3 class="business-analytics__subtitle"><?php echo e($bank->bank_name); ?></h3>
                                <h3 class="business-analytics__title" id=""><?php echo e($balance); ?> ৳</h3>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>

        
        <div class="d-flex flex-column-fluid">
            <div class="container-fluid">
                <h2 class="text-left mt-12 display-4 text-primary"><strong>Mobile Banks</strong></h2>
                <div class="row order-stats">
                    <?php $__currentLoopData = $mobile_banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mobile_bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $coa_id = \Modules\Account\Entities\ChartOfAccount::where('mobile_bank_id', $mobile_bank->id)->select('id')->first();
                            if ($coa_id) {
                                $balance = \Modules\Account\Entities\Transaction::where('chart_of_account_id', $coa_id->id)->groupBy('chart_of_account_id')->sum('debit');
                            } else {
                                $balance = 0;
                            }
                        ?>
                        <div class="col-md-4 business-analytics">
                            <div class="text-primary">
                                <h3 class="business-analytics__subtitle"><?php echo e($mobile_bank->bank_name); ?></h3>
                                <h3 class="business-analytics__title" id=""><?php echo e($balance); ?> ৳</h3>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>

        
        <div class="d-flex flex-column-fluid">
            <div class="container-fluid">
                <h2 class="text-left mt-12 display-4 text-primary"><strong>Top Data</strong></h2>
                <div class="row order-stats">
                    <div class="col-md-6 business-analytics">
                        <div class="text-primary">
                            <h3 class="business-analytics__subtitle">Top Customers</h3>
                            <table class="table table-bordered">
                                <thead class="bg-primary">
                                <tr>
                                    <th></th>
                                    <th>Name</th>
                                    <th>Total Value</th>
                                </tr>
                                </thead>
                                <tbody id="top_customer_list"></tbody>
                            </table>
                        </div>
                    </div>

                    <div class="col-md-6 business-analytics">
                        <div class="text-primary">
                            <h3 class="business-analytics__subtitle">Top Users</h3>
                            <table class="table table-bordered">
                                <thead class="bg-primary">
                                <tr>
                                    <th></th>
                                    <th>Name</th>
                                    <th>Total Value</th>
                                </tr>
                                </thead>
                                <tbody id="top_user_list"></tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script src="plugins/custom/datatables/datatables.bundle.js" type="text/javascript"></script>
    <script src="js/moment.js"></script>
    <script src="js/knockout-3.4.2.js"></script>
    <script src="js/daterangepicker.min.js"></script>
    <script>
        $('.daterangepicker-filed').daterangepicker({
            callback: function (startDate, endDate) {
                var start_date = startDate.format('YYYY-MM-DD');
                var end_date = endDate.format('YYYY-MM-DD');
                var title = start_date + ' To ' + end_date;
                $(this).val(title);
                $('input[name="start_date"]').val(start_date);
                $('input[name="end_date"]').val(end_date);
            }
        });

        $(document).ready(function () {
            loadData("<?php echo e(date('Y-m-d')); ?>", "<?php echo e(date('Y-m-d')); ?>");
            $('.data-btn').on('click', function () {
                $('.data-btn').removeClass('active');
                $(this).addClass('active');
                var start_date = $(this).data('start_date');
                var end_date = $(this).data('end_date');
                loadData(start_date, end_date);
            });

            function loadData(start_date, end_date) {
                $.get("<?php echo e(url('dashboard-data')); ?>/" + start_date + '/' + end_date, function (data) {
                    $('#customer').text((data.customer));
                    $('#supplier').text((data.supplier));
                    $('#user').text((data.user));
                    $('#purchase').text((data.purchase) + ' ৳');
                    $('#sale').text((data.sale) + ' ৳');
                    $('#income').text((data.income) + ' ৳');
                    $('#expense').text((data.expense) + ' ৳');
                    $('#net_profit').text((data.net_profit) + ' ৳');

                    let topCustomerHtml = '';
                    let topUserHtml = '';

                    data.top_customer.forEach(function (top_customer, index) {
                        topCustomerHtml += '<tr>';
                        topCustomerHtml += '<td>' + (index + 1) + '</td>';
                        topCustomerHtml += '<td>' + top_customer.name + ' (' + (top_customer.phone ?? top_customer.mobile) + ')</td>';
                        topCustomerHtml += '<td>' + top_customer.total_value.toFixed(2) + ' ৳ (' + top_customer.total_order + ')</td>';
                        topCustomerHtml += '</tr>';
                    });
                    data.top_user.forEach(function (top_user, index) {
                        topUserHtml += '<tr>';
                        topUserHtml += '<td>' + (index + 1) + '</td>';
                        topUserHtml += '<td>' + top_user.name + ' (' + top_user.phone + ')</td>';
                        topUserHtml += '<td>' + top_user.total_value.toFixed(2) + ' ৳ (' + top_user.total_order + ')</td>';
                        topUserHtml += '</tr>';
                    });

                    $('#top_user_list').html(topUserHtml);
                    $('#top_customer_list').html(topCustomerHtml);
                });

                $.get("<?php echo e(url('ecom-dashboard')); ?>/" + start_date + '/' + end_date, function (data) {
                    $('#ecom_total_order').text(data.total_order);
                    $('#ecom_total_sale').text((data.total_sale) + ' ৳');
                    $('#ecom_total_income').text((data.total_income) + ' ৳');
                    $('#ecom_total_due').text((data.total_due) + ' ৳');
                    $('#ecom_sale_profit').text((data.sale_profit) + ' ৳');
                    $('#ecom_new_order').text((data.new_order));
                    $('#ecom_new_order_value').text((data.new_order_value) + ' ৳');
                    $('#ecom_pending_order').text((data.pending_order));
                    $('#ecom_pending_order_value').text((data.pending_order_value) + ' ৳');
                    $('#ecom_pending_payment').text((data.pending_payment));
                    $('#ecom_pending_payment_value').text((data.pending_payment_value) + ' ৳');
                    $('#ecom_confirm_order').text((data.confirm_order));
                    $('#ecom_confirm_order_value').text((data.confirm_order_value) + ' ৳');
                    $('#ecom_hold_order').text((data.hold_order));
                    $('#ecom_hold_order_value').text((data.hold_order_value) + ' ৳');
                    $('#ecom_processing_order').text((data.processing_order));
                    $('#ecom_processing_order_value').text((data.processing_order_value) + ' ৳');
                    $('#ecom_send_to_courier').text((data.send_to_courier));
                    $('#ecom_send_to_courier_value').text((data.send_to_courier_value) + ' ৳');
                    $('#ecom_assign_to_rider').text((data.assign_to_rider));
                    $('#ecom_assign_to_rider_value').text((data.assign_to_rider_value) + ' ৳');
                    $('#ecom_delivered_order').text((data.delivered_order));
                    $('#ecom_delivered_order_value').text((data.delivered_order_value) + ' ৳');
                    $('#ecom_returned_order').text((data.returned_order));
                    $('#ecom_returned_order_value').text((data.returned_order_value) + ' ৳');
                    $('#ecom_exchange_order').text((data.exchange_order));
                    $('#ecom_exchange_order_value').text((data.exchange_order_value) + ' ৳');
                    $('#ecom_cancel_order').text((data.cancel_order));
                    $('#ecom_cancel_order_value').text((data.cancel_order_value) + ' ৳');
                });

                $.get("<?php echo e(url('wholesale-dashboard')); ?>/" + start_date + '/' + end_date, function (data) {
                    $('#wholesale_total_order').text(data.total_order);
                    $('#wholesale_total_sale').text((data.total_sale) + ' ৳');
                    $('#wholesale_total_income').text((data.total_income) + ' ৳');
                    $('#wholesale_total_due').text((data.total_due) + ' ৳');
                    $('#wholesale_net_profit').text((data.sale_profit) + ' ৳');
                    $('#wholesale_returned_order').text(data.returned_order);
                    $('#wholesale_exchange_order').text(data.exchange_order);
                });

                load_filter_showroom(start_date, end_date);
            }

            $('#btn-filter').click(function () {
                var start_date = $('input[name="start_date"]').val();
                var end_date = $('input[name="end_date"]').val();
                loadData(start_date, end_date);
            });
            $('#btn-reset').click(function () {
                $('#form-filter')[0].reset();
                $('#form-filter #start_date').val("");
                $('#form-filter #end_date').val("");
                loadData("<?php echo e(date('Y-m-d')); ?>", "<?php echo e(date('Y-m-d')); ?>");
                $('.data-btn').removeClass('active');
                $('.today-btn').addClass('active');
            });
        });

        function load_filter_showroom(start_date, end_date) {
            var showroomId = new URLSearchParams(window.location.search).get('showroom_id');
            // console.log(showroomId);

            $.get("<?php echo e(url('pos-dashboard')); ?>/" + start_date + '/' + end_date, {showroom_id: showroomId}, function (data) {
                $('#pos_total_order').text(data.total_order);
                $('#pos_total_sale').text((data.total_sale) + ' ৳');
                $('#pos_total_income').text((data.total_income) + ' ৳');
                $('#pos_total_due').text((data.total_due) + ' ৳');
                $('#pos_net_profit').text((data.net_profit) + ' ৳');
                $('#pos_returned_order').text(data.returned_order);
                $('#pos_exchange_order').text(data.exchange_order);
            });
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iconshoppercom/iconshopper/resources/views/home.blade.php ENDPATH**/ ?>